/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.UserUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.gtis.web.action.TaskListActionAbstract;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class TaskListAction
extends TaskListActionAbstract {
    private static final String IBATIS_QUERY_NAME = "getTaskList";
    boolean hasExport = false;
    String taskState;
    SysAuthorService authorService;
    String rid;
    String userName;

    public String getUserName() {
        return this.userName;
    }

    public String getRid() {
        return this.rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }

    public SysAuthorService getAuthorService() {
        return this.authorService;
    }

    public boolean isHasExport() {
        return this.hasExport;
    }

    public void setHasExport(boolean hasExport) {
        this.hasExport = hasExport;
    }

    public String getTaskState() {
        return this.taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public String execute() throws Exception {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            this.hasExport = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List lstfPartitions = this.authorService.getSystemResrouceFunAuthorList(roles, this.rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u5bfc\u51fa") && !partitionInfoVo.getElementName().equalsIgnoreCase("export")) continue;
                    this.hasExport = true;
                    break;
                }
            }
        }
        this.userName = SessionUtil.getCurrentUser().getUsername();
        return super.execute();
    }

    public String overtime() throws Exception {
        super.execute();
        SplitParamImpl splitParam1 = new SplitParamImpl();
        splitParam1.setQueryString(this.getIbatisQueryName());
        HashMap mapParam = this.getParam();
        mapParam.put("TASK_STATE", "1");
        splitParam1.setQueryParam((Serializable)mapParam);
        this.setSplitParam((SplitParam)splitParam1);
        this.taskState = "1";
        return "success";
    }

    public String getIbatisQueryName() {
        return IBATIS_QUERY_NAME;
    }

    public HashMap<String, String> getParam() {
        HashMap mapParam = super.getParam();
        UserUtil.setTaskUserMapIds((Map)mapParam);
        if (StringUtils.isNotBlank((CharSequence)AppConfig.getProperty((String)"tasklisk.orderfield"))) {
            mapParam.put("_orderfield_", AppConfig.getProperty((String)"tasklisk.orderfield"));
        }
        return mapParam;
    }

    public String agent() {
        SplitParamImpl splitParam = new SplitParamImpl();
        splitParam.setQueryString("getTaskAgentList");
        HashMap<String, List> paramMap = new HashMap<String, List>();
        List agentList = this.getUserService().getAgentUserList(SessionUtil.getCurrentUser().getId());
        if (agentList.isEmpty()) {
            paramMap.put("agentList", null);
        } else {
            paramMap.put("agentList", agentList);
        }
        splitParam.setQueryParam(paramMap);
        this.setSplitParam((SplitParam)splitParam);
        this.setLstWorkFlowDefine(this.getWorkFlowDefineService().getWorkFlowDefineList());
        PfWorkFlowDefineVo vo = new PfWorkFlowDefineVo();
        vo.setWorkflowName("----\u6240\u6709\u4e1a\u52a1----");
        vo.setWorkflowDefinitionId("");
        this.getLstWorkFlowDefine().add(0, vo);
        this.setBusinessList(this.getWorkFlowDefineService().getBusinessList());
        PfBusinessVo pbv = new PfBusinessVo();
        pbv.setBusinessName("----\u6240\u6709\u4e1a\u52a1----");
        pbv.setBusinessId("");
        this.getBusinessList().add(0, pbv);
        this.configVo = SessionUtil.getUserConfig((HttpServletRequest)ServletActionContext.getRequest());
        ServletActionContext.getRequest().setAttribute("USERID", (Object)SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()));
        return "success";
    }
}

