/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.model.ActivityModel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class TaskEntrustAction {
    SysUserService userService;
    WorkFlowCoreService workFlowService;
    SysTaskService taskService;
    SysWorkFlowInstanceService worFlowInstanceService;
    String taskid;
    String userId;
    List<PfOrganVo> organVoList;
    String organId;
    private static final String CONTENT_TYPE = "text/json; charset=utf-8";
    private static final Log log = LogFactory.getLog(TaskEntrustAction.class);

    public SysTaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysWorkFlowInstanceService getWorFlowInstanceService() {
        return this.worFlowInstanceService;
    }

    public void setWorFlowInstanceService(SysWorkFlowInstanceService worFlowInstanceService) {
        this.worFlowInstanceService = worFlowInstanceService;
    }

    public String getOrganId() {
        return this.organId;
    }

    public void setOrganId(String organId) {
        this.organId = organId;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public List<PfOrganVo> getOrganVoList() {
        return this.organVoList;
    }

    public WorkFlowCoreService getWorkFlowService() {
        return this.workFlowService;
    }

    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }

    private void initTrustUser() {
        List userList;
        PfTaskVo taskVo = this.taskService.getTask(this.taskid);
        PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
        String xmlModel = this.worFlowInstanceService.getWorkflowInstanceXml(this.worFlowInstanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId()));
        WorkFlowXml workXml = new WorkFlowXml(xmlModel);
        ActivityModel sourceActivityModel = workXml.getActivity(activityVo.getActivityDefinitionId());
        String userName = sourceActivityModel.getExtendedAttribute("DefaultTrustUserName");
        if (StringUtils.isNotBlank((CharSequence)userName) && (userList = this.userService.getUserVoListByUserName(userName)).size() > 0) {
            this.userId = ((PfUserVo)userList.get(0)).getUserId();
            List organList = this.userService.getOrganListByUser(this.userId);
            if (organList.size() > 0) {
                this.organId = ((PfOrganVo)organList.get(0)).getOrganId();
            }
        }
    }

    public String execute() throws Exception {
        this.organVoList = this.userService.getOrganList();
        if (StringUtils.isNotBlank((CharSequence)this.taskid)) {
            this.initTrustUser();
        }
        return "success";
    }

    public String Users() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.organId)) {
            List userVoList = this.userService.getUserListByOragn(this.organId);
            ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson((Object)userVoList));
            ServletActionContext.getResponse().getWriter().flush();
        }
        return "none";
    }

    public String Trust() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.taskid) && StringUtils.isNotBlank((CharSequence)this.userId)) {
            try {
                this.workFlowService.entrustTask(this.taskid, this.userId);
                ServletActionContext.getResponse().getWriter().println("true");
            }
            catch (Exception e) {
                ServletActionContext.getResponse().getWriter().println(e.getMessage());
            }
        }
        return "none";
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

