/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.BaseDao;
import com.gtis.plat.service.SysDynamicSignService;
import com.gtis.plat.service.SysStuffService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SessionUtil;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class TaskAction {
    private String taskid;
    private WorkFlowCoreService workFlowService;
    private SysTaskService taskService;
    private SysWorkFlowInstanceService intanceService;
    private SysStuffService stuffService;
    private SysDynamicSignService dynamicSignService;
    private BaseDao sjdDaoImpl;
    private NodeService nodeService;
    private String remark;
    private String wiid;
    static final Log log = LogFactory.getLog(TaskAction.class);

    public String getWiid() {
        return this.wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public WorkFlowCoreService getWorkFlowService() {
        return this.workFlowService;
    }

    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }

    public String delOtherTasks() throws Exception {
        PfTaskVo taskVo = this.taskService.getTask(this.taskid);
        if (taskVo != null) {
            this.taskService.deleteOtherTasks(this.taskid);
            ServletActionContext.getResponse().getWriter().println("true");
        } else {
            ServletActionContext.getResponse().getWriter().println("\u8be5\u4efb\u52a1\u5df2\u88ab\u522b\u4eba\u53d6\u4ef6\uff01");
        }
        return "none";
    }

    public String execute() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        try {
            WorkFlowInfo info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
            List lstActivityModel = info.getTransInfo().getTranActivitys();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
            ActivityModel activityModel = workXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
            if (StringUtils.isBlank((String)activityModel.getSplitType()) || activityModel.getSplitType().equalsIgnoreCase("XOR")) {
                int i = 0;
                Iterator it = lstActivityModel.iterator();
                while (it.hasNext()) {
                    if (i > 0) {
                        it.remove();
                    }
                    it.next();
                    ++i;
                }
            }
            this.workFlowService.postWorkFlow(userId, this.taskid, info);
        }
        catch (WorkFlowException wfex) {
            log.debug((Object)wfex.getMessage());
            ServletActionContext.getResponse().getWriter().println(wfex.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return "none";
    }

    public String del() throws Exception {
        PfTaskVo taskVo = this.taskService.getTask(this.taskid);
        switch (this.permitDel(taskVo)) {
            case 0: {
                this.delProject(taskVo);
                ServletActionContext.getResponse().getWriter().println(1);
                break;
            }
            case 1: {
                this.delProject(taskVo);
                ServletActionContext.getResponse().getWriter().println(1);
                break;
            }
            default: {
                ServletActionContext.getResponse().getWriter().println(2);
            }
        }
        return "none";
    }

    private String delProject(PfTaskVo taskVo) throws Exception {
        PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
        this.wiid = activityVo.getWorkflowInstanceId();
        this.delProject();
        return "none";
    }

    public String restartProject() throws Exception {
        boolean restart = this.workFlowService.restartWorkFlow(SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()), this.wiid, null);
        ServletActionContext.getResponse().getWriter().println(restart);
        return "none";
    }

    public String delProject() throws Exception {
        PfWorkFlowInstanceVo workFlowInstanceVo = this.intanceService.getWorkflowInstance(this.wiid);
        try {
            PfWorkFlowInstanceVo intanceVo = this.intanceService.getWorkflowInstance(this.wiid);
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF");
            Node tempNode = this.nodeService.getNode(space.getId(), intanceVo.getProId());
            this.nodeService.remove(tempNode.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.dynamicSignService.deleteUserSignByProId(workFlowInstanceVo.getProId());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("PROID", workFlowInstanceVo.getProId());
            this.sjdDaoImpl.deleteObject(param);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.workFlowService.deleteWorkFlowInstance(SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()), this.wiid);
        }
        catch (WorkFlowException ex) {
            ServletActionContext.getResponse().getWriter().println(ex.getMessage());
        }
        return "none";
    }

    private int permitDel(PfTaskVo taskVo) throws Exception {
        if (SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest()).isAdmin()) {
            return 0;
        }
        String userId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
        PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = this.intanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)workFlowInstanceVo);
        if (workXml.getBeginActivityDefine().equals(activityVo.getActivityDefinitionId())) {
            if (workFlowInstanceVo.getCreateUser().equals(SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()))) {
                return 0;
            }
            if (userId.equals(taskVo.getUserVo().getUserId())) {
                int count = this.taskService.getAllTaskCountByActivityId(activityVo.getActivityId());
                if (count == 1) {
                    return 1;
                }
                return 2;
            }
            return 3;
        }
        return 5;
    }

    public String post() throws Exception {
        PfTaskVo taskVo = this.taskService.getTask(this.taskid);
        PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
        String decode = null;
        if (!StringUtils.isBlank((String)this.remark)) {
            decode = URLDecoder.decode(this.remark, "utf-8");
        }
        this.workFlowService.lockWorkFlowInstance(activityVo.getWorkflowInstanceId(), this.taskid, decode);
        ServletActionContext.getResponse().getWriter().println("true");
        return "none";
    }

    public String unpost() throws Exception {
        PfTaskVo taskVo = this.taskService.getTask(this.taskid);
        PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
        this.workFlowService.unLockWorkFlowInstance(activityVo.getWorkflowInstanceId());
        ServletActionContext.getResponse().getWriter().println("true");
        return "none";
    }

    public String retrieve() throws Exception {
        if (!StringUtils.isBlank((String)this.taskid)) {
            try {
                this.workFlowService.retrieveWorkFlow(SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()), this.taskid);
            }
            catch (Exception e) {
                ServletActionContext.getResponse().getWriter().println(e.getMessage());
            }
        }
        return "none";
    }

    public SysTaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysWorkFlowInstanceService getIntanceService() {
        return this.intanceService;
    }

    public void setIntanceService(SysWorkFlowInstanceService intanceService) {
        this.intanceService = intanceService;
    }

    public SysStuffService getStuffService() {
        return this.stuffService;
    }

    public void setStuffService(SysStuffService stuffService) {
        this.stuffService = stuffService;
    }

    public SysDynamicSignService getDynamicSignService() {
        return this.dynamicSignService;
    }

    public void setDynamicSignService(SysDynamicSignService dynamicSignService) {
        this.dynamicSignService = dynamicSignService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BaseDao getSjdDaoImpl() {
        return this.sjdDaoImpl;
    }

    public void setSjdDaoImpl(BaseDao sjdDaoImpl) {
        this.sjdDaoImpl = sjdDaoImpl;
    }
}

