/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.service.SysExceptionService;
import com.gtis.plat.service.SysSupervisorService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.EcExceptionVo;
import com.gtis.plat.vo.EcSupervisorVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.ActionSupport;
import java.io.Reader;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SuperviseExceptionAction
extends ActionSupport {
    private static final long serialVersionUID = -1332406189603283039L;
    private SysExceptionService exceService;
    private SysSupervisorService supervisorService;
    private SysWorkFlowDefineService workFlowDefineService;
    private SplitParam splitParam;
    private EcExceptionVo exceptionVo;
    private EcSupervisorVo supervisorVo;
    List<PfWorkFlowDefineVo> lstWorkFlowDefine;
    private String currentUserId;

    public String execute() throws Exception {
        SplitParamImpl splitParamImpl = new SplitParamImpl();
        splitParamImpl.setQueryString("queryProjectList");
        this.splitParam = splitParamImpl;
        this.lstWorkFlowDefine = this.workFlowDefineService.getWorkFlowDefineList();
        if (this.lstWorkFlowDefine.size() > 0 && StringUtils.isNotBlank((String)((PfWorkFlowDefineVo)this.lstWorkFlowDefine.get(0)).getWorkflowDefinitionId())) {
            PfWorkFlowDefineVo vo = new PfWorkFlowDefineVo();
            vo.setWorkflowName("----\u6240\u6709\u4e1a\u52a1----");
            vo.setWorkflowDefinitionId("");
            this.lstWorkFlowDefine.add(0, vo);
        }
        this.currentUserId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
        return "success";
    }

    public String updateExceptionStatus() throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("CHECK_INFO", this.exceptionVo.getCheckInfo());
        paramMap.put("CHECK_TIME", new Date(System.currentTimeMillis()));
        paramMap.put("EXCEPTION_ID", this.exceptionVo.getExceptionId());
        paramMap.put("IS_SURE", this.exceptionVo.getIsSure());
        paramMap.put("CHECK_USER_ID", SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()));
        this.exceService.updateExceptionStatus(paramMap);
        return "none";
    }

    public String overProjectList() throws Exception {
        SplitParamImpl splitParamImpl = new SplitParamImpl();
        splitParamImpl.setQueryString("queryOverProjectList");
        this.splitParam = splitParamImpl;
        this.lstWorkFlowDefine = this.workFlowDefineService.getECWorkFlowDefineList();
        PfWorkFlowDefineVo vo = new PfWorkFlowDefineVo();
        vo.setWorkflowName("----\u6240\u6709\u4e1a\u52a1----");
        vo.setWorkflowDefinitionId("");
        this.lstWorkFlowDefine.add(0, vo);
        this.currentUserId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
        return "overProjectList";
    }

    public String exceptionDetail() throws Exception {
        List mapList = this.exceService.getActivityExceptionList(this.exceptionVo.getWorkflowInstanceId());
        HashMap activityInfo = new HashMap();
        HashMap<String, HashSet> activityUsers = new HashMap<String, HashSet>();
        ArrayList<HashMap> resultList = new ArrayList<HashMap>();
        for (HashMap map : mapList) {
            HashSet userNameSet;
            String activityId = map.get("ACTIVITY_ID").toString();
            if (activityUsers.get(activityId) == null) {
                userNameSet = new HashSet();
                userNameSet.add(map.get("USER_NAME").toString());
                activityUsers.put(activityId, userNameSet);
            } else {
                userNameSet = (HashSet)activityUsers.get(activityId);
                userNameSet.add(map.get("USER_NAME").toString());
                activityUsers.put(activityId, userNameSet);
            }
            HashMap temp = new HashMap();
            temp.put("WORKFLOW_INSTANCE_ID", map.get("WORKFLOW_INSTANCE_ID"));
            temp.put("ACTIVITY_ID", map.get("ACTIVITY_ID"));
            temp.put("ACTIVITY_NAME", map.get("ACTIVITY_NAME"));
            temp.put("EXC1", map.get("EXC1"));
            temp.put("EXC3", map.get("EXC3"));
            temp.put("EXC4", map.get("EXC4"));
            temp.put("EXC5", map.get("EXC5"));
            temp.put("BEGIN_TIME", map.get("BEGIN_TIME"));
            temp.put("FINISH_TIME", map.get("FINISH_TIME"));
            int timeUsered = Integer.parseInt(map.get("TIME_USERED").toString());
            int timeLimit = Integer.parseInt(map.get("TIME_LIMIT").toString());
            temp.put("TIME_USERED", map.get("TIME_USERED"));
            temp.put("TIME_LIMIT", map.get("TIME_LIMIT"));
            temp.put("ACTIVITY_RESIDUAL", timeLimit - timeUsered);
            activityInfo.put(activityId, temp);
        }
        Set entrySet = activityUsers.entrySet();
        for (Map.Entry mapEntry : entrySet) {
            String activityId = (String)mapEntry.getKey();
            HashSet hashSet = (HashSet)mapEntry.getValue();
            StringBuffer sb = new StringBuffer();
            Iterator iter = hashSet.iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append((String)iter.next());
                ++i;
            }
            String users = sb.toString();
            HashMap activityInfoHashMap = (HashMap)activityInfo.get(activityId);
            activityInfoHashMap.put("USER_NAME", users);
            resultList.add(activityInfoHashMap);
        }
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(resultList));
        return "none";
    }

    public String exceptionList() throws Exception {
        List mapList = null;
        if (this.exceptionVo != null) {
            mapList = this.exceService.getEcExceptionList(this.exceptionVo.getWorkflowInstanceId(), this.exceptionVo.getActivityId(), this.exceptionVo.getExceptionType(), this.exceptionVo.getUserId());
        }
        SAXReader reader = new SAXReader();
        for (HashMap map : mapList) {
            String beginTime;
            String over_time;
            int exceptionType = Integer.parseInt(map.get("EXCEPTION_TYPE").toString());
            String exceptionRecTime = CommonUtil.formateDate((Date)((Date)map.get("EXCEPTION_REC_TIME")));
            if (map.get("DESC_XML") == null) continue;
            String userName = map.get("USER_NAME") == null ? "" : map.get("USER_NAME").toString();
            String activityName = map.get("ACTIVITY_NAME") == null ? "" : map.get("ACTIVITY_NAME").toString();
            Clob descXmlClob = (Clob)map.get("DESC_XML");
            Reader descXmlReader = descXmlClob.getCharacterStream();
            Document document = reader.read(descXmlReader);
            Element descDocument = document.getRootElement();
            StringBuilder strBuilder = new StringBuilder();
            if (exceptionType == 1) {
                String timeLimit = descDocument.attributeValue("time_limit");
                String beginTime2 = descDocument.attributeValue("begin_time");
                over_time = descDocument.attributeValue("over_time");
                strBuilder.append(userName);
                strBuilder.append("\u4e8e");
                strBuilder.append(beginTime2);
                strBuilder.append("\u63a5\u6536\u5230\u201c");
                strBuilder.append(activityName);
                strBuilder.append("\u201d\u529e\u7406\uff0c\u6d3b\u52a8\u9650\u65f6");
                strBuilder.append(this.formatTimeLimit(timeLimit));
                strBuilder.append("\uff0c\u6d3b\u52a8\u529e\u7406\u622a\u6b62\u65e5\u671f");
                strBuilder.append(over_time);
                strBuilder.append("\uff0c\u6d3b\u52a8\u529e\u7406\u8d85\u671f");
            } else if (exceptionType == 2) {
                beginTime = descDocument.attributeValue("begin_time");
                String timeLimit = descDocument.attributeValue("time_limit");
                over_time = descDocument.attributeValue("over_time");
                strBuilder.append("\u672c\u9879\u76ee\u4e8e");
                strBuilder.append(beginTime);
                strBuilder.append("\u5f00\u59cb\u529e\u7406\uff0c\u9879\u76ee\u9650\u65f6");
                strBuilder.append(this.formatTimeLimit(timeLimit));
                strBuilder.append("\uff0c\u9879\u76ee\u529e\u7406\u622a\u6b62\u65e5\u671f");
                strBuilder.append(over_time);
                strBuilder.append("\uff0c\u9879\u76ee\u529e\u7406\u8d85\u671f");
            } else if (exceptionType == 3) {
                beginTime = descDocument.attributeValue("backtimes");
                strBuilder.append("\u672c\u6d3b\u52a8\u88ab\u6253\u56de");
                strBuilder.append(beginTime);
                strBuilder.append("\u6b21\uff0c\u8d85\u8fc7\u4e86\u5141\u8bb8\u7684\u8303\u56f4\u3002");
            } else if (exceptionType == 4) {
                strBuilder.append("\u8be5\u6d3b\u52a8\u51fa\u73b0\u4e86\u6302\u8d77\u5f02\u5e38\u3002");
            } else if (exceptionType == 5) {
                String needFee = descDocument.attributeValue("needfee");
                String getFree = descDocument.attributeValue("getfee");
                strBuilder.append("\u672c\u9879\u76ee\u5e94\u6536\u8d39");
                strBuilder.append(needFee);
                strBuilder.append("\uff0c\u5b9e\u6536\u8d39");
                strBuilder.append(getFree);
                strBuilder.append("\u3002");
            } else if (exceptionType == 6) {
                strBuilder.append("\u8be5\u6d3b\u52a8\u53d1\u751f\u6302\u8d77\u5f02\u5e38\u3002");
            } else if (exceptionType == 7) {
                String id = descDocument.attributeValue("id");
                strBuilder.append(id);
            } else if (exceptionType == 8) {
                strBuilder.append("\u65e0");
            }
            map.put("DESC_XML", strBuilder.toString());
        }
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize((Object)mapList));
        return "none";
    }

    public String revertSuperviseExplain() throws Exception {
        boolean isUpdate = this.supervisorService.updateSuperviseExplain(this.supervisorVo);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("revertResult", isUpdate);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(hashMap));
        return "none";
    }

    private String formatTimeLimit(String timeLimit) {
        if (StringUtils.isBlank((String)timeLimit)) {
            return "";
        }
        String formattedTimeLimit = timeLimit.indexOf("t") > -1 ? timeLimit.substring(0, timeLimit.indexOf("t")).concat("\u5c0f\u65f6") : timeLimit.concat("\u5929");
        return formattedTimeLimit;
    }

    public SysSupervisorService getSupervisorService() {
        return this.supervisorService;
    }

    public void setSupervisorService(SysSupervisorService supervisorService) {
        this.supervisorService = supervisorService;
    }

    public SplitParam getSplitParam() {
        return this.splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return this.workFlowDefineService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
        return this.lstWorkFlowDefine;
    }

    public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
        this.lstWorkFlowDefine = lstWorkFlowDefine;
    }

    public EcExceptionVo getExceptionVo() {
        return this.exceptionVo;
    }

    public void setExceptionVo(EcExceptionVo exceptionVo) {
        this.exceptionVo = exceptionVo;
    }

    public EcSupervisorVo getSupervisorVo() {
        return this.supervisorVo;
    }

    public void setSupervisorVo(EcSupervisorVo supervisorVo) {
        this.supervisorVo = supervisorVo;
    }

    public String getCurrentUserId() {
        return this.currentUserId;
    }

    public void setCurrentUserId(String currentUserId) {
        this.currentUserId = currentUserId;
    }

    public SysExceptionService getExceService() {
        return this.exceService;
    }

    public void setExceService(SysExceptionService exceService) {
        this.exceService = exceService;
    }
}

