/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.StuffService;
import com.gtis.plat.service.SysStuffService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfStuffFileVo;
import com.gtis.plat.vo.PfStuffInfoVo;
import com.gtis.rss.RssAction;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

public class StuffManageAction
extends RssAction {
    private static final long serialVersionUID = -6957955419776336137L;
    private String proid;
    private String taskid;
    private Integer rootId;
    private boolean disable = false;
    private String token;
    private String params;
    private String readOnly;
    private PfStuffInfoVo info;
    private PfStuffFileVo file;
    public static final String GLOBLE_STUFF = "GLOBLE_STUFF";
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    public static final String ORGAN_STUFF = "ORGAN_STUFF";
    private NodeService nodeService;
    private SysStuffService stuffService;
    private StuffService stuffService2;

    public String execute() throws Exception {
        Space space = this.nodeService.getWorkSpace(WORK_FLOW_STUFF, true);
        Node prjNode = this.nodeService.getNode(space.getId(), this.proid, true);
        this.rootId = prjNode.getId();
        this.token = this.nodeService.getToken(prjNode);
        this.params = JSONUtil.serialize((Object)this.convertParameters(ServletActionContext.getRequest()));
        List configMaps = this.stuffService.getStuffConfigByProId(this.proid);
        for (HashMap map : configMaps) {
            this.nodeService.getNode(prjNode.getId(), (String)map.get("stuffConfigName"), true);
        }
        return "success";
    }

    public String organ() throws Exception {
        Space space = this.nodeService.getWorkSpace(ORGAN_STUFF, true);
        this.params = JSONUtil.serialize((Object)this.convertParameters(ServletActionContext.getRequest()));
        List organList = SessionUtil.getUserInfo((HttpServletRequest)ServletActionContext.getRequest()).getLstOragn();
        if (organList.size() > 0) {
            Node node = this.nodeService.getNode(space.getId(), ((PfOrganVo)organList.get(0)).getOrganId(), true);
            this.token = this.nodeService.getToken(node);
            this.rootId = node.getId();
        } else {
            Node node = this.nodeService.getNode(space.getId(), "0", true);
            this.token = this.nodeService.getToken(node);
            this.rootId = node.getId();
        }
        return "success";
    }

    private Map<String, Object> convertParameters(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            Object v;
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            try {
                v = Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                v = "true".equalsIgnoreCase(value) ? Boolean.TRUE : ("false".equalsIgnoreCase(value) ? Boolean.FALSE : value);
            }
            params.put(name, v);
        }
        return params;
    }

    public String globle() throws Exception {
        Space space = this.nodeService.getWorkSpace(GLOBLE_STUFF, true);
        Node node = null;
        node = this.nodeService.getNode(space.getId(), StuffManageAction.class.getName(), true);
        this.rootId = node.getId();
        this.token = this.nodeService.getToken(node);
        this.params = JSONUtil.serialize((Object)this.convertParameters(ServletActionContext.getRequest()));
        return "success";
    }

    public String attrSave() throws Exception {
        if (this.info != null) {
            this.stuffService2.save(this.info);
        }
        if (this.file != null) {
            this.stuffService2.save(this.file);
        }
        return "none";
    }

    public String fileDel() throws Exception {
        this.file.setProId(this.proid);
        this.stuffService2.delete(this.file);
        return "none";
    }

    public String receive() throws Exception {
        List configMaps = this.stuffService.getStuffConfigByProId(this.proid);
        this.info = this.stuffService2.getStuffInfoByProId(this.proid);
        if (this.info == null) {
            this.info = this.newStuffInfo(this.taskid, this.proid, configMaps);
        }
        return "receive";
    }

    public String addFile() throws Exception {
        return "file";
    }

    private PfStuffInfoVo newStuffInfo(String taskId, String proId, List confList) {
        PfStuffInfoVo stuffInfoVo = new PfStuffInfoVo();
        stuffInfoVo.setProId(proId);
        stuffInfoVo.setTaskId(taskId);
        ArrayList<PfStuffFileVo> fileList = new ArrayList<PfStuffFileVo>();
        if (confList != null) {
            for (Object obj : confList) {
                HashMap map = (HashMap)obj;
                PfStuffFileVo stuffFileVo = new PfStuffFileVo();
                stuffFileVo.setInfoId(stuffInfoVo.getInfoId());
                stuffFileVo.setProId(this.proid);
                stuffFileVo.setTaskId(this.taskid);
                if (map.get("stuffConfigNo") != null) {
                    stuffFileVo.setNo(Integer.valueOf(Integer.parseInt("" + map.get("stuffConfigNo"))));
                }
                if (map.get("stuffConfigName") != null) {
                    stuffFileVo.setStuffName("" + map.get("stuffConfigName"));
                }
                if (map.get("stuffConfigCount") != null) {
                    stuffFileVo.setSCopies(Integer.valueOf(Integer.parseInt("" + map.get("stuffConfigCount"))));
                }
                if (map.get("stuffConfigRemark") != null) {
                    stuffFileVo.setRemark("" + map.get("stuffConfigRemark"));
                }
                fileList.add(stuffFileVo);
            }
        }
        stuffInfoVo.setFileList(fileList);
        this.stuffService2.save(stuffInfoVo);
        return stuffInfoVo;
    }

    public String rss() throws Exception {
        SplitParamImpl splitParam1 = new SplitParamImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeName", this.proid);
        splitParam1.setQueryString("getFilesByNodeName");
        splitParam1.setQueryParam(map);
        super.setRssParam((SplitParam)splitParam1);
        return super.rss();
    }

    public SysStuffService getStuffService() {
        return this.stuffService;
    }

    public void setStuffService(SysStuffService stuffService) {
        this.stuffService = stuffService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public Integer getRootId() {
        return this.rootId;
    }

    public void setRootId(Integer rootId) {
        this.rootId = rootId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getProid() {
        return this.proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public StuffService getStuffService2() {
        return this.stuffService2;
    }

    public void setStuffService2(StuffService stuffService2) {
        this.stuffService2 = stuffService2;
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public PfStuffInfoVo getInfo() {
        return this.info;
    }

    public void setInfo(PfStuffInfoVo info) {
        this.info = info;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public PfStuffFileVo getFile() {
        return this.file;
    }

    public void setFile(PfStuffFileVo file) {
        this.file = file;
    }
}

