/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class ShowFLowChartAction {
    SysWorkFlowInstanceService workFlowInstanceService;
    SysTaskService taskService;
    SysWorkFlowDefineService workFlowDefineService;
    String wdid;
    String wiid;
    String taskid;
    List<PfActivityVo> activityList;
    List<PfTaskVo> taskOverList;
    List<PfTaskVo> taskList;
    HashMap<String, String[]> activityMap;
    String enabledSq;
    Date currentDate;
    String overStartDate;
    String overEndDate;
    String overTimeDesc;
    static Log log = LogFactory.getLog(ShowFLowChartAction.class);

    public SysTaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public List<PfActivityVo> getActivityList() {
        return this.activityList;
    }

    public void setActivityList(List<PfActivityVo> activityList) {
        this.activityList = activityList;
    }

    public List<PfTaskVo> getTaskOverList() {
        return this.taskOverList;
    }

    public void setTaskOverList(List<PfTaskVo> taskOverList) {
        this.taskOverList = taskOverList;
    }

    public List<PfTaskVo> getTaskList() {
        return this.taskList;
    }

    public void setTaskList(List<PfTaskVo> taskList) {
        this.taskList = taskList;
    }

    private void queryTaskStatusData() {
        if (this.taskid != null && !this.taskid.equals("")) {
            PfTaskVo taskVo = this.taskService.getTask(this.taskid);
            if (taskVo == null) {
                taskVo = this.taskService.getHistoryTask(this.taskid);
            }
            PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
            this.wiid = activityVo.getWorkflowInstanceId();
            PfWorkFlowInstanceVo instanceVo = this.workFlowInstanceService.getWorkflowInstance(this.wiid);
            String wdid = instanceVo.getWorkflowDefinitionId();
            String activityXml = this.workFlowDefineService.getWorkFlowDefineLocation(wdid);
            if (activityXml != null && !activityXml.equals("")) {
                this.parsdoc(activityXml);
            }
        } else {
            PfWorkFlowInstanceVo instanceVo = this.workFlowInstanceService.getWorkflowInstance(this.wiid);
            String activityXml = this.workFlowDefineService.getWorkFlowDefineLocation(instanceVo.getWorkflowDefinitionId());
            if (activityXml != null && !activityXml.equals("")) {
                this.parsdoc(activityXml);
            }
        }
        this.activityList = this.taskService.getWorkFlowInstanceAllActivityList(this.wiid);
        this.taskList = this.taskService.getTaskListByInstance(this.wiid);
        this.taskOverList = this.taskService.getHistoryTaskListByInstance(this.wiid);
        this.handExistedUser(this.activityList, this.taskList);
        this.handExistedUser(this.activityList, this.taskOverList);
    }

    private void handExistedUser(List<PfActivityVo> activityList, List<PfTaskVo> inTaskVoList) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (PfActivityVo activityVo : activityList) {
            String activityId = activityVo.getActivityId();
            ArrayList<String> userIds = new ArrayList<String>();
            for (PfTaskVo taskVo : inTaskVoList) {
                if (!taskVo.getActivityId().equals(activityId)) continue;
                if (userIds.contains(taskVo.getUserVo().getUserId())) {
                    taskIds.add(taskVo.getTaskId());
                    continue;
                }
                userIds.add(taskVo.getUserVo().getUserId());
            }
        }
        Vector<PfTaskVo> tempVoList = new Vector<PfTaskVo>();
        for (String taskId : taskIds) {
            for (PfTaskVo taskVo : inTaskVoList) {
                if (!taskVo.getTaskId().equals(taskId)) continue;
                tempVoList.add(taskVo);
            }
        }
        for (int num = 0; num < tempVoList.size(); ++num) {
            inTaskVoList.remove(tempVoList.get(num));
        }
    }

    public String execute() throws Exception {
        this.currentDate = Calendar.getInstance().getTime();
        String sqConfig = AppConfig.getProperty((String)"useSq.enable");
        this.enabledSq = StringUtils.isNotBlank((String)sqConfig) && Boolean.parseBoolean(sqConfig) ? "true" : "false";
        this.queryTaskStatusData();
        return "success";
    }

    public String overtime() throws Exception {
        if (StringUtils.isNotBlank((String)this.overStartDate) && StringUtils.isNotBlank((String)this.overEndDate)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long timeSpan = simpleDateFormat.parse(this.overEndDate).getTime() - simpleDateFormat.parse(this.overStartDate).getTime();
            int daySpan = (int)Math.floor((double)timeSpan / 8.64E7);
            int hourSpan = (int)Math.ceil((double)timeSpan / 3600000.0 - (double)daySpan * 24.0);
            this.overTimeDesc = daySpan == 0 ? String.format("%d\u5c0f\u65f6", hourSpan) : String.format("%d\u5929%d\u5c0f\u65f6", daySpan, hourSpan);
        }
        return "overtimeDesc";
    }

    public String flowChartTable() {
        this.queryTaskStatusData();
        return "flowcharttable";
    }

    public String getImageLocation() {
        return null;
    }

    public void parsdoc(String activityXml) {
        try {
            this.activityMap = new HashMap();
            Document doc = DocumentHelper.parseText((String)activityXml);
            List resultNodeList = doc.selectNodes("//Data");
            for (Node dataNode : resultNodeList) {
                String[] loc = new String[]{Integer.parseInt(dataNode.valueOf("@left")) + 2 + "", Integer.parseInt(dataNode.valueOf("@top")) + 2 + "", dataNode.valueOf("@width"), dataNode.valueOf("@height")};
                String id = dataNode.valueOf("@id");
                this.activityMap.put(id, loc);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u6d3b\u52a8xml\u89e3\u6790\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public String image() throws Exception {
        if (this.taskid != null && !this.taskid.equals("")) {
            PfTaskVo taskVo = this.taskService.getTask(this.taskid);
            if (taskVo == null) {
                taskVo = this.taskService.getHistoryTask(this.taskid);
            }
            PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
            this.wiid = activityVo.getWorkflowInstanceId();
        }
        ServletActionContext.getResponse().setContentType("image/jpeg");
        try {
            PfWorkFlowInstanceVo instanceVo = this.workFlowInstanceService.getWorkflowInstance(this.wiid);
            PfWorkFlowDefineVo vo = this.workFlowDefineService.getWorkFlowImage(instanceVo.getWorkflowDefinitionId());
            if (vo.getWorkFlowImage() != null) {
                ServletActionContext.getResponse().getOutputStream().write(vo.getWorkFlowImage(), 0, vo.getWorkFlowImage().length);
                ServletActionContext.getResponse().getOutputStream().flush();
                ServletActionContext.getResponse().getOutputStream().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String imageByWdid() throws Exception {
        try {
            if (StringUtils.isNotBlank((String)this.wdid)) {
                PfWorkFlowDefineVo vo = this.workFlowDefineService.getWorkFlowImage(this.wdid);
                ServletActionContext.getResponse().setContentType("image/jpeg");
                if (vo.getWorkFlowImage() != null) {
                    ServletActionContext.getResponse().getOutputStream().write(vo.getWorkFlowImage(), 0, vo.getWorkFlowImage().length);
                    ServletActionContext.getResponse().getOutputStream().flush();
                    ServletActionContext.getResponse().getOutputStream().close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String simpleImage() throws Exception {
        if (StringUtils.isNotBlank((String)this.wiid) || StringUtils.isNotBlank((String)this.wdid)) {
            List tmpFiles;
            PfWorkFlowDefineVo vo = null;
            if (StringUtils.isNotBlank((String)this.wiid)) {
                PfWorkFlowInstanceVo instanceVo = this.workFlowInstanceService.getWorkflowInstance(this.wiid);
                vo = this.workFlowDefineService.getWorkFlowDefine(instanceVo.getWorkflowDefinitionId());
            } else if (StringUtils.isNotBlank((String)this.wdid)) {
                vo = this.workFlowDefineService.getWorkFlowDefine(this.wdid);
            }
            String workflowDefineName = vo.getWorkflowName();
            String flowChartImagePath = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/") + "\\pf\\flowchart\\" + workflowDefineName + "\\";
            if (new File(flowChartImagePath).exists() && (tmpFiles = (List)FileUtils.listFiles((File)new File(flowChartImagePath), null, (boolean)false)) != null && tmpFiles.size() > 0) {
                ServletActionContext.getResponse().setContentType("image/jpeg");
                File tmpFile = (File)tmpFiles.get(0);
                FileInputStream fileInputStream = null;
                BufferedInputStream bufferedInputStream = null;
                try {
                    fileInputStream = new FileInputStream(tmpFile);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    byte[] tmp = new byte[255];
                    int len = 0;
                    while ((len = bufferedInputStream.read(tmp, 0, 255)) != -1) {
                        ServletActionContext.getResponse().getOutputStream().write(tmp, 0, len);
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                ServletActionContext.getResponse().getOutputStream().flush();
                ServletActionContext.getResponse().getOutputStream().close();
            }
        }
        return null;
    }

    public String simpleFlowChart() {
        return "simpleFlowChart";
    }

    public SysWorkFlowInstanceService getWorkFlowInstanceService() {
        return this.workFlowInstanceService;
    }

    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public String getWiid() {
        return this.wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return this.workFlowDefineService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public HashMap<String, String[]> getActivityMap() {
        return this.activityMap;
    }

    public void setActivityMap(HashMap<String, String[]> activityMap) {
        this.activityMap = activityMap;
    }

    public String getWdid() {
        return this.wdid;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }

    public String getEnabledSq() {
        return this.enabledSq;
    }

    public void setEnabledSq(String enabledSq) {
        this.enabledSq = enabledSq;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public String getOverTimeDesc() {
        return this.overTimeDesc;
    }

    public void setOverTimeDesc(String overTimeDesc) {
        this.overTimeDesc = overTimeDesc;
    }

    public String getOverEndDate() {
        return this.overEndDate;
    }

    public void setOverEndDate(String overEndDate) {
        this.overEndDate = overEndDate;
    }

    public String getOverStartDate() {
        return this.overStartDate;
    }

    public void setOverStartDate(String overStartDate) {
        this.overStartDate = overStartDate;
    }
}

