/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.form.FormInstanceFactory;
import com.gtis.plat.form.FormModelFactory;
import com.gtis.plat.form.print.XMLBuildHelper;
import com.gtis.plat.vo.PfUserSignVo;
import com.gtis.web.sign.SignUitl;
import com.opensymphony.xwork2.ActionSupport;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

public class FormPrintAction
extends ActionSupport {
    public static final String DATA_TYPE_XML = "xml";
    public static final String DATA_TYPE_FR3 = "fr3";
    public static final String DATA_TYPE_SIGNATURE = "signature";
    private FormInstanceFactory instanceFactory;
    private String dfid;
    private String proid;
    private String datatype;
    private String signid;
    private SysFormDao formDao;
    private String paramString;
    private static final long serialVersionUID = 1L;

    public String execute() throws Exception {
        if (this.datatype.equalsIgnoreCase(DATA_TYPE_XML)) {
            this.buildXmlDataSet();
        } else if (this.datatype.equalsIgnoreCase(DATA_TYPE_FR3)) {
            this.buildFr3DataSet();
        } else if (this.datatype.equalsIgnoreCase(DATA_TYPE_SIGNATURE)) {
            this.buildSignatureDataSet();
        }
        return "none";
    }

    public void buildFr3DataSet() throws IOException {
        ServletActionContext.getResponse().setContentType("application/x-msdownload");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + String.valueOf(Calendar.getInstance().getTimeInMillis()));
        ServletOutputStream out = ServletActionContext.getResponse().getOutputStream();
        byte[] formPrintBytes = FormModelFactory.getFormModel((String)this.dfid).getFormDefineVo().getFormPrint();
        if (formPrintBytes == null) {
            System.out.println("\u62a5\u8868\u6a21\u677f\u8def\u5f84\u4e3a\u7a7a!!!");
        } else if (formPrintBytes.length <= 250) {
            int bytesRead;
            String path = ServletActionContext.getServletContext().getRealPath(new String(formPrintBytes));
            FileInputStream inputStream = new FileInputStream(path);
            byte[] buf = new byte[1000];
            while ((bytesRead = ((InputStream)inputStream).read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
            out.flush();
            out.close();
        } else {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(formPrintBytes);
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
    }

    public byte[] getBytesFromFile(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        long len = file.length();
        byte[] bytes = new byte[(int)len];
        int r = bufferedInputStream.read(bytes);
        if ((long)r != len) {
            throw new IOException("====\u8bfb\u53d6\u6587\u4ef6\u4e0d\u6b63\u786e!====");
        }
        bufferedInputStream.close();
        return bytes;
    }

    public void buildSignatureDataSet() throws Exception {
        ServletActionContext.getResponse().setContentType("image/jpeg");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + String.valueOf(Calendar.getInstance().getTimeInMillis()));
        PfUserSignVo userSign = this.formDao.getSign(this.signid);
        if (userSign != null) {
            if (userSign.getSignType() != null && "1".equals(userSign.getSignType())) {
                PfUserSignVo autoUserSign = this.formDao.getSignUserImage(userSign.getUserId());
                if (autoUserSign.getSignImage() == null) {
                    SignUitl.BuildSignImage((String)userSign.getSignName(), (OutputStream)ServletActionContext.getResponse().getOutputStream());
                } else {
                    byte[] imageByte = autoUserSign.getSignImage();
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageByte));
                    ImageIO.write((RenderedImage)image, "jpg", (OutputStream)ServletActionContext.getResponse().getOutputStream());
                }
            } else if (userSign.getSignImage() == null) {
                System.out.println("=================>image length = 0");
            } else {
                IOUtils.write((byte[])userSign.getSignImage(), (OutputStream)ServletActionContext.getResponse().getOutputStream());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getBlobData(Connection conn, String strTableName, String strColumnName, String strKeyName, String strKeyValue, OutputStream sos) throws Exception {
        Connection con = null;
        Statement ps = null;
        ResultSet resultset = null;
        try {
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append(" SELECT " + strColumnName + " FROM " + strTableName);
            sbSQL.append(" WHERE " + strKeyName + "='" + strKeyValue + "' ");
            ps = con.prepareStatement(sbSQL.toString());
            resultset = ps.executeQuery();
            while (resultset.next()) {
                InputStream inStream = resultset.getBinaryStream(strColumnName);
                byte[] buf = new byte[2048];
                if (inStream == null) continue;
                try {
                    int i = 0;
                    int num = 0;
                    while ((num = inStream.read(buf)) > 0) {
                        ++i;
                        sos.write(buf, 0, num);
                    }
                    if (i > 0) {
                        return;
                    }
                    sos = null;
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    inStream.close();
                }
                {
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (resultset != null) {
                resultset.close();
            }
        }
    }

    public static String getClientIP(HttpServletRequest request) {
        String xForwardedFor = StringUtils.trimToNull((String)request.getHeader("$wsra"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull((String)request.getHeader("X-Real-IP"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull((String)request.getHeader("X-Forwarded-For"));
        if (xForwardedFor != null) {
            int spaceIndex = xForwardedFor.indexOf(44);
            if (spaceIndex > 0) {
                return xForwardedFor.substring(0, spaceIndex);
            }
            return xForwardedFor;
        }
        return request.getRemoteAddr();
    }

    public void buildXmlDataSet() throws Exception {
        HashMap param = null;
        if (StringUtils.isNotBlank((String)this.paramString)) {
            try {
                String json = URLDecoder.decode(this.paramString, "utf-8");
                param = (HashMap)JSONUtil.deserialize((String)json);
            }
            catch (Exception e) {
                System.out.println("\u67e5\u8be2\u53c2\u6570\u914d\u7f6e\u683c\u5f0f(json\u683c\u5f0f{'':'','':''})\u6709\u8bef\uff1a" + this.paramString);
            }
        }
        XMLBuildHelper XMLbh = new XMLBuildHelper();
        ServletActionContext.getRequest().setCharacterEncoding("gbk");
        ServletActionContext.getResponse().setContentType("text/xml; charset=gbk");
        ServletActionContext.getResponse().getWriter().append(XMLbh.buildXmlDataSet(ServletActionContext.getRequest(), ServletActionContext.getResponse(), this.dfid, this.proid, param));
        PrintWriter out = ServletActionContext.getResponse().getWriter();
        out.flush();
        out.close();
    }

    public String getDfid() {
        return this.dfid;
    }

    public void setDfid(String dfid) {
        this.dfid = dfid;
    }

    public String getProid() {
        return this.proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public FormInstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public void setInstanceFactory(FormInstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public String getSignid() {
        return this.signid;
    }

    public void setSignid(String signid) {
        this.signid = signid;
    }

    public SysFormDao getFormDao() {
        return this.formDao;
    }

    public void setFormDao(SysFormDao formDao) {
        this.formDao = formDao;
    }

    public String getParamString() {
        return this.paramString;
    }

    public void setParamString(String paramString) {
        this.paramString = paramString;
    }
}

