/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web;

import com.gtis.plat.service.AttendanceService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.ui.session.HttpSessionApplicationEvent;
import org.springframework.security.ui.session.HttpSessionCreatedEvent;

public class SessionStorage
implements ApplicationListener {
    private Map<String, HttpSession> sessions = Collections.synchronizedMap(new LinkedHashMap());
    AttendanceService attendanceService;

    public Collection<HttpSession> getSessions() {
        return this.sessions.values();
    }

    public AttendanceService getAtten4danceService() {
        return this.attendanceService;
    }

    public void setAttendanceService(AttendanceService attendanceService) {
        this.attendanceService = attendanceService;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionApplicationEvent) {
            HttpSession session = ((HttpSessionApplicationEvent)event).getSession();
            if (event instanceof HttpSessionCreatedEvent) {
                this.sessions.put(session.getId(), session);
            } else {
                if (SessionUtil.getCurrentUser() != null) {
                    if (StringUtils.isNotBlank((String)SessionUtil.getCurrentUser().getUsername())) {
                        this.attendanceService.goOffWork(SessionUtil.getCurrentUser().getUsername());
                    }
                } else {
                    SecurityContext sc = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
                    if (sc != null) {
                        UserInfo ui = (UserInfo)sc.getAuthentication().getPrincipal();
                        this.attendanceService.goOffWork(ui.getUsername());
                    }
                }
                this.sessions.remove(session.getId());
            }
        }
    }
}

