/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkFlowTaskTurnInfoBean
extends WorkFlowBeanAbstract {
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        try {
            String activityDefinitionId = infoObj.getSourceActivity().getActivityDefinitionId();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)infoObj.getWorkFlowIntanceVo());
            ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
            String transType = activityModel.getSplitType();
            WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
            transInfo.setTransType(transType);
            transInfo.setCanFinish(activityModel.isCanFinish());
            infoObj.setTransInfo(transInfo);
            List lstTrans = activityModel.getTransitionsList();
            ArrayList<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
            for (TransitionModel transModel : lstTrans) {
                String nextActivityDefineId = transModel.getToId();
                ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                nextModel.setPerformerModelList(this.buildPerformerList(infoObj, nextModel));
                tranActivitys.add(nextModel);
            }
            transInfo.setTranActivitys(tranActivitys);
        }
        catch (Exception e) {
            if (e instanceof WorkFlowException) {
                throw e;
            }
            throw new WorkFlowException(WorkFlowException.ExceptionNum.StadusChange);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<PerformerTaskModel> buildPerformerList(WorkFlowInfo infoObj, ActivityModel nextModel) throws Exception {
        List organList;
        String regionCode;
        List lstOrgan;
        String startUserId = null;
        List<String> startOragnList = null;
        if (this.isFullWorkflow(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId()) && nextModel.isFilterDistrictCode()) {
            startOragnList = this.getOrganListByDistrict(infoObj);
            if (startOragnList == null || startOragnList.size() == 0) {
                throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
            }
        } else if (nextModel.isFilterStartUser()) {
            startUserId = infoObj.getWorkFlowIntanceVo().getCreateUser();
        } else if (nextModel.isFilterStartGroup()) {
            startUserId = infoObj.getWorkFlowIntanceVo().getCreateUser();
            lstOrgan = this.getUserService().getOrganListByUser(startUserId);
            startOragnList = new ArrayList();
            for (PfOrganVo vo : lstOrgan) {
                startOragnList.add(vo.getOrganId());
            }
            startUserId = null;
        } else if (nextModel.isFilterTransferGroup()) {
            lstOrgan = this.getUserService().getOrganListByUser(infoObj.getUserId());
            startOragnList = new ArrayList();
            for (PfOrganVo vo : lstOrgan) {
                startOragnList.add(vo.getOrganId());
            }
        } else if (nextModel.isFilterTransferPerformer()) {
            startOragnList = new ArrayList<String>();
            if (infoObj.getSourceTask().getPerformerId() != null) {
                startOragnList.add(infoObj.getSourceTask().getPerformerId());
            }
        } else if (nextModel.isFilterStartRegionCode()) {
            startUserId = infoObj.getWorkFlowIntanceVo().getCreateUser();
            regionCode = this.getUserService().getRegionCodeByUserId(startUserId);
            startOragnList = new ArrayList();
            organList = this.getUserService().getOrganByRegionCode(regionCode);
            if (organList.size() <= 0) throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
            for (PfOrganVo vo : organList) {
                startOragnList.add(vo.getOrganId());
            }
        } else if (nextModel.isFilterRegionCode()) {
            regionCode = infoObj.getWorkFlowIntanceVo().getRegionCode();
            if (StringUtils.isNotBlank((String)regionCode)) {
                startOragnList = new ArrayList();
                organList = this.getUserService().getOrganByRegionCode(regionCode);
                if (organList.size() <= 0) throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
                for (PfOrganVo vo : organList) {
                    startOragnList.add(vo.getOrganId());
                }
            }
        } else if (nextModel.isFilterDistrictCode() && ((startOragnList = this.getOrganListByDistrict(infoObj)) == null || startOragnList.size() == 0)) {
            throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
        }
        ArrayList<PerformerTaskModel> performerTaskModelList = new ArrayList<PerformerTaskModel>();
        List performerList = nextModel.getPerformerList();
        for (PerformerModel pModel : performerList) {
            PerformerTaskModel pTaskModel = this.buildPerformer(infoObj, pModel, startUserId, startOragnList);
            if (pTaskModel == null || pTaskModel.getUserList().size() <= 0) continue;
            performerTaskModelList.add(pTaskModel);
        }
        return performerTaskModelList;
    }

    private PerformerTaskModel buildPerformer(WorkFlowInfo infoObj, PerformerModel performerModel, String startUserId, List<String> startOragnList) {
        List users;
        PerformerTaskModel result = new PerformerTaskModel();
        if (!performerModel.getUserId().equals("")) {
            String userId = performerModel.getUserId();
            PfUserVo userVo = this.getUserService().getUserVo(userId);
            List organs = this.getUserService().getOrganListByUser(userVo.getUserId());
            result.setName(((PfOrganVo)organs.get(0)).getOrganName());
            result.setId("0");
            result.getUserList().add(userVo);
            result.setType("User");
        } else if (!performerModel.getOrganId().equals("")) {
            users = this.getUserService().getUserListByOragn(performerModel.getOrganId());
            PfOrganVo organVo = this.getUserService().getOrganVo(performerModel.getOrganId());
            if (organVo != null) {
                result.setName(organVo.getOrganName());
                result.setId(organVo.getOrganId());
                for (PfUserVo vo : users) {
                    result.getUserList().add(vo);
                }
            }
            if (startOragnList != null && startOragnList.size() > 0 && !startOragnList.contains(performerModel.getOrganId())) {
                result = new PerformerTaskModel();
            }
            result.setType("Organ");
        } else if (!performerModel.getRoleId().equals("")) {
            users = this.getUserService().getUserListByRole(performerModel.getRoleId());
            PfRoleVo roleVo = this.getUserService().getRoleVo(performerModel.getRoleId());
            result.setName(roleVo.getRoleName());
            result.setId(roleVo.getRoleId());
            if (startOragnList != null && startOragnList.size() > 0) {
                List userList = this.getUserService().getUserListByRoleAndOrganIds(roleVo.getRoleId(), startOragnList);
                for (PfUserVo vo : userList) {
                    result.getUserList().add(vo);
                }
            } else {
                for (PfUserVo vo : users) {
                    result.getUserList().add(vo);
                }
            }
            result.setType("Role");
        }
        ArrayList<PfUserVo> userList = new ArrayList<PfUserVo>();
        if (startUserId != null && !startUserId.equals("")) {
            for (PfUserVo vo : result.getUserList()) {
                if (!vo.getUserId().equals(startUserId)) continue;
                userList.add(vo);
            }
            if (userList.size() == 0) {
                PfUserVo userStart = this.getUserService().getUserVo(startUserId);
                userList.add(userStart);
            }
            result.setUserList(userList);
        }
        return result;
    }

    private List<String> getOrganListByDistrict(WorkFlowInfo infoObj) {
        ArrayList<String> startOragnList = null;
        String district = infoObj.getWorkFlowIntanceVo().getDistrict();
        if (StringUtils.isNotBlank((String)district)) {
            startOragnList = new ArrayList<String>();
            List organList = this.getUserService().getOrganByRegionCode(district);
            if (organList.size() > 0) {
                for (PfOrganVo vo : organList) {
                    startOragnList.add(vo.getOrganId());
                }
            } else {
                throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
            }
        }
        return startOragnList;
    }
}

