/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import java.util.ArrayList;

public class WorkFlowTaskTurnInfoBackBean
extends WorkFlowBeanAbstract {
    private static final String BACK_DEFAULT = "DEFAULT";
    private static final String BACK_NONE = "NOTALLOWED";

    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        try {
            String activityDefinitionId = infoObj.getSourceActivity().getActivityDefinitionId();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)infoObj.getWorkFlowIntanceVo());
            ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
            String backOptions = activityModel.getBackTransitions();
            if (backOptions.equalsIgnoreCase(BACK_DEFAULT)) {
                String activityId = infoObj.getSourceActivity().getActivityBefore();
                PfActivityVo aVo = super.getTaskService().getActivity(activityId);
                if (aVo != null) {
                    ArrayList<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
                    backActivitys.add(aVo);
                    infoObj.setTargetActivitys(backActivitys);
                }
            } else {
                if (backOptions.equalsIgnoreCase(BACK_NONE)) {
                    return false;
                }
                String[] adIds = backOptions.split(",");
                ArrayList<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
                for (int i = 0; i < adIds.length; ++i) {
                    ActivityModel aModel = workXml.getActivity(adIds[i]);
                    if (aModel == null) continue;
                    PfActivityVo aVo = new PfActivityVo();
                    aVo.setActivityDefinitionId(aModel.getDefineId());
                    aVo.setActivityName(aModel.getActivityDefineName());
                    backActivitys.add(aVo);
                }
                infoObj.setTargetActivitys(backActivitys);
            }
        }
        catch (Exception e) {
            throw new WorkFlowException(WorkFlowException.ExceptionNum.NoBack);
        }
        return true;
    }
}

