/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkFlowTaskTurnBackBean
extends WorkFlowBeanAbstract {
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        String xmlModel = this.getWorFlowInstanceService().getWorkflowInstanceXml(infoObj.getWorkFlowIntanceVo());
        WorkFlowXml workXml = new WorkFlowXml(xmlModel);
        if (infoObj.getTargetActivitys() != null && infoObj.getTargetActivitys().size() > 0) {
            String workflowInstanceId = infoObj.getSourceActivity().getWorkflowInstanceId();
            List lstActivitys = infoObj.getTargetActivitys();
            this.getTaskService().updateActivityStadus(infoObj.getSourceActivity().getActivityId(), 5);
            List history_taskList = this.getTaskService().getHistoryTaskListByActivity(infoObj.getSourceActivity().getActivityId());
            boolean isRepeat = false;
            if (history_taskList.size() > 0) {
                for (PfTaskVo pfTaskVo : history_taskList) {
                    if (pfTaskVo == null || !StringUtils.isNotBlank((String)pfTaskVo.getUserVo().getUserId()) || !StringUtils.equals((String)pfTaskVo.getUserVo().getUserId(), (String)infoObj.getUserId())) continue;
                    isRepeat = true;
                    break;
                }
            }
            this.getTaskService().insertTaskHistory(infoObj.getSourceTask().getTaskId());
            if (isRepeat && StringUtils.isNotBlank((String)infoObj.getSourceTask().getTaskId())) {
                this.getTaskService().updateAssignmentHistoryRepeat(infoObj.getSourceTask().getTaskId());
            }
            if (infoObj.getTransInfo() != null && infoObj.getTransInfo().getRemark() != null) {
                PfTaskVo taskHisVo = this.getTaskService().getHistoryTask(infoObj.getSourceTask().getTaskId());
                taskHisVo.setRemark(infoObj.getTransInfo().getRemark());
                this.getTaskService().updateHistoryTask(taskHisVo);
            }
            this.getTaskService().deleteActivityTask(infoObj.getSourceActivity().getActivityId());
            for (PfActivityVo vo : lstActivitys) {
                PfActivityVo backActivityVo = super.getTaskService().getActivityBywIdandadId(workflowInstanceId, vo.getActivityDefinitionId());
                Boolean isSubProcessActivity = false;
                String subProcessWiid = null;
                ActivityModel backActivityModel = workXml.getActivity(backActivityVo.getActivityDefinitionId());
                if (backActivityModel.getSubProcess() != null) {
                    isSubProcessActivity = true;
                }
                List lstTasks = this.getTaskService().getHistoryTasks(backActivityVo.getActivityId());
                ArrayList<String> users = new ArrayList<String>();
                for (PfTaskVo taskVo : lstTasks) {
                    if (users.contains(taskVo.getUserVo().getUserId())) continue;
                    users.add(taskVo.getUserVo().getUserId());
                    if (isSubProcessActivity.booleanValue()) {
                        subProcessWiid = taskVo.getTaskId();
                    } else {
                        taskVo.setTaskId(UUIDGenerator.generate());
                    }
                    taskVo.setTaskBefore(infoObj.getSourceTask().getTaskId());
                    taskVo.setBackState(true);
                    this.getTaskService().createTask(taskVo);
                }
                this.getTaskService().updateActivityBackStadus(backActivityVo.getActivityId(), true);
                this.getTaskService().updateActivityStadus(backActivityVo.getActivityId(), 1);
                this.getTaskService().updateActivityHandlesDay(backActivityVo.getActivityId(), 0);
                if (!isSubProcessActivity.booleanValue() || !StringUtils.isNotBlank((String)subProcessWiid)) continue;
                this.getTaskService().deleteHistoryTaskByActivityId(backActivityVo.getActivityId());
                this.restartSubProcess(subProcessWiid);
            }
            ActivityModel sourceActivityModel = workXml.getActivity(infoObj.getSourceActivity().getActivityDefinitionId());
            if (StringUtils.isNotBlank((String)sourceActivityModel.getCooperRootId())) {
                PfActivityVo rootActityVo = this.getTaskService().getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(), sourceActivityModel.getCooperRootId());
                this.getTaskService().updateCooperateStateUp(rootActityVo.getActivityId());
            }
            List transActivitys = infoObj.getTargetActivitys();
            for (PfActivityVo transActivity : transActivitys) {
                ActivityModel transModel = workXml.getActivity(transActivity.getActivityDefinitionId());
                if (transModel.getCooperRootId() == null || transModel.getCooperRootId().equals("")) continue;
                PfActivityVo cooperActityVo = this.getTaskService().getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(), transModel.getDefineId());
                if (cooperActityVo != null && cooperActityVo.getActivityState() == 1) {
                    throw new WorkFlowException(WorkFlowException.ExceptionNum.CooperatAlready);
                }
                this.getTaskService().updateCooperateStateDown(infoObj.getSourceActivity().getActivityId());
            }
        }
        return true;
    }

    private void restartSubProcess(String subProcessWiid) {
        PfWorkFlowInstanceVo intanceVo = this.getWorFlowInstanceService().getWorkflowInstance(subProcessWiid);
        if (intanceVo.getWorkflowState() == 2) {
            intanceVo.setWorkflowState(1);
            this.getWorFlowInstanceService().updateWorkFlowIntanceStadus(intanceVo);
            PfWorkFlowDefineVo defineVo = this.workFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
            WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)defineVo);
            String activityDefinitionId = workFlowXml.getEndActivityDefine();
            PfActivityVo backActivityVo = this.getTaskService().getActivityBywIdandadId(subProcessWiid, activityDefinitionId);
            List lstTasks = this.getTaskService().getHistoryTasks(backActivityVo.getActivityId());
            ArrayList<String> users = new ArrayList<String>();
            for (PfTaskVo taskVo : lstTasks) {
                if (users.contains(taskVo.getUserVo().getUserId())) continue;
                users.add(taskVo.getUserVo().getUserId());
                taskVo.setTaskId(UUIDGenerator.generate());
                taskVo.setBackState(true);
                this.getTaskService().createTask(taskVo);
            }
            List activitys = this.getTaskService().getWorkFlowInstanceActivityList(subProcessWiid);
            for (PfActivityVo activityVo : activitys) {
                if (activityVo.getActivityDefinitionId().equals(activityDefinitionId)) continue;
                List tasks = this.getTaskService().getTaskListByActivity(activityVo.getActivityId());
                for (PfTaskVo task : tasks) {
                    this.getTaskService().deleteTask(task.getTaskId());
                }
            }
            this.getTaskService().updateActivityBackStadus(backActivityVo.getActivityId(), true);
            this.getTaskService().updateActivityStadus(backActivityVo.getActivityId(), 1);
        }
    }
}

