/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.bean;

import com.gtis.config.AppConfig;
import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowMessage;
import com.gtis.spring.Container;
import com.gtis.util.DataSourceManager;
import com.gtis.util.ThreadPool;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.jms.core.JmsTemplate;

public class WorkFlowEventBean
extends WorkFlowBeanAbstract {
    private static final Log log = LogFactory.getLog(WorkFlowEventBean.class);
    private String eventName;

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        String xmlEvent = this.getWorkFlowDefineService().getWorkFlowDefineEventXml(infoObj.getWorkFlowDefineVo());
        if (!StringUtils.isBlank((String)xmlEvent)) {
            Document doc = DocumentHelper.parseText((String)xmlEvent);
            List eventNodes = doc.selectNodes("//Event[@name='" + this.eventName + "']");
            for (int i = 0; i < eventNodes.size(); ++i) {
                log.info((Object)("-------------------------\u4e8b\u4ef6\u540d\u79f0:" + this.eventName));
                Node eventNode = (Node)eventNodes.get(i);
                String activityDefinitionId = eventNode.valueOf("@activityDefinitionId");
                PfActivityVo activityVo = infoObj.getSourceActivity();
                if (activityVo != null && activityDefinitionId != null && !"".equals(activityDefinitionId.trim()) && !activityDefinitionId.equals(activityVo.getActivityDefinitionId())) continue;
                this.ExcuteCommand(infoObj, eventNode);
            }
        }
        return true;
    }

    private void ExcuteCommand(WorkFlowInfo infoObj, Node eventNode) throws Exception {
        Element eleNode = (Element)eventNode;
        List childsElement = eleNode.elements();
        for (Element ele : childsElement) {
            PfBusinessVo businessVo;
            String proId = infoObj.getWorkFlowIntanceVo().getProId();
            if (ele.getName().equalsIgnoreCase("SqlExcute")) {
                businessVo = super.getWorkFlowDefineService().getBusiness(infoObj.getWorkFlowDefineVo().getBusinessId());
                this.ExcuteSql(businessVo, ele.getTextTrim(), proId, infoObj.getUserId());
                continue;
            }
            if (ele.getName().equalsIgnoreCase("SqlSelect")) {
                businessVo = super.getWorkFlowDefineService().getBusiness(infoObj.getWorkFlowDefineVo().getBusinessId());
                boolean result = this.ExcuteSelectSql(businessVo, ele.getTextTrim(), proId);
                if (result) continue;
                String errMessage = ele.valueOf("@message");
                WorkFlowException ex = new WorkFlowException(errMessage);
                throw ex;
            }
            if (ele.getName().equalsIgnoreCase("Url")) {
                String result;
                String url = AppConfig.getPlaceholderValue((String)ele.getTextTrim());
                boolean asyn = false;
                if (StringUtils.isNotBlank((String)ele.valueOf("@asyn")) && ele.valueOf("@asyn").equalsIgnoreCase("true")) {
                    asyn = true;
                }
                if (!StringUtils.isNotBlank((String)(result = this.ExcuteUrl(url, proId, infoObj, asyn)))) continue;
                WorkFlowException ex = new WorkFlowException(URLDecoder.decode(result, "UTF-8"));
                throw ex;
            }
            if (!ele.getName().equalsIgnoreCase("Jms")) continue;
            Attribute attr = ele.attribute("type");
            this.sendJmsMessage(ele.getTextTrim(), infoObj, attr != null && "queue".equalsIgnoreCase(attr.getValue()));
        }
    }

    private void sendJmsMessage(String name, WorkFlowInfo infoObj, boolean toQueue) {
        SysWorkFlowDefineService workFlowDefineService = (SysWorkFlowDefineService)Container.getBean((String)"SysWorkFlowDefineServiceImpl");
        PfBusinessVo business = workFlowDefineService.getBusiness(infoObj.getWorkFlowDefineVo().getBusinessId());
        if (!StringUtils.isBlank((String)business.getBusinessUrl())) {
            business.setBusinessUrl(business.getBusinessUrl() + infoObj.getWorkFlowIntanceVo().getProId());
        }
        WorkFlowMessage workFlowMsg = new WorkFlowMessage();
        workFlowMsg.setBusinessVo(business);
        workFlowMsg.setWorkFlowIntanceVo(infoObj.getWorkFlowIntanceVo());
        workFlowMsg.setSourceActivity(infoObj.getSourceActivity());
        workFlowMsg.setSourceTask(infoObj.getSourceTask());
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("WorkFlowMessage", WorkFlowMessage.class);
        String xml = xstream.toXML((Object)workFlowMsg);
        ThreadPool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void ExcuteSql(PfBusinessVo businessVo, String sql, String proId, String userId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            DataSource ds = BusinessDataSource.getDataSourceByBusiness((PfBusinessVo)businessVo);
            con = ds.getConnection();
            sql = this.getFormSqlProcessor().processor(sql, proId);
            String[] sqlExcute = sql.split("\\@!\\[SEPARATOR\\]!\\@");
            for (int i = 0; i < sqlExcute.length; ++i) {
                ps = con.prepareStatement(sqlExcute[i]);
                ps.executeQuery();
                DataSourceManager.attemptClose((PreparedStatement)ps);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u5de5\u4f5c\u6d41\u4e8b\u4ef6\u5b9a\u4e49sql\u9519\u8bef,\u8bf7\u68c0\u67e5\uff01", (Throwable)e);
            throw e;
        }
        finally {
            DataSourceManager.attemptClose(ps);
            DataSourceManager.attemptClose((Connection)con);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ExcuteSelectSql(PfBusinessVo businessVo, String sql, String proId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            DataSource ds = BusinessDataSource.getDataSourceByBusiness((PfBusinessVo)businessVo);
            con = ds.getConnection();
            sql = this.getFormSqlProcessor().processor(sql, proId);
            log.debug((Object)sql);
            String[] sqlExcute = sql.split("\\@!\\[SEPARATOR\\]!\\@");
            int i = 0;
            while (true) {
                int count;
                block11: {
                    if (i < sqlExcute.length) {
                        ps = con.prepareStatement(sqlExcute[i]);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            ResultSetMetaData rsmd = rs.getMetaData();
                            count = rsmd.getColumnCount();
                            break block11;
                        } else {
                            boolean bl = false;
                            DataSourceManager.attemptClose((PreparedStatement)ps);
                            DataSourceManager.attemptClose((Connection)con);
                            return bl;
                        }
                    }
                    DataSourceManager.attemptClose(ps);
                    DataSourceManager.attemptClose((Connection)con);
                    return true;
                }
                for (int j = 1; j < count + 1; ++j) {
                    if (!StringUtils.isBlank((String)rs.getString(j))) continue;
                    boolean bl = false;
                    DataSourceManager.attemptClose((PreparedStatement)ps);
                    DataSourceManager.attemptClose((Connection)con);
                    return bl;
                }
                ++i;
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DataSourceManager.attemptClose(ps);
                DataSourceManager.attemptClose((Connection)con);
                throw throwable;
            }
        }
    }

    private String ExcuteUrl(String urlStr, String proId, WorkFlowInfo infoObj, boolean asyn) throws Exception {
        String[] urlStrs = urlStr.split("\\@!SEPARATOR!\\@");
        String workflowParaUrl = this.getWorkFlowInfoUrlFormat(infoObj);
        for (String urlTemp : urlStrs) {
            if (!(urlTemp = urlTemp.trim()).startsWith("http://")) {
                urlTemp = "http://" + this.platUrl + urlTemp;
            }
            try {
                urlTemp = urlTemp.indexOf("?") > 0 ? urlTemp + "&proid=" + proId + "&" + workflowParaUrl : urlTemp + "?proid=" + proId + "&" + workflowParaUrl;
                if (infoObj.getSourceActivity() != null) {
                    urlTemp = urlTemp + "&adid=" + infoObj.getSourceActivity().getActivityId();
                }
                if (infoObj.getTargetActivitys() != null) {
                    String targetActivityDefIds = "";
                    for (PfActivityVo pfActivityVo : infoObj.getTargetActivitys()) {
                        if (pfActivityVo == null) continue;
                        if (StringUtils.isNotBlank((String)targetActivityDefIds)) {
                            targetActivityDefIds = targetActivityDefIds + "," + pfActivityVo.getActivityDefinitionId();
                            continue;
                        }
                        targetActivityDefIds = pfActivityVo.getActivityDefinitionId();
                    }
                    if (StringUtils.isNotBlank((String)targetActivityDefIds)) {
                        urlTemp = urlTemp + "&targetActivityDefids=" + targetActivityDefIds;
                    }
                }
                log.info((Object)("-------------------------urlTemp:" + urlTemp));
                return this.ExcuteUrl(urlTemp, asyn);
            }
            catch (Exception e) {
                log.error((Object)("\u5de5\u4f5c\u6d41\u4e8b\u4ef6\u5b9a\u4e49url\u9519\u8bef,\u8bf7\u68c0\u67e5\uff01" + urlTemp), (Throwable)e);
            }
        }
        return null;
    }

    private String getWorkFlowInfoUrlFormat(WorkFlowInfo infoObj) throws Exception {
        List targetActivitys;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("userid=");
        resultBuf.append(infoObj.getUserId());
        if (infoObj.getSourceActivity() != null) {
            resultBuf.append("&activityid=");
            resultBuf.append(infoObj.getSourceActivity().getActivityId());
        }
        if (infoObj.getSourceTask() != null) {
            resultBuf.append("&taskid=");
            resultBuf.append(infoObj.getSourceTask().getTaskId());
        }
        if ((targetActivitys = infoObj.getTargetActivitys()) != null) {
            int index;
            resultBuf.append("&targetActivityIds=");
            for (index = 0; index < targetActivitys.size(); ++index) {
                if (index != 0) {
                    resultBuf.append(",");
                }
                resultBuf.append(((PfActivityVo)targetActivitys.get(index)).getActivityId());
            }
            resultBuf.append("&targetActivityNames=");
            for (index = 0; index < targetActivitys.size(); ++index) {
                if (index != 0) {
                    resultBuf.append(",");
                }
                if (!StringUtils.isNotBlank((String)((PfActivityVo)targetActivitys.get(index)).getActivityName())) continue;
                resultBuf.append(URLEncoder.encode(((PfActivityVo)targetActivitys.get(index)).getActivityName(), "utf-8"));
            }
        }
        return resultBuf.toString();
    }

    private String ExcuteUrl(String urlString, boolean asyn) throws Exception {
        if (asyn) {
            String urlStr = urlString;
            ThreadPool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            URL url = new URL(urlString);
            URLConnection URLconnection = url.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection)URLconnection;
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                InputStream urlStream = httpConnection.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(urlStream));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                }
                return buffer.toString();
            }
        }
        return null;
    }

    public static void main(String[] param) throws Exception {
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    static /* synthetic */ JmsTemplate access$100(WorkFlowEventBean x0) {
        return x0.jmsTemplate;
    }
}

