/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.spring.Container;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CreateWorkFlowTaskBean
extends WorkFlowBeanAbstract {
    SysCalendarService sysCalendarService;

    public void setSysCalendarService(SysCalendarService sysCalendarService) {
        this.sysCalendarService = sysCalendarService;
    }

    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)infoObj.getWorkFlowIntanceVo());
        ArrayList<String> subProcessActivitys = new ArrayList<String>();
        if (infoObj.getTargetActivitys() != null && infoObj.getTargetActivitys().size() > 0) {
            for (PfActivityVo activityVo : infoObj.getTargetActivitys()) {
                activityVo.setActivityState(1);
                ActivityModel sourceActivityModel = workXml.getActivity(activityVo.getActivityDefinitionId());
                if (sourceActivityModel.getSubProcess() != null) {
                    subProcessActivitys.add(activityVo.getActivityId());
                    this.createSubProcess(infoObj, sourceActivityModel, activityVo);
                }
                this.getTaskService().createActivity(activityVo);
            }
        }
        if (infoObj.getTargetTasks() != null && infoObj.getTargetTasks().size() > 0) {
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (subProcessActivitys.contains(taskVo.getActivityId())) continue;
                List userTasks = this.getTaskService().getHistoryTaskListByActivity(taskVo.getActivityId());
                if (userTasks != null && userTasks.size() > 0 && infoObj.getSourceTask() != null && infoObj.getSourceTask().isBackState()) {
                    taskVo.setBackState(true);
                }
                this.getTaskService().createTask(taskVo);
                PfActivityVo activityVo = this.getTaskService().getActivity(taskVo.getActivityId());
                if (activityVo == null) continue;
                PfWorkFlowInstanceVo instanceVo = this.getWorFlowInstanceService().getWorkflowInstance(activityVo.getWorkflowInstanceId());
                this.beginTrustTask(taskVo.getUserVo().getUserId(), instanceVo.getWorkflowDefinitionId(), activityVo.getActivityDefinitionId(), taskVo.getTaskId());
                ActivityModel sourceActivityModel = workXml.getActivity(activityVo.getActivityDefinitionId());
                String autoLock = sourceActivityModel.getAutoLock();
                if (!StringUtils.isNotBlank((String)autoLock) || !autoLock.equalsIgnoreCase("true")) continue;
                WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService)Container.getBean((String)"WorkFlowCoreService");
                workFlowCoreService.lockWorkFlowInstance(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(), taskVo.getTaskId());
            }
        }
        return true;
    }

    private String createSubProcess(WorkFlowInfo infoObj, ActivityModel activityModel, PfActivityVo targetActivity) {
        try {
            PfWorkFlowDefineVo workFlowDefineVo = super.getWorkFlowDefineService().getWorkFlowDefine(activityModel.getSubProcess().getId());
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            String proId = UUIDGenerator.generate();
            intanceVo.setWorkflowDefinitionId(workFlowDefineVo.getWorkflowDefinitionId());
            intanceVo.setWorkflowIntanceId(proId);
            intanceVo.setProId(proId);
            intanceVo.setCreateTime(Calendar.getInstance().getTime());
            intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setDistrict(infoObj.getWorkFlowIntanceVo().getDistrict());
            String subName = infoObj.getWorkFlowIntanceVo().getWorkflowIntanceName().split("_")[0] + "_" + workFlowDefineVo.getWorkflowName();
            intanceVo.setWorkflowIntanceName(subName);
            WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService)Container.getBean((String)"WorkFlowCoreService");
            workFlowCoreService.createWorkFlowInstance(intanceVo, infoObj.getUserId());
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(proId);
            taskVo.setBeginTime(intanceVo.getCreateTime());
            taskVo.setActivityId(targetActivity.getActivityId());
            PfUserVo userVo = new PfUserVo();
            userVo.setUserId("-1");
            taskVo.setUserVo(userVo);
            taskVo.setBeginTime(Calendar.getInstance().getTime());
            taskVo.setOverTime(this.sysCalendarService.getOverTime(taskVo.getBeginTime(), targetActivity.getTimeLimit()));
            this.getTaskService().createTask(taskVo);
            if (activityModel.getSubProcess().isLockParentProject()) {
                workFlowCoreService.lockWorkFlowInstance(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(), intanceVo.getWorkflowIntanceId());
            }
            return intanceVo.getWorkflowIntanceId();
        }
        catch (Exception e) {
            throw new WorkFlowException(WorkFlowException.ExceptionNum.SubFlowStartFailed);
        }
    }

    private void beginTrustTask(String userId, String workflowDefineId, String activityDefineId, String taskId) throws Exception {
        String trustUserId = this.getTrustAgentUserId(userId, workflowDefineId, activityDefineId);
        if (StringUtils.isNotBlank((String)trustUserId)) {
            WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService)Container.getBean((String)"WorkFlowCoreService");
            workFlowCoreService.entrustTask(taskId, trustUserId);
        }
    }

    private String getTrustAgentUserId(String userId, String workflowDefineId, String activityDefineId) {
        String trustAgentUserId = null;
        List agentUsers = this.userService.getTaskAgentListByUser(userId);
        if (agentUsers != null) {
            for (PfTaskAgentVo taskAgentVo : agentUsers) {
                if (taskAgentVo.getWorkFlowDefinitionId() != null && !taskAgentVo.getWorkFlowDefinitionId().equals(workflowDefineId) || !StringUtils.isBlank((String)taskAgentVo.getActivityDefinitionId()) && !taskAgentVo.getActivityDefinitionId().equals(activityDefineId) || taskAgentVo.getBeginTime() != null && !taskAgentVo.getBeginTime().before(Calendar.getInstance().getTime()) || taskAgentVo.getEndTime() != null && !taskAgentVo.getEndTime().after(Calendar.getInstance().getTime()) || 1 != taskAgentVo.getAgentType()) continue;
                trustAgentUserId = taskAgentVo.getUserId();
                break;
            }
        }
        return trustAgentUserId;
    }
}

