/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.bean;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.bean.WorkFlowBeanUtil;
import com.gtis.plat.wf.model.ActivityModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CreateWorkFlowBean
extends WorkFlowBeanAbstract {
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        String district;
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)infoObj.getWorkFlowDefineVo());
        String activityDefinitionId = xmlDao.getBeginActivityDefine();
        ActivityModel activityModel = xmlDao.getActivity(activityDefinitionId);
        PfActivityVo activityVo = WorkFlowBeanUtil.createActivityVoByModel((ActivityModel)activityModel);
        String activityId = UUIDGenerator.generate();
        activityVo.setActivityId(activityId);
        activityVo.setWorkflowInstanceId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId());
        ArrayList<PfActivityVo> targetActivitys = new ArrayList<PfActivityVo>();
        targetActivitys.add(activityVo);
        infoObj.setTargetActivitys(targetActivitys);
        List lstUserIds = new ArrayList<String>();
        List lstPerformers = activityModel.getPerformerList();
        if (lstPerformers.size() == 0) {
            throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
        }
        if (this.isFullWorkflow(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId()) && activityModel.isFilterDistrictCode()) {
            district = infoObj.getWorkFlowIntanceVo().getDistrict();
            if (StringUtils.isNotBlank((String)district)) {
                lstUserIds = this.getUserService().getUserListPerformersByDistrict(lstPerformers, district);
            }
        } else if (activityModel.isFilterStartUser()) {
            lstUserIds.add(infoObj.getUserId());
        } else if (activityModel.isFilterStartGroup()) {
            lstUserIds = this.getUserService().getUserListPerformersByUserOrgan(lstPerformers, infoObj.getUserId());
        } else if (activityModel.isFilterDistrictCode()) {
            district = infoObj.getWorkFlowIntanceVo().getDistrict();
            if (StringUtils.isNotBlank((String)district)) {
                lstUserIds = this.getUserService().getUserListPerformersByDistrict(lstPerformers, district);
            }
        } else {
            lstUserIds = this.getUserService().getAllUserListPerformers(lstPerformers);
        }
        if (lstUserIds.size() == 0) {
            throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
        }
        ArrayList<PfTaskVo> targetTasks = new ArrayList<PfTaskVo>();
        for (String userId : lstUserIds) {
            PfTaskVo taskVo = this.createTaskVo(activityId);
            taskVo.setUserVo(this.createUserVo(userId));
            targetTasks.add(taskVo);
        }
        infoObj.setTargetTasks(targetTasks);
        return true;
    }

    private PfUserVo createUserVo(String userId) {
        PfUserVo userVo = new PfUserVo();
        userVo.setUserId(userId);
        return userVo;
    }

    private PfTaskVo createTaskVo(String activityId) {
        PfTaskVo taskVo = new PfTaskVo();
        String taskId = UUIDGenerator.generate();
        taskVo.setTaskId(taskId);
        taskVo.setActivityId(activityId);
        return taskVo;
    }
}

