/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.ActivityTask;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkFlowChartServiceImpl {
    SysWorkFlowInstanceService worFlowInstanceService;
    SysTaskService taskService;

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setWorFlowInstanceService(SysWorkFlowInstanceService worFlowInstanceService) {
        this.worFlowInstanceService = worFlowInstanceService;
    }

    public ActivityTask buildFirstTask(String workflowIntanceId) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.worFlowInstanceService.getWorkflowInstance(workflowIntanceId);
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)pfWorkFlowInstanceVo);
        String beginActivityId = xmlDao.getBeginActivityDefine();
        PfActivityVo firstActivity = this.taskService.getActivityBywIdandadId(workflowIntanceId, beginActivityId);
        List taskVos = this.taskService.getTaskListByActivity(firstActivity.getActivityId());
        List taskHistoryVos = this.taskService.getHistoryTasks(firstActivity.getActivityId());
        ActivityTask activityTask = new ActivityTask(firstActivity);
        if (taskVos != null) {
            for (PfTaskVo task : taskVos) {
                if (!StringUtils.isBlank((String)task.getTaskBefore())) continue;
                activityTask.addTask(task);
            }
        }
        if (taskHistoryVos != null) {
            for (PfTaskVo task : taskHistoryVos) {
                if (!StringUtils.isBlank((String)task.getTaskBefore())) continue;
                activityTask.addTask(task);
            }
        }
        return activityTask;
    }

    public List<ActivityTask> getNextActivityTask(ActivityTask activityTask) {
        ArrayList<ActivityTask> activityTasks = new ArrayList<ActivityTask>();
        List taskIds = activityTask.getTaskIds();
        List tasks = this.taskService.getTaskListByInstance(activityTask.getActivityVo().getWorkflowInstanceId());
        List hisoryTasks = this.taskService.getHistoryTaskListByInstance(activityTask.getActivityVo().getWorkflowInstanceId());
        tasks.addAll(hisoryTasks);
        for (PfTaskVo task : tasks) {
            String[] beforeIds;
            if (!StringUtils.isNotBlank((String)task.getTaskBefore())) continue;
            for (String beforeId : beforeIds = task.getTaskBefore().split(",")) {
                if (!taskIds.contains(beforeId)) continue;
                this.buildActivitys(activityTasks, task);
            }
        }
        return activityTasks;
    }

    private void buildActivitys(List<ActivityTask> activityTasks, PfTaskVo task) {
        ActivityTask activityTaskNext = null;
        PfActivityVo activityVo = this.taskService.getActivity(task.getActivityId());
        if (activityTasks.size() == 0) {
            activityTaskNext = new ActivityTask(activityVo);
            activityTasks.add(activityTaskNext);
        } else {
            activityTaskNext = this.getActivityTask(activityTasks, task.getActivityId());
            if (activityTaskNext == null) {
                activityTaskNext = new ActivityTask(activityVo);
                activityTasks.add(activityTaskNext);
            }
        }
        activityTaskNext.addTask(task);
    }

    private ActivityTask getActivityTask(List<ActivityTask> activityTasks, String activityId) {
        if (activityTasks != null) {
            for (ActivityTask activityTask : activityTasks) {
                if (!activityTask.getActivityVo().getActivityId().equals(activityId)) continue;
                return activityTask;
            }
        }
        return null;
    }
}

