/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.task;

import com.gtis.plat.dao.SysCalendarDAO;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SpecialWorkDayPack
implements InitializingBean {
    static Logger logger = LoggerFactory.getLogger(SpecialWorkDayPack.class);
    private static List<String> specialHolidays = new ArrayList();
    private static List<String> specialWorkdays = new ArrayList();
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat simpleDateFullFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static String WorkStartTime = "08:30";
    private SysCalendarDAO calendarDAO;
    private SysWorkFlowInstanceDao workFlowInstanceDao;

    public void setCalendarDAO(SysCalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }

    public void setWorkFlowInstanceDao(SysWorkFlowInstanceDao workFlowInstanceDao) {
        this.workFlowInstanceDao = workFlowInstanceDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() {
        ArrayList<String> specialHolidays = new ArrayList<String>();
        ArrayList<String> specialWorkdays = new ArrayList<String>();
        Calendar ca = Calendar.getInstance();
        int yearInt = Calendar.getInstance().get(1);
        ca.set(1, yearInt - 1);
        ca.set(6, 1);
        Date beginDate = ca.getTime();
        ca.set(1, yearInt + 2);
        ca.set(6, 1);
        ca.add(6, -1);
        Date endDate = ca.getTime();
        List specialDates = this.calendarDAO.getSpecialDateList(beginDate, endDate);
        for (Map sDate : specialDates) {
            if (sDate.get("CAL_TYPE").equals("\u5de5\u4f5c\u65e5")) {
                specialWorkdays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
                continue;
            }
            specialHolidays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
        }
    }

    public void CalWorkDayAutoTask() {
        Date endTime = Calendar.getInstance().getTime();
        if (!this.IsHoliday(Calendar.getInstance().getTime())) {
            logger.info("-------\u5de5\u4f5c\u6d41\u5f00\u59cb\u8ba1\u7b97\u5de5\u4f5c\u65e5------");
            try {
                List workFlowInstanceList = this.workFlowInstanceDao.getWorkFlowInstanceForHandlesDay();
                logger.info("-------\u6d3b\u52a8\u5de5\u4f5c\u5b9e\u4f8b\u5171\uff1a" + workFlowInstanceList.size() + "------");
                for (Map workFlowInstance : workFlowInstanceList) {
                    Date beginDate;
                    if (workFlowInstance.get("CREATE_TIME") == null || (beginDate = (Date)workFlowInstance.get("CREATE_TIME")).compareTo(endTime) > 0 || !(this.getDiffDay(beginDate, endTime) < 365.0)) continue;
                    double days = this.calWorkDay(beginDate, endTime);
                    this.workFlowInstanceDao.updateWorkFlowHandleDayById(workFlowInstance.get("WORKFLOW_INSTANCE_ID").toString(), (int)Math.floor(days));
                }
                List activityList = this.workFlowInstanceDao.getWorkFlowActivityForHandlesDay();
                logger.info("-------\u6d3b\u52a8\u5171\uff1a" + activityList.size() + "------");
                for (Map workFlowInstance : activityList) {
                    Date beginDate;
                    if (workFlowInstance.get("BEGIN_TIME") == null || (beginDate = (Date)workFlowInstance.get("BEGIN_TIME")).compareTo(endTime) > 0 || !(this.getDiffDay(beginDate, endTime) < 365.0)) continue;
                    double days = this.calWorkDay(beginDate, endTime);
                    this.workFlowInstanceDao.updateActivityHandleDayById(workFlowInstance.get("ACTIVITY_ID").toString(), (int)Math.floor(days));
                }
            }
            catch (Exception ex) {
                logger.error("--------\u5de5\u4f5c\u65e5\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458-----------", (Throwable)ex);
            }
        }
    }

    public double calWorkDay(Date beginDate, Date endDate) throws Exception {
        Date workBeginDate = this.getFirstWorkDate(beginDate);
        double day = this.getDiffDay(workBeginDate, endDate);
        Calendar ca = Calendar.getInstance();
        int hDays = this.getHolidays(workBeginDate, endDate);
        return (int)Math.floor(day -= (double)hDays);
    }

    public int getHolidays(Date beginDate, Date endDate) throws Exception {
        int day = 0;
        Calendar ca = Calendar.getInstance();
        ca.setTime(this.getFirstWorkDate(beginDate));
        while (ca.getTime().compareTo(endDate) <= 0) {
            if (this.IsHoliday(ca.getTime())) {
                ++day;
            }
            ca.add(6, 1);
        }
        return day;
    }

    public Date getFirstWorkDate(Date beginDate) throws Exception {
        Calendar ca = Calendar.getInstance();
        ca.setTime(beginDate);
        if (this.IsHoliday(beginDate)) {
            ca.add(6, 1);
            while (this.IsHoliday(ca.getTime())) {
                ca.add(6, 1);
            }
            ca.setTime(this.simpleDateFullFormat.parse(simpleDateFormat.format(ca.getTime()) + " " + WorkStartTime));
        }
        return ca.getTime();
    }

    public boolean IsHoliday(Date bDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(bDate);
        String dateStr = simpleDateFormat.format(bDate);
        if (ca.get(7) == 1 || ca.get(7) == 7) {
            return !specialWorkdays.contains(dateStr);
        }
        return specialHolidays.contains(dateStr);
    }

    private double getDiffDay(Date beginDate, Date endDate) {
        long time = endDate.getTime() - beginDate.getTime();
        return (double)time * 1.0 / 8.64E7;
    }

    public static void main(String[] arg) throws Exception {
        SpecialWorkDayPack ss = new SpecialWorkDayPack();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        System.out.println(ss.calWorkDay(sf.parse("2014-08-08 23:33"), sf.parse("2014-08-17 12:01")));
        System.out.println(ss.calWorkDay(sf.parse("2014-08-09 10:33"), sf.parse("2014-08-16 12:01")));
        System.out.println(ss.calWorkDay(sf.parse("2014-08-10 09:33"), sf.parse("2014-08-16 12:01")));
    }
}

