/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.task;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysDzjcDAO;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.vo.PfSmsVo;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class OvertimeTaskRemind
implements InitializingBean {
    static Logger logger = LoggerFactory.getLogger(OvertimeTaskRemind.class);
    private SysSmsService sysSmsService;
    private SysDzjcDAO sysDzjcDAO;
    private boolean enabled;

    public void afterPropertiesSet() throws Exception {
        this.enabled = AppConfig.getBooleanProperty((String)"overtimeTask.smsRemind.enable", (boolean)false);
    }

    private void sendSmsMsg(PfSmsVo pfSmsVo) {
        try {
            this.sysSmsService.sendMsg(pfSmsVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remindOvertimeTask() {
        List overtimeTaskList;
        if (this.enabled && (overtimeTaskList = this.sysDzjcDAO.QueryActivityOvertime()).size() > 0) {
            for (Map overtimeTask : overtimeTaskList) {
                if (overtimeTask.get("MOBILE_PHONE") == null || !StringUtils.isNotBlank((String)String.valueOf(overtimeTask.get("MOBILE_PHONE")))) continue;
                PfSmsVo pfSmsVo = new PfSmsVo();
                pfSmsVo.setSmsId(UUIDGenerator.generate());
                pfSmsVo.setMobileNo(String.valueOf(overtimeTask.get("MOBILE_PHONE")));
                pfSmsVo.setSendDate(Calendar.getInstance().getTime());
                String workflowName = String.valueOf(overtimeTask.get("WORKFLOW_NAME"));
                String projectName = String.valueOf(overtimeTask.get("WORKFLOW_INSTANCE_NAME"));
                String activityName = String.valueOf(overtimeTask.get("ACTIVITY_NAME"));
                String overtime = String.valueOf(overtimeTask.get("CDAY"));
                String smsContent = "\u60a8\u5f53\u524d\u6709{0}\u7c7b\u578b\u9879\u76ee\uff1a{1},\u5728{2}\u8282\u70b9\u5df2\u8d85\u671f{3}\u5929\uff0c\u8bf7\u5c3d\u5feb\u529e\u7406\uff01";
                smsContent = MessageFormat.format(smsContent, workflowName, projectName, activityName, overtime);
                pfSmsVo.setContent(smsContent);
                this.sendSmsMsg(pfSmsVo);
            }
        }
    }

    public SysSmsService getSysSmsService() {
        return this.sysSmsService;
    }

    public void setSysSmsService(SysSmsService sysSmsService) {
        this.sysSmsService = sysSmsService;
    }

    public SysDzjcDAO getSysDzjcDAO() {
        return this.sysDzjcDAO;
    }

    public void setSysDzjcDAO(SysDzjcDAO sysDzjcDAO) {
        this.sysDzjcDAO = sysDzjcDAO;
    }
}

