/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl.search;

import com.gtis.common.AbstractSplitDataIndexProvider;
import com.gtis.plat.service.SysNewsService;
import com.gtis.plat.vo.PfNewsVo;
import com.gtis.search.Category;
import com.gtis.search.Index;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class NewsIndexProviderImpl
extends AbstractSplitDataIndexProvider<PfNewsVo> {
    private SysNewsService sysNewsService;

    public void setSysNewsService(SysNewsService sysNewsService) {
        this.sysNewsService = sysNewsService;
    }

    protected PfNewsVo getEntity(String categoryId, String id) {
        return this.sysNewsService.getNewsById(id);
    }

    protected void extractEntity(PfNewsVo entity, Index index) {
        Category cat = this.getDefaultCategory();
        index.setBusinessId(cat.getBusinessId());
        index.setCategoryId(cat.getId());
        index.setId(entity.getNewsId());
        index.setTitle(entity.getNewsTitle());
        index.setDate(entity.getNewsDate());
        String body = StringUtils.replace((String)entity.getNewsContent(), (String)"&nbsp;", (String)"");
        body = StringUtils.replace((String)body, (String)"nbsp;", (String)"");
        index.appendBody(body, 500);
        if (StringUtils.isNotBlank((String)entity.getImageUrl())) {
            index.addField("img", (Serializable)((Object)entity.getImageUrl()));
        }
    }

    protected String getStatementName() {
        return "getNewsList1";
    }
}

