/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl.search;

import com.gtis.dao.ibatis.IbatisDataAccess;
import com.gtis.search.SearchService;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexSupportIbatisDataAccess
extends IbatisDataAccess {
    private SearchService searchService;
    private boolean enabled;
    private Set<String> enabledQuerys = new HashSet();

    public IndexSupportIbatisDataAccess() {
        Collections.addAll(this.enabledQuerys, "getTaskList", "getTaskOverList", "getProjectList");
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getCount(SplitParam param) {
        if (!this.enabled || !this.enabledQuerys.contains(param.getQueryString())) {
            return super.getCount(param);
        }
        return this.searchService.search(null, this.toFilter(param), "wf", param.getQueryString(), null, null, 0, 0).getTotalCount();
    }

    public List queryForList(SplitParam param, int skipSize, int pageSize) {
        if (!this.enabled || !this.enabledQuerys.contains(param.getQueryString())) {
            return super.queryForList(param, skipSize, pageSize);
        }
        Map map = (Map)((Object)param.getQueryParam());
        String order = (String)map.get("_orderdir_");
        String orderField = (String)map.get("_orderfield_");
        orderField = "CREATE_TIME".equals(orderField) || "BEGIN_TIME".equals(orderField) || "FINISH_TIME".equals(orderField) ? orderField + "_t" : ("IDAY".equals(orderField) || "CDAY".equals(orderField) || "WORKFLOW_STATE".equals(orderField) ? orderField + "_i" : orderField + "_s");
        return this.searchService.search(null, this.toFilter(param), "wf", param.getQueryString(), orderField, order, skipSize, pageSize).getItems();
    }

    private Map<String, Object> toFilter(SplitParam param) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        if (!SessionUtil.getCurrentUser().isAdmin()) {
            // empty if block
        }
        Map map = (Map)((Object)param.getQueryParam());
        map.remove("userIds");
        map.remove("_query");
        map.remove("_orderfield_");
        map.remove("_orderdir_");
        if (map != null) {
            filter.putAll(map);
        }
        return filter;
    }
}

