/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl.search;

import com.gtis.plat.service.FormDataService;
import com.gtis.search.DataFetcher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormDataDataFetcher
implements DataFetcher {
    private String[] formCodes;
    private Set<String> fields = new HashSet();
    private FormDataService formDataService;

    public void setFormCodes(String[] formCodes) {
        this.formCodes = formCodes;
    }

    public void setFields(String[] fields) {
        for (String field : fields) {
            this.fields.add(field.toLowerCase());
        }
    }

    public void setFormDataService(FormDataService formDataService) {
        this.formDataService = formDataService;
    }

    public Map<String, Object> fetchData(String id) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (String code : this.formCodes) {
            for (Map.Entry entry : this.formDataService.getData(code, id).entrySet()) {
                String key = ((String)entry.getKey()).toLowerCase();
                if (!this.fields.contains(key)) continue;
                dataMap.put(key, entry.getValue());
            }
        }
        return dataMap;
    }

    public String getDescription() {
        return this.getClass() + " formCodes:[" + Arrays.toString(this.formCodes) + "]";
    }
}

