/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysSmsDao;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.service.impl.TeleComSysSmsServiceImpl;
import com.gtis.plat.vo.PfSmsVo;
import com.linkage.netmsg.NetMsgclient;
import com.linkage.netmsg.server.ReceiveMsg;
import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;

public class TeleComSysSmsServiceImpl
implements SysSmsService {
    private String hostIp;
    private int hostPort;
    private String userName;
    private String password;
    private NetMsgclient netMsgclient;
    private SysSmsDao smsDAO;

    public boolean initNetMsgClient() {
        this.netMsgclient = new NetMsgclient();
        TeleComReceiveMsg receiveMsg = new TeleComReceiveMsg(this);
        this.netMsgclient = this.netMsgclient.initParameters(this.hostIp, this.hostPort, this.userName, this.password, (ReceiveMsg)receiveMsg);
        try {
            return this.netMsgclient.anthenMsg(this.netMsgclient);
        }
        catch (IOException e) {
            this.destroyNetMsgClient();
            e.printStackTrace();
            return false;
        }
    }

    public void destroyNetMsgClient() {
        if (this.netMsgclient != null) {
            this.netMsgclient.closeConn();
        }
    }

    public String sendMsg(String sender, String receive, String phone, String content) throws Exception {
        PfSmsVo pfSmsVo = new PfSmsVo();
        pfSmsVo.setSmsId(UUIDGenerator.generate());
        pfSmsVo.setContent(content);
        pfSmsVo.setSender(sender);
        pfSmsVo.setReceive(receive);
        pfSmsVo.setMobileNo(phone);
        pfSmsVo.setSendDate(Calendar.getInstance().getTime());
        return this.sendMsg(pfSmsVo);
    }

    public int msgState(String msgNo) throws Exception {
        return 0;
    }

    public String sendMsg(PfSmsVo sms) throws Exception {
        String result = this.netMsgclient.sendMsg(this.netMsgclient, 0, sms.getMobileNo(), sms.getContent(), 0);
        sms.setSendDate(Calendar.getInstance().getTime());
        if (StringUtils.isBlank((String)sms.getSmsId())) {
            sms.setSmsId(UUIDGenerator.generate());
        }
        this.insertSmsLog(sms);
        return result;
    }

    public void insertSmsLog(PfSmsVo sms) {
        this.smsDAO.insertSmsLog(sms);
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SysSmsDao getSmsDAO() {
        return this.smsDAO;
    }

    public void setSmsDAO(SysSmsDao smsDAO) {
        this.smsDAO = smsDAO;
    }
}

