/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SysWorkFlowInstanceServiceImpl
implements SysWorkFlowInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(SysWorkFlowInstanceServiceImpl.class);
    private SysWorkFlowInstanceDao workFlowInstanceDao;
    private SysWorkFlowDefineService workFlowDefineService;
    private Map<String, String> workFlowDetailServerUrlMap;
    private static HttpClient httpClient;
    SysCalendarService sysCalendarService;

    public void setSysCalendarService(SysCalendarService sysCalendarService) {
        this.sysCalendarService = sysCalendarService;
    }

    public SysWorkFlowInstanceDao getWorkFlowInstanceDao() {
        return this.workFlowInstanceDao;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public void setWorkFlowDetailServerUrlMap(Map<String, String> workFlowDetailServerUrlMap) {
        this.workFlowDetailServerUrlMap = workFlowDetailServerUrlMap;
    }

    public void setWorkFlowInstanceDao(SysWorkFlowInstanceDao workFlowInstanceDao) {
        this.workFlowInstanceDao = workFlowInstanceDao;
    }

    public HashMap<String, Object> getGobalVal(String workflowIntanceId) {
        String vals = this.workFlowInstanceDao.getWorkFlowVals(workflowIntanceId);
        if (vals != null && !vals.equals("")) {
            try {
                return (HashMap)JSONUtil.deserialize((String)vals);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Transactional
    public void updateGobalVal(String workflowIntanceId, String valName, Object val) {
        HashMap<String, Object> mapVals = this.getGobalVal(workflowIntanceId);
        if (mapVals == null) {
            mapVals = new HashMap<String, Object>();
        }
        mapVals.put(valName, val);
        try {
            String jsonVals = JSONUtil.serialize(mapVals);
            this.workFlowInstanceDao.updateWorkFlowVals(workflowIntanceId, jsonVals);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getWorkflowInstanceXml(String workflowIntanceId) {
        return this.workFlowInstanceDao.getWorkflowInstanceXml(workflowIntanceId);
    }

    public String getWorkflowInstanceXml(PfWorkFlowInstanceVo intanceVo) {
        return this.getWorkflowInstanceXml(intanceVo.getWorkflowIntanceId());
    }

    @Transactional
    public void createWorkFlowIntance(PfWorkFlowInstanceVo intanceVo) {
        Date beginDate = Calendar.getInstance().getTime();
        intanceVo.setCreateTime(beginDate);
        intanceVo.setOverTime(this.sysCalendarService.getOverTime(beginDate, intanceVo.getTimeLimit()));
        this.workFlowInstanceDao.createWorkFlowIntance(intanceVo);
    }

    public PfWorkFlowInstanceVo getWorkflowInstance(String workflowIntanceId) {
        return this.workFlowInstanceDao.getWorkflowInstance(workflowIntanceId);
    }

    @Transactional
    public void updateWorkFlowIntanceStadus(PfWorkFlowInstanceVo intanceVo) {
        this.workFlowInstanceDao.updateWorkFlowIntanceStadus(intanceVo);
    }

    @Transactional
    public void updateWorkFlowInstanceRemark(PfWorkFlowInstanceVo intanceVo) {
        this.workFlowInstanceDao.updateWorkFlowInstanceRemark(intanceVo);
    }

    @Transactional
    public void updateWorkFlowIntanceOverTime(String wiid, Date overTime) {
        this.workFlowInstanceDao.updateWorkFlowInstanceOverTime(wiid, overTime);
    }

    @Caching(evict={@CacheEvict(value={"WorkFlowInstanceCache"}, key="#workflowIntanceId + 'WorkflowInstanceXmlById'")})
    @Transactional
    public void deleteWorkFlowIntance(String workflowIntanceId) {
        this.workFlowInstanceDao.deleteWorkFlowIntance(workflowIntanceId);
    }

    @Transactional
    public void updateWorkFlowIntanceName(PfWorkFlowInstanceVo intanceVo) {
        this.workFlowInstanceDao.updateWorkFlowIntanceName(intanceVo);
    }

    public PfWorkFlowInstanceVo getWorkflowInstanceByProId(String proId) {
        return this.workFlowInstanceDao.getWorkflowInstanceByProId(proId);
    }

    public String getTaskCount(HashMap<String, String> map) {
        return this.workFlowInstanceDao.getTaskCount(map);
    }

    private String parseWorkFlowVo(PfWorkFlowInstanceVo wfi) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("WorkFlowInstance", PfWorkFlowInstanceVo.class);
        String xml = xstream.toXML((Object)wfi);
        return xml;
    }

    public String getWorkFlowInstanceDetailXml(String workflowIntanceId) {
        PfWorkFlowInstanceVo wfi = this.getWorkflowInstance(workflowIntanceId);
        PfWorkFlowDefineVo wfd = this.workFlowDefineService.getWorkFlowDefine(wfi.getWorkflowDefinitionId());
        PfBusinessVo business = this.workFlowDefineService.getBusiness(wfd.getBusinessId());
        String url = (String)this.workFlowDetailServerUrlMap.get(StringUtils.isNotBlank((String)business.getBusinessCode()) ? business.getBusinessCode() : "system");
        if (StringUtils.isBlank((String)url)) {
            String xml = this.parseWorkFlowVo(wfi);
            logger.info("--getWorkFlowInstanceDetailXml------" + xml);
            return xml;
        }
        String detailUri = wfd.getDetailUrl();
        if (detailUri == null) {
            detailUri = "workFlowDetail.action";
        }
        GetMethod get = new GetMethod(url + (url.endsWith("/") ? "" : "/") + detailUri + (detailUri.indexOf("?") > -1 ? "&" : Character.valueOf('?')) + "id=" + wfi.getProId());
        try {
            httpClient.executeMethod((HttpMethod)get);
            if (get.getStatusCode() == 200) {
                logger.info("--getWorkFlowInstanceDetailXml------" + get.getResponseBodyAsString());
                return get.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            logger.error("get workFlowInstance:[{}] xml detail error,detail:[{}]", (Object)workflowIntanceId, (Object)e);
        }
        logger.error("get workFlowInstance:[{}] xml detail error", (Object)workflowIntanceId);
        return null;
    }

    public Map<String, Integer> statTaskCountMap(HashMap<String, String> paraMap) {
        return this.workFlowInstanceDao.statTaskCountMap(paraMap);
    }

    public int statTaskCountByWiid(String wiid) {
        return this.workFlowInstanceDao.statTaskCountByWiid(wiid);
    }

    public PfUserVo getWorkFlowLastUser(String wiid) {
        return this.workFlowInstanceDao.getWorkFlowLastUser(wiid);
    }

    public List<PfWorkFlowInstanceVo> getWorkFlowsInstanceByDefine(String wdId, int state) {
        return this.workFlowInstanceDao.getWorkFlowsInstanceByDefine(wdId, state);
    }

    @Transactional
    public void UpdateWorkFlowInstanceMonitor(String wiid, String monitorId) {
        this.workFlowInstanceDao.UpdateWorkFlowInstanceMonitor(wiid, monitorId);
    }

    public void updateWorkFlowIntancePriority(String wiid, String priority) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = new PfWorkFlowInstanceVo();
        pfWorkFlowInstanceVo.setPriority(priority);
        pfWorkFlowInstanceVo.setWorkflowIntanceId(wiid);
        this.workFlowInstanceDao.updateWorkFlowIntancePriority(pfWorkFlowInstanceVo);
    }

    public List<HashMap> getWorkflowStatusList(HashMap<String, String> map) {
        return this.workFlowInstanceDao.getWorkflowStatusList(map);
    }

    static {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(10000);
        connectionManager.getParams().setSoTimeout(10000);
        httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }
}

