/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SysWorkFlowDefineServiceImpl
implements SysWorkFlowDefineService {
    private SysWorkFlowDefineDao workFlowDefineDao;

    @Cacheable(value={"WorkFlowDefineCache"}, key="'BusinessList'")
    public List<PfBusinessVo> getBusinessList() {
        return this.workFlowDefineDao.getBusinessList();
    }

    public List<PfBusinessVo> getBusinessSimpleList() {
        return new ArrayList<PfBusinessVo>(this.workFlowDefineDao.getBusinessSimpleList());
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#bId+'Business'")
    public PfBusinessVo getBusiness(String bId) {
        return this.workFlowDefineDao.getBusiness(bId);
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#bId+'WorkFlowDefineListBybId'")
    public List<PfWorkFlowDefineVo> getWorkFlowDefineByBusiness(String bId) {
        return this.workFlowDefineDao.getWorkFlowDefineByBusiness(bId);
    }

    public List<PfWorkFlowDefineVo> getWorkFlowDefineList() {
        return new ArrayList<PfWorkFlowDefineVo>(this.workFlowDefineDao.getWorkFlowDefineList());
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#workDefineId+'WorkFlowDefineById'")
    public PfWorkFlowDefineVo getWorkFlowDefine(String workDefineId) {
        return this.workFlowDefineDao.getWorkFlowDefine(workDefineId);
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#roleIds+#resourceId+#bId+'WorkFlowDefineByRole'")
    public List<PfWorkFlowDefineVo> getWorkFlowDefineListByRole(String roleIds, String resourceId, String bId) {
        return this.workFlowDefineDao.getWorkFlowDefineListByRole(roleIds, resourceId, bId);
    }

    public SysWorkFlowDefineDao getWorkFlowDefineDao() {
        return this.workFlowDefineDao;
    }

    public void setWorkFlowDefineDao(SysWorkFlowDefineDao workFlowDefineDao) {
        this.workFlowDefineDao = workFlowDefineDao;
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#workDefineId+'WorkFlowDefineXmlById'")
    public String getWorkFlowDefineXml(String workDefineId) {
        return this.workFlowDefineDao.getWorkFlowDefineXml(workDefineId);
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#workDefineId+'WorkFlowDefineLocation'")
    public String getWorkFlowDefineLocation(String workDefineId) {
        return this.workFlowDefineDao.getWorkFlowDefineLocation(workDefineId);
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#defineVo.workflowDefinitionId+'WorkFlowDefineXmlById'")
    public String getWorkFlowDefineXml(PfWorkFlowDefineVo defineVo) {
        String instanceXml = this.getWorkFlowDefineXml(defineVo.getWorkflowDefinitionId());
        return instanceXml;
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#defineVo.workflowDefinitionId+'WorkFlowDefineEventById'")
    public String getWorkFlowDefineEventXml(PfWorkFlowDefineVo defineVo) {
        if (defineVo.getEventShell() == null) {
            String xml = this.workFlowDefineDao.getWorkFlowDefineEventXml(defineVo.getWorkflowDefinitionId());
            defineVo.setEventShell(xml);
        }
        return defineVo.getEventShell();
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#workDefineId+'WorkFlowImage'")
    public PfWorkFlowDefineVo getWorkFlowImage(String workDefineId) {
        return this.workFlowDefineDao.getWorkFlowImage(workDefineId);
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="#definitionNo+'WorkFlowByDefinitionByNo'")
    public PfWorkFlowDefineVo getWorkFlowByDefinitionNo(String definitionNo) {
        return this.workFlowDefineDao.getWorkFlowByDefinitionNo(definitionNo);
    }

    @Cacheable(value={"WorkFlowDefineCache"}, key="'AllECWorkFlowDefineList'")
    public List<PfWorkFlowDefineVo> getECWorkFlowDefineList() {
        return this.workFlowDefineDao.getECWorkFlowDefineList();
    }
}

