/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysUserDAO;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfConfigVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.model.PerformerModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;

public class SysUserServiceImpl
implements SysUserService {
    private SysUserDAO userDao;

    @Cacheable(value={"UserCache"}, key="#userName+'UserListByName'")
    public List<PfUserVo> getUserVoListByUserName(String userName) {
        return this.userDao.getUserVoListByUserName(userName);
    }

    @Cacheable(value={"UserCache"}, key="#userId+'UserOrganListById'")
    public List<PfOrganVo> getOrganListByUser(String userId) {
        return this.userDao.getOrganListByUser(userId);
    }

    @Cacheable(value={"UserCache"}, key="#userId+'UserRoleListById'")
    public List<PfRoleVo> getRoleListByUser(String userId) {
        return this.userDao.getRoleListByUser(userId);
    }

    @Cacheable(value={"UserCache"}, key="#loginName+'UserByLoginName'")
    public PfUserVo getUserByloginName(String loginName) {
        return this.userDao.getUserByloginName(loginName);
    }

    @Cacheable(value={"UserCache"}, key="#userId+'RoleListByUserId'")
    public List<String> getRoleListByAgentUser(String userId) {
        return this.userDao.getRoleListByAgentUser(userId);
    }

    public List<PfUserVo> getUserListByOragn(String oragnId) {
        return this.userDao.getUserListByOragn(oragnId);
    }

    @Cacheable(value={"UserCache"}, key="#roleId+'UserListByRoleId'")
    public List<PfUserVo> getUserListByRole(String roleId) {
        return this.userDao.getUserListByRole(roleId);
    }

    @Cacheable(value={"UserCache"}, key="#userId+'UserById'")
    public PfUserVo getUserVo(String userId) {
        return this.userDao.getUserVo(userId);
    }

    @Cacheable(value={"UserCache"}, key="#roleId+'RoleById'")
    public PfRoleVo getRoleVo(String roleId) {
        return this.userDao.getRoleVo(roleId);
    }

    @Cacheable(value={"UserCache"}, key="#organId+'OrganById'")
    public PfOrganVo getOrganVo(String organId) {
        return this.userDao.getOrganVo(organId);
    }

    @Cacheable(value={"UserCache"}, key="#organName+'OrganByName'")
    public PfOrganVo getOrganVoByName(String organName) {
        return this.userDao.getOrganVoByName(organName);
    }

    @Cacheable(value={"UserCache"}, key="#userId+'UserConfig'")
    public PfConfigVo getConfigVo(String userId) {
        PfConfigVo configVo = this.userDao.getConfigVo(userId);
        if (configVo == null) {
            configVo = new PfConfigVo();
            configVo.setUserId(userId);
            configVo.setMessageAutoTime(5);
            configVo.setTaskAutoTime(2);
            configVo.setShowAllNewTask(true);
            configVo.setShowNewTaskHandle(true);
        }
        return configVo;
    }

    @Caching(evict={@CacheEvict(value={"UserCache"}, key="#vo.userId + 'UserConfig'")})
    public void saveConfig(PfConfigVo vo) {
        PfConfigVo configVo = this.userDao.getConfigVo(vo.getUserId());
        if (configVo == null) {
            this.userDao.insertConfig(vo);
        } else {
            this.userDao.saveConfig(vo);
        }
    }

    @Cacheable(value={"UserCache"}, key="#regionCode+'OrganByRegionCode'")
    public List<PfOrganVo> getOrganByRegionCode(String regionCode) {
        List lstOrgan = this.getOrganList();
        ArrayList<PfOrganVo> organList = new ArrayList<PfOrganVo>();
        if (StringUtils.isNotBlank((String)regionCode)) {
            for (PfOrganVo organ : lstOrgan) {
                PfOrganVo o;
                if (StringUtils.isNotBlank((String)organ.getRegionCode())) {
                    if (!regionCode.equals(organ.getRegionCode())) continue;
                    organList.add(organ);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)organ.getSuperOrganId()) || (o = this.dualRegionCode(lstOrgan, organ, regionCode)) == null) continue;
                organList.add(o);
            }
        }
        return organList;
    }

    @Cacheable(value={"UserCache"}, key="#userId+'RegionCodeByUserId'")
    public String getRegionCodeByUserId(String userId) {
        List lstOrgan = this.getOrganList();
        List organList = this.getOrganListByUser(userId);
        if (organList.size() > 0) {
            return this.dualRegionCode(lstOrgan, (PfOrganVo)organList.get(0));
        }
        return null;
    }

    public List<String> getAllUserListPerformers(List<PerformerModel> lstPerformers) {
        ArrayList<String> lstUserIds = new ArrayList<String>();
        for (PerformerModel performer : lstPerformers) {
            List lstUsers;
            if (performer.getUserId() != null && !performer.getUserId().equals("")) {
                if (lstUserIds.contains(performer.getUserId())) continue;
                lstUserIds.add(performer.getUserId());
                continue;
            }
            if (performer.getOrganId() != null && !performer.getOrganId().equals("")) {
                lstUsers = this.getUserListByOragn(performer.getOrganId());
                for (PfUserVo userVo : lstUsers) {
                    if (lstUserIds.contains(userVo.getUserId())) continue;
                    lstUserIds.add(userVo.getUserId());
                }
                continue;
            }
            if (performer.getRoleId() == null) continue;
            lstUsers = this.getUserListByRole(performer.getRoleId());
            for (PfUserVo userVo : lstUsers) {
                if (lstUserIds.contains(userVo.getUserId())) continue;
                lstUserIds.add(userVo.getUserId());
            }
        }
        return lstUserIds;
    }

    public List<String> getUserListPerformersByUserOrgan(List<PerformerModel> lstPerformers, String userId) {
        List lstOrgans = this.getOrganListByUser(userId);
        ArrayList<String> lstOrganIds = new ArrayList<String>();
        for (PfOrganVo organVo : lstOrgans) {
            lstOrganIds.add(organVo.getOrganId());
        }
        ArrayList<String> lstUserIds = new ArrayList<String>();
        block1: for (PerformerModel performer : lstPerformers) {
            if (StringUtils.isNotBlank((String)performer.getUserId())) {
                if (lstUserIds.contains(performer.getUserId())) continue;
                List Organs = this.getOrganListByUser(performer.getUserId());
                for (PfOrganVo organVo : lstOrgans) {
                    if (!lstOrganIds.contains(organVo.getOrganId())) continue;
                    lstUserIds.add(performer.getUserId());
                    continue block1;
                }
                continue;
            }
            if (StringUtils.isNotBlank((String)performer.getOrganId())) {
                if (!lstOrganIds.contains(performer.getOrganId())) continue;
                List lstUsers = this.getUserListByOragn(performer.getOrganId());
                for (PfUserVo userVo : lstUsers) {
                    if (lstUserIds.contains(userVo.getUserId())) continue;
                    lstUserIds.add(userVo.getUserId());
                }
                continue;
            }
            if (!StringUtils.isNotBlank((String)performer.getRoleId())) continue;
            List userIdlist = this.userDao.getUserListByRoleUser(performer.getRoleId(), userId);
            for (String userid : userIdlist) {
                if (lstUserIds.contains(userid)) continue;
                lstUserIds.add(userid);
            }
        }
        return lstUserIds;
    }

    public List<String> getUserListPerformersByDistrict(List<PerformerModel> lstPerformers, String districtCode) {
        ArrayList<String> lstUserIds = new ArrayList<String>();
        block0: for (PerformerModel performer : lstPerformers) {
            if (StringUtils.isNotBlank((String)performer.getUserId())) {
                if (lstUserIds.contains(performer.getUserId())) continue;
                List Organs = this.getOrganListByUser(performer.getUserId());
                for (PfOrganVo organVo : Organs) {
                    if (!districtCode.equals(organVo.getRegionCode())) continue;
                    lstUserIds.add(performer.getUserId());
                    continue block0;
                }
                continue;
            }
            if (StringUtils.isNotBlank((String)performer.getOrganId())) {
                String organRegionCode = this.getOrganVo(performer.getOrganId()).getRegionCode();
                if (!districtCode.equals(organRegionCode)) continue;
                List lstUsers = this.getUserListByOragn(performer.getOrganId());
                for (PfUserVo userVo : lstUsers) {
                    if (lstUserIds.contains(userVo.getUserId())) continue;
                    lstUserIds.add(userVo.getUserId());
                }
                continue;
            }
            if (!StringUtils.isNotBlank((String)performer.getRoleId())) continue;
            List userlist = this.getUserListByRole(performer.getRoleId());
            block3: for (PfUserVo pfUserVo : userlist) {
                List Organs = this.getOrganListByUser(pfUserVo.getUserId());
                for (PfOrganVo organVo : Organs) {
                    if (!districtCode.equals(organVo.getRegionCode())) continue;
                    lstUserIds.add(pfUserVo.getUserId());
                    continue block3;
                }
            }
        }
        return lstUserIds;
    }

    private PfOrganVo dualRegionCode(List<PfOrganVo> organList, PfOrganVo organ, String regionCode) {
        for (PfOrganVo o : organList) {
            if (!o.getOrganId().equals(organ.getSuperOrganId()) || !(StringUtils.isNotBlank((String)o.getRegionCode()) ? o.getRegionCode().equals(regionCode) : StringUtils.isNotBlank((String)o.getSuperOrganId()) && this.dualRegionCode(organList, o, regionCode) != null)) continue;
            return organ;
        }
        return null;
    }

    private String dualRegionCode(List<PfOrganVo> organList, PfOrganVo organ) {
        if (StringUtils.isNotBlank((String)organ.getRegionCode())) {
            return organ.getRegionCode();
        }
        if (StringUtils.isNotBlank((String)organ.getSuperOrganId())) {
            for (PfOrganVo o : organList) {
                if (!o.getOrganId().equals(organ.getSuperOrganId())) continue;
                if (StringUtils.isNotBlank((String)o.getRegionCode())) {
                    return o.getRegionCode();
                }
                return this.dualRegionCode(organList, o);
            }
        }
        return null;
    }

    @Cacheable(value={"UserCache"}, key="#roleId+#organId+'UserListByRoleAndOrgan'")
    public List<PfUserVo> getUserListByRoleAndOrgan(String roleId, String organId) {
        return this.userDao.getUserListByRoleAndOrgan(roleId, organId);
    }

    public List<PfUserVo> getUserListByRoleAndOrganIds(String roleId, List<String> organList) {
        return this.userDao.getUserListByRoleAndOrganIds(roleId, organList);
    }

    @Cacheable(value={"UserAgentCache"}, key="#userId+'UserAgentListByUserId'")
    public String getUserAgentList(String userId) {
        List lstUsers = this.userDao.getUserAgentList(userId);
        StringBuffer strBuffer = new StringBuffer("");
        for (PfUserVo userVo : lstUsers) {
            strBuffer.append("'" + userVo.getUserId() + "',");
        }
        strBuffer.append("'" + userId + "'");
        return strBuffer.toString();
    }

    @Cacheable(value={"UserAgentCache"}, key="#userId+'AgentUserListByUserId'")
    public List<PfTaskAgentVo> getAgentUserList(String userId) {
        if (userId.equals("0")) {
            return this.userDao.getAllAgentUserList();
        }
        return this.userDao.getAgentUserList(userId);
    }

    @Cacheable(value={"UserCache"}, key="#roleName+'RoleVoListByRoleNameFuzzy'")
    public List<PfRoleVo> getRoleVoListByRoleNameFuzzy(String roleName) {
        return this.userDao.getRoleVoListByRoleNameFuzzy(roleName);
    }

    @Caching(evict={@CacheEvict(value={"UserAgentCache"}, allEntries=true)})
    public void deleteTaskAgent(String taskAgentId) {
        this.userDao.deleteTaskAgent(taskAgentId);
    }

    public List<PfTaskAgentVo> getTaskAgentListByUser(String userId) {
        return this.userDao.getTaskAgentListByUser(userId);
    }

    @Caching(evict={@CacheEvict(value={"UserAgentCache"}, allEntries=true)})
    public void stopTaskAgent(String taskAgentId) {
        this.userDao.stopTaskAgent(taskAgentId);
    }

    @Caching(evict={@CacheEvict(value={"UserAgentCache"}, allEntries=true)})
    public void insertTaskAgent(PfTaskAgentVo pfTaskAgentVo) {
        this.userDao.insertTaskAgent(pfTaskAgentVo);
    }

    @Caching(evict={@CacheEvict(value={"UserAgentCache"}, allEntries=true)})
    public void updateTaskAgent(PfTaskAgentVo pfTaskAgentVo) {
        this.userDao.updateTaskAgent(pfTaskAgentVo);
    }

    @Cacheable(value={"UserAgentCache"}, key="#taskAgentId+'TaskAgent'")
    public PfTaskAgentVo getTaskAgent(String taskAgentId) {
        return this.userDao.getTaskAgent(taskAgentId);
    }

    @Caching(evict={@CacheEvict(value={"UserCache"}, allEntries=true)})
    public void updateUser(PfUserVo pfUserVo) {
        this.userDao.updateUser(pfUserVo);
    }

    @Cacheable(value={"UserCache"}, key="'AllUsers'")
    public List<PfUserVo> getAllUsers() {
        return this.userDao.getAllUsers();
    }

    public List<PfOrganVo> getAllOrganList() {
        return this.getOrganList();
    }

    @Cacheable(value={"UserCache"}, key="'AllOrganList'")
    public List<PfOrganVo> getOrganList() {
        return this.userDao.getOrganList();
    }

    public List<PfOrganVo> getOrganListByRemark(String remark) {
        return this.userDao.getOrganListByRemark(remark);
    }

    @Cacheable(value={"UserCache"}, key="'AllRoleList'")
    public List<PfRoleVo> getRoleList() {
        return this.userDao.getRoleList();
    }

    @Cacheable(value={"UserCache"}, key="#userId+'UserRegionCode'")
    public String getUserRegionCode(String userId) {
        return this.userDao.getUserRegionCode(userId);
    }

    @Cacheable(value={"UserCache"}, key="#orginName+'UsersByOrganName'")
    public List<PfUserVo> getUsersByOrganName(String orginName) {
        return this.userDao.getUsersByOrganName(orginName);
    }

    @Caching(evict={@CacheEvict(value={"UserCache"}, allEntries=true)})
    public boolean savePassWord(String userId, String loginPassWord) {
        return this.userDao.savePassWord(userId, loginPassWord);
    }

    @Caching(evict={@CacheEvict(value={"UserCache"}, allEntries=true)})
    public boolean saveSignPassword(String userId, String signPassword) {
        return this.userDao.saveSignPassword(userId, signPassword);
    }

    @Cacheable(value={"UserCache"}, key="#userName+'UserListByUserNameFuzzy'")
    public List<PfUserVo> getUserVoListByUserNameFuzzy(String userName) {
        return this.userDao.getUserVoListByUserNameFuzzy(userName);
    }

    public SysUserDAO getUserDao() {
        return this.userDao;
    }

    public void setUserDao(SysUserDAO userDao) {
        this.userDao = userDao;
    }

    @Cacheable(value={"UserCache"}, key="#regionCode+'OrganListByRegionCode'")
    public List<PfOrganVo> getOrganListByRegionCode(String regionCode) {
        return this.userDao.getOrganListByRegionCode(regionCode);
    }
}

