/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.google.common.collect.Maps;
import com.gtis.plat.dao.SysTaskDao;
import com.gtis.plat.dao.SysTaskHistoryDao;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SysTaskServiceImpl
implements SysTaskService {
    SysTaskDao taskDao;
    SysTaskHistoryDao taskHistoryDao;
    SysCalendarService sysCalendarService;
    SysActivityService activityService;

    public void setActivityService(SysActivityService activityService) {
        this.activityService = activityService;
    }

    public void setSysCalendarService(SysCalendarService sysCalendarService) {
        this.sysCalendarService = sysCalendarService;
    }

    public SysTaskHistoryDao getTaskHistoryDao() {
        return this.taskHistoryDao;
    }

    public void setTaskHistoryDao(SysTaskHistoryDao taskHistoryDao) {
        this.taskHistoryDao = taskHistoryDao;
    }

    @Transactional
    public void createActivity(PfActivityVo activityVo) {
        PfActivityVo aVo = this.taskDao.getActivityBywIdandadId(activityVo.getWorkflowInstanceId(), activityVo.getActivityDefinitionId());
        if (aVo == null) {
            activityVo.setBeginTime(Calendar.getInstance().getTime());
            this.taskDao.createActivity(activityVo);
        } else {
            this.updateActivityStadus(activityVo.getActivityId(), activityVo.getActivityState());
        }
    }

    @Transactional
    public void createTask(PfTaskVo taskVo) {
        List lstTasks = this.taskDao.getTaskListByUserIdAndActivity(taskVo.getActivityId(), taskVo.getUserVo().getUserId());
        if (lstTasks == null || lstTasks.size() == 0) {
            PfActivityVo activityVo;
            Date beginDate = Calendar.getInstance().getTime();
            if (taskVo.getBeginTime() == null) {
                taskVo.setBeginTime(beginDate);
            }
            if (taskVo.getOverTime() == null && (activityVo = this.activityService.getActivityById(taskVo.getActivityId())) != null) {
                taskVo.setOverTime(this.sysCalendarService.getOverTime(beginDate, activityVo.getTimeLimit()));
            }
            this.taskDao.createTask(taskVo);
        } else if (!StringUtils.isBlank((String)taskVo.getTaskBefore())) {
            for (PfTaskVo aTask : lstTasks) {
                this.taskDao.updateTasksByBefore(aTask.getTaskId(), taskVo.getTaskBefore());
                PfActivityVo activityVo = this.activityService.getActivityById(aTask.getActivityId());
                if (activityVo == null || aTask.getOverTime() != null) continue;
                this.taskDao.updateTaskOverTime(aTask.getTaskId(), this.sysCalendarService.getOverTime(aTask.getBeginTime(), activityVo.getTimeLimit()));
            }
        }
    }

    @Transactional
    public void createTasks(List<PfTaskVo> tasklist) {
        for (PfTaskVo taskVo : tasklist) {
            this.createTask(taskVo);
        }
    }

    public List<PfActivityVo> getActivityByBefore(String activityId) {
        return this.taskDao.getActivityByBefore(activityId);
    }

    @Transactional
    public void updateHistoryTask(PfTaskVo taskVo) {
        this.taskHistoryDao.updateTaskHistory(taskVo);
    }

    @Transactional
    public void updateTaskHistoryOverTime(String taskId, Date overTime) {
        this.taskHistoryDao.updateTaskHistoryOverTime(taskId, overTime);
    }

    @Transactional
    public void deleteActivityTask(String activityId) {
        this.taskDao.deleteActivityTask(activityId);
    }

    @Transactional
    public void deleteTask(String taskId) {
        this.taskDao.deleteTask(taskId);
    }

    @Transactional
    public void updateTaskOverTime(String taskId, Date overTime) {
        this.taskDao.updateTaskOverTime(taskId, overTime);
    }

    public PfActivityVo getActivity(String activityId) {
        return this.taskDao.getActivity(activityId);
    }

    public PfActivityVo getActivityBywIdandadId(String workflowInstanceId, String activityDefinitionId) {
        return this.taskDao.getActivityBywIdandadId(workflowInstanceId, activityDefinitionId);
    }

    public List<PfTaskVo> getTaskListByActivity(String activityId) {
        return this.taskDao.getTaskListByActivity(activityId);
    }

    public List<PfTaskVo> getHistoryTasks(String activityId) {
        return this.taskHistoryDao.getHistoryTasksListByActivity(activityId);
    }

    public int getAllTaskCountByActivityId(String activityId) {
        return this.taskDao.getAllTaskCountByActivityId(activityId);
    }

    public PfTaskVo getTask(String taskId) {
        return this.taskDao.getTask(taskId);
    }

    public PfTaskVo getTaskAll(String taskId) {
        return this.taskDao.getTaskAll(taskId);
    }

    public List<PfActivityVo> getWorkFlowInstanceActivityList(String workflowInstanceId) {
        return this.taskDao.getWorkFlowInstanceActivityList(workflowInstanceId);
    }

    @Transactional
    public void insertTaskHistory(String taskId) {
        PfTaskVo taskVo = this.taskDao.getTask(taskId);
        if (taskVo != null) {
            taskVo.setFinishTime(Calendar.getInstance().getTime());
            this.taskHistoryDao.insertTaskHistory(taskVo);
        }
    }

    @Transactional
    public void updateActivityBackStadus(String activityId, boolean isBack) {
        if (isBack) {
            this.taskDao.updateActivityBack(activityId);
        } else {
            this.taskDao.updateActivityForword(activityId);
        }
    }

    @Transactional
    public void updateActivityRemark(String activityId, String remark) {
        this.taskDao.updateActivityRemark(activityId, remark);
    }

    @Transactional
    public void updateActivityStadus(String activityId, int stadus) {
        PfActivityVo activityVo = new PfActivityVo();
        activityVo.setActivityId(activityId);
        switch (stadus) {
            case 1: {
                activityVo.setBeginTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(1);
                break;
            }
            case 2: {
                activityVo.setFinishTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(2);
                break;
            }
            case 5: {
                activityVo.setFinishTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(5);
                break;
            }
            default: {
                activityVo.setActivityState(stadus);
            }
        }
        this.taskDao.updateActivityStadus(activityVo);
    }

    @Transactional
    public void updateActivityHandlesDay(String activityId, int handlesDay) {
        PfActivityVo activityVo = new PfActivityVo();
        activityVo.setActivityId(activityId);
        activityVo.setHandlesDay(handlesDay);
        this.taskDao.updateActivityHandlesDay(activityVo);
    }

    @Transactional
    public void updateCooperateStateDown(String activityId) {
        this.taskDao.updateCooperateStateDown(activityId);
    }

    @Transactional
    public void updateCooperateStateUp(String activityId) {
        this.taskDao.updateCooperateStateUp(activityId);
    }

    public SysTaskDao getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(SysTaskDao taskDao) {
        this.taskDao = taskDao;
    }

    public List<PfTaskVo> getHistoryTaskListByInstance(String workFlowInstanceId) {
        ArrayList<PfTaskVo> result = new ArrayList<PfTaskVo>();
        List activityList = this.taskDao.getWorkFlowInstanceAllActivityList(workFlowInstanceId);
        for (PfActivityVo activityVo : activityList) {
            List tasksHistory = this.taskHistoryDao.getHistoryTasksListByActivity(activityVo.getActivityId());
            result.addAll(tasksHistory);
        }
        return result;
    }

    public List<PfTaskVo> getHistoryTaskListByDefineId(String workFlowInstanceId, String activityDefineId) {
        ArrayList<PfTaskVo> result = new ArrayList<PfTaskVo>();
        PfActivityVo activityVo = this.taskDao.getActivityBywIdandadId(workFlowInstanceId, activityDefineId);
        if (result != null) {
            List tasksHistory = this.taskHistoryDao.getHistoryTasksListByActivity(activityVo.getActivityId());
            result.addAll(tasksHistory);
        }
        return result;
    }

    public List<PfTaskVo> getTaskListByInstance(String workFlowInstanceId) {
        return this.taskDao.getTaskListByInstance(workFlowInstanceId);
    }

    public List<PfActivityVo> getWorkFlowInstanceAllActivityList(String workFlowInstanceId) {
        return this.taskDao.getWorkFlowInstanceAllActivityList(workFlowInstanceId);
    }

    public PfTaskVo getHistoryTask(String taskId) {
        return this.taskHistoryDao.getHistoryTask(taskId);
    }

    public List<PfTaskVo> getHistoryTaskByBefore(PfTaskVo taskVo) {
        ArrayList<PfTaskVo> lstResult = new ArrayList<PfTaskVo>();
        if (!StringUtils.isBlank((String)taskVo.getTaskBefore())) {
            String[] taskIds;
            for (String taskId : taskIds = StringUtils.split((String)taskVo.getTaskBefore(), (String)",")) {
                if (StringUtils.isBlank((String)taskId)) continue;
                PfTaskVo taskHisVo = this.getHistoryTask(taskId);
                if (taskHisVo == null) {
                    taskHisVo = this.getTask(taskId);
                }
                if (taskHisVo == null) continue;
                lstResult.add(taskHisVo);
            }
        }
        return lstResult;
    }

    @Transactional
    public void deleteWorkFlowInstanceActivity(String workflowIntanceId) {
        this.taskDao.deleteWorkFlowInstanceActivity(workflowIntanceId);
    }

    @Transactional
    public void deleteHistoryTaskByActivityId(String activityId) {
        List tasks = this.taskHistoryDao.getHistoryTasksListByActivity(activityId);
        if (tasks != null) {
            for (PfTaskVo task : tasks) {
                this.taskHistoryDao.deleteHistoryTask(task);
            }
        }
    }

    @Transactional
    public void updateTask(PfTaskVo taskVo) {
        this.taskDao.updateTask(taskVo);
    }

    @Transactional
    public void updateTempTask(String activityId) {
        this.taskDao.updateTempTask(activityId);
    }

    public List<PfTaskVo> getTasksByBefore(String taskId) {
        return this.taskDao.getTasksByBefore(taskId);
    }

    @Transactional
    public void createTaskByHistroy(String taskId) {
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("taskId", taskId);
        mapParam.put("beginTime", Calendar.getInstance().getTime());
        this.taskDao.createTaskByHistroy(mapParam);
    }

    @Transactional
    public void deleteHistoryTask(String taskId) {
        PfTaskVo task = this.taskHistoryDao.getHistoryTask(taskId);
        if (task != null) {
            this.taskHistoryDao.deleteHistoryTask(task);
        }
    }

    @Transactional
    public void deleteActivity(String activityId) {
        this.taskDao.deleteActivity(activityId);
    }

    @Transactional
    public void updateTaskStadus(String taskId) {
        String acceptTaskId = this.taskDao.selectIsAcceptedTask(taskId);
        if (StringUtils.isBlank((String)acceptTaskId)) {
            this.taskDao.updateTaskStadus(taskId);
        }
    }

    public List<PfTaskVo> getHistoryTaskListByActivity(String activityId) {
        return this.taskHistoryDao.getHistoryTasksListByActivity(activityId);
    }

    @Transactional
    public void deleteOtherTasks(String taskId) {
        this.taskDao.deleteOtherTasks(taskId);
    }

    @Transactional
    public void updateAssignmentHistoryRepeat(String assignmentId) {
        PfTaskVo taskVo = this.taskHistoryDao.getHistoryTask(assignmentId);
        taskVo.setRepeat(true);
        this.taskHistoryDao.updateTaskHistory(taskVo);
    }
}

