/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.BaseDao;
import com.gtis.plat.service.SysSjdService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.SjdVo;
import com.gtis.plat.vo.SjdclVo;
import com.gtis.plat.vo.StuffConfigVo;
import com.gtis.util.SjdUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;

public class SysSjdServiceImpl
implements SysSjdService {
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private NodeService nodeService;
    private BaseDao sjdDaoImpl;

    public SjdVo getSjdVoByProid(String proid) {
        return (SjdVo)this.sjdDaoImpl.getObject(proid, "PROID");
    }

    public List<SjdclVo> getSjdclListByProid(String proid) {
        SjdVo vo = this.getSjdVoByProid(proid);
        if (vo != null) {
            return SjdUtil.getSjdclListBySjdVo((SjdVo)vo);
        }
        return null;
    }

    public BaseDao getSjdDaoImpl() {
        return this.sjdDaoImpl;
    }

    public void setSjdDaoImpl(BaseDao sjdDaoImpl) {
        this.sjdDaoImpl = sjdDaoImpl;
    }

    public void createSjdByPreviousWorkflow(String proId, String userName, Integer nodeId, String oldProId) {
        try {
            String configId = "";
            String configName = "";
            PfWorkFlowInstanceVo newWorkflowInstance = this.sysWorkFlowInstanceService.getWorkflowInstance(proId);
            if (newWorkflowInstance != null && StringUtils.isNotBlank((String)newWorkflowInstance.getWorkflowDefinitionId())) {
                configId = newWorkflowInstance.getWorkflowDefinitionId();
                PfWorkFlowDefineVo workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(configId);
                configName = workFlowDefineVo.getWorkflowName();
            }
            if (StringUtils.isBlank((String)configId)) {
                configId = "custom";
            }
            SjdVo sjdVo = new SjdVo();
            sjdVo.setProid(newWorkflowInstance.getProId());
            sjdVo.setSjdid(UUIDGenerator.generate());
            sjdVo.setSjd_sj_date(CommonUtil.getCurrDate());
            sjdVo.setSjd_sjr(userName);
            sjdVo.setBusiType(configId);
            sjdVo.setSjd_sqlx(configName);
            sjdVo.setSjd_bh_year(Integer.valueOf(Integer.parseInt(CommonUtil.getCurrYear())));
            HashMap<String, Object> param = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)configName)) {
                param.put("SJD_SQLX", configName);
            }
            param.put("SJD_BH_YEAR", sjdVo.getSjd_bh_year());
            Integer bh_xh = (Integer)this.sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
            if (bh_xh == null) {
                bh_xh = 0;
            }
            sjdVo.setSjd_bh_xh(Integer.valueOf(bh_xh + 1));
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            String lsh = decimalFormat.format(sjdVo.getSjd_bh_xh());
            sjdVo.setSjd_bh("");
            this.sjdDaoImpl.insertObjectByIbatisStr((Object)sjdVo, null);
            SjdVo relsjdVo = this.getSjdVoByProid(oldProId);
            List relsjdclList = new ArrayList();
            if (relsjdVo != null && relsjdVo.getSjd_cl() != null) {
                sjdVo.setSjd_cl(relsjdVo.getSjd_cl());
                relsjdclList = SjdUtil.getSjdclListBySjdVo((SjdVo)sjdVo);
            }
            this.initDefaultFile(sjdVo, nodeId.intValue(), configId, relsjdclList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertSjdVo(String proid, String userName, String busiType, String sqlx) {
        SjdVo sjdVo = new SjdVo();
        sjdVo.setProid(proid);
        sjdVo.setSjdid(UUIDGenerator.generate());
        sjdVo.setSjd_sj_date(CommonUtil.getCurrDate());
        if (StringUtils.isNotBlank((String)userName)) {
            sjdVo.setSjd_sjr(userName);
        }
        if (StringUtils.isBlank((String)busiType)) {
            sjdVo.setBusiType("custom");
        } else {
            sjdVo.setBusiType(busiType);
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
        sjdVo.setSjd_bh_year(Integer.valueOf(Integer.parseInt(sdf1.format(new Date()))));
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)sqlx)) {
            param.put("SJD_SQLX", sqlx);
            sjdVo.setSjd_sqlx(sqlx);
        }
        param.put("SJD_BH_YEAR", sjdVo.getSjd_bh_year());
        Integer bh_xh = (Integer)this.sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
        if (bh_xh == null) {
            bh_xh = 0;
        }
        sjdVo.setSjd_bh_xh(Integer.valueOf(bh_xh + 1));
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        String lsh = decimalFormat.format(sjdVo.getSjd_bh_xh());
        String bh = sqlx + sjdVo.getSjd_bh_year() + lsh;
        sjdVo.setSjd_bh(bh);
        this.sjdDaoImpl.insertObject((Object)sjdVo);
    }

    private List<SjdclVo> initDefaultFile(SjdVo vo, int nid, String wdid, List<SjdclVo> clList) {
        try {
            if (clList == null) {
                clList = new ArrayList<SjdclVo>();
            }
            String curFileNames = "";
            for (int i = 0; i < clList.size(); ++i) {
                curFileNames = curFileNames + "[@" + clList.get(i).getName() + "@],";
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("WORKFLOW_DEFINITION_ID", wdid);
            List zdbList = this.sjdDaoImpl.getObjectListByIbatisStr(param, "get_PF_STUFF_CONFIG");
            if (zdbList != null && zdbList.size() > 0) {
                for (int i = 0; i < zdbList.size(); ++i) {
                    StuffConfigVo configVo = (StuffConfigVo)zdbList.get(i);
                    if (configVo == null || !StringUtils.isNotBlank((String)configVo.getStuffName()) || StringUtils.indexOf((String)curFileNames, (String)("[@" + configVo.getStuffName() + "@]")) >= 0) continue;
                    SjdclVo clVo = new SjdclVo();
                    clVo.setData_id(UUIDGenerator.generate());
                    clVo.setProid(vo.getProid());
                    clVo.setSjdid(vo.getSjdid());
                    clVo.setName(configVo.getStuffName());
                    clVo.setXh(configVo.getStuffXh());
                    clVo.setNum(configVo.getStuffCount());
                    clVo.setBz(configVo.getRemark());
                    clVo.setType(configVo.getMeterial());
                    clVo.setYsnum(configVo.getYsnum());
                    clVo.setDbnum(configVo.getDbnum());
                    Node nodeChild = this.getOrCreateNode(Integer.valueOf(nid), clVo.getName());
                    clVo.setNode_id(nodeChild.getId());
                    clList.add(i, clVo);
                }
            }
            if (clList != null) {
                String clJson = JSONUtil.serialize(clList);
                vo.setSjd_cl(clJson.getBytes());
                this.sjdDaoImpl.updateObjectByIbatisStr((Object)vo, "update_PF_SJD_CL");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return clList;
    }

    private Node getOrCreateNode(Integer nid, String fName) {
        Node nodeChild = null;
        try {
            nodeChild = this.nodeService.getNode(nid, fName, true);
        }
        catch (Exception e) {
            nodeChild = this.nodeService.createNode(nid, fName);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            this.nodeService.save(nodeChild);
        }
        if (nodeChild == null) {
            nodeChild = this.nodeService.getNode(nid, fName, true);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            this.nodeService.save(nodeChild);
        }
        return nodeChild;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return this.sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public SysWorkFlowDefineService getSysWorkFlowDefineService() {
        return this.sysWorkFlowDefineService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }
}

