/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysCalendarDAO;
import com.gtis.plat.service.SysCalendarService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysCalendarServiceWholeDayImpl
implements SysCalendarService {
    static Logger logger = LoggerFactory.getLogger(SysCalendarServiceWholeDayImpl.class);
    SysCalendarDAO calendarDAO;
    static List<String> specialHolidays = new ArrayList();
    static List<String> specialWorkdays = new ArrayList();
    static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat simpleDateFullFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("HH:mm");
    static String SYS_MAX_DATE = "2999-12-31";

    public void init() {
        ArrayList<String> specialHolidays = new ArrayList<String>();
        ArrayList<String> specialWorkdays = new ArrayList<String>();
        Calendar ca = Calendar.getInstance();
        int yearInt = Calendar.getInstance().get(1);
        ca.set(1, yearInt - 1);
        ca.set(6, 1);
        Date beginDate = ca.getTime();
        ca.set(1, yearInt + 2);
        ca.set(6, 1);
        ca.add(6, -1);
        Date endDate = ca.getTime();
        List specialDates = this.calendarDAO.getSpecialDateList(beginDate, endDate);
        for (Map sDate : specialDates) {
            if (sDate.get("CAL_TYPE").equals("\u5de5\u4f5c\u65e5")) {
                specialWorkdays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
                continue;
            }
            specialHolidays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
        }
    }

    public Date getOverTime(Date beginDate, String timeLimit) {
        if (StringUtils.isNotBlank((String)timeLimit)) {
            double days = 0.0;
            days = timeLimit.endsWith("h") ? Math.ceil(Double.parseDouble(timeLimit.substring(0, timeLimit.length() - 1)) / 24.0) : Double.parseDouble(timeLimit);
            if (days > 0.0 && beginDate != null) {
                Date bDate = null;
                Calendar beginCalendar = Calendar.getInstance();
                beginCalendar.setTime(beginDate);
                beginCalendar.add(6, 1);
                beginCalendar.set(11, 0);
                beginCalendar.set(13, 0);
                beginCalendar.set(12, 0);
                beginCalendar.set(14, 0);
                bDate = this.IsHoliday(beginCalendar.getTime()) ? this.getNextWorkDay(beginCalendar.getTime()) : beginCalendar.getTime();
                Calendar overCalendar = Calendar.getInstance();
                overCalendar.setTime(bDate);
                overCalendar.set(11, 23);
                overCalendar.set(13, 59);
                overCalendar.set(12, 59);
                overCalendar.set(14, 999);
                Date overDate = overCalendar.getTime();
                int i = 1;
                while ((double)i < days) {
                    overDate = this.getNextWorkDay(overDate);
                    ++i;
                }
                return overDate;
            }
            if (days == 0.0 && beginDate != null) {
                Calendar overTime = Calendar.getInstance();
                overTime.set(11, 23);
                overTime.set(13, 59);
                overTime.set(12, 59);
                overTime.set(14, 999);
                return overTime.getTime();
            }
        }
        return this.getMaxDate();
    }

    public double getWorkDayHours(Date beginDate, Date endDate) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(beginDate);
        beginCalendar.set(11, 0);
        beginCalendar.set(13, 0);
        beginCalendar.set(12, 0);
        beginCalendar.set(14, 0);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        endCalendar.set(11, 23);
        endCalendar.set(13, 59);
        endCalendar.set(12, 59);
        endCalendar.set(14, 999);
        double result = 0.0;
        while (beginCalendar.before(endCalendar)) {
            if (!this.IsHoliday(beginCalendar.getTime())) {
                result += 24.0;
            }
            beginCalendar.add(6, 1);
        }
        return result;
    }

    public Date getMaxDate() {
        try {
            return simpleDateFormat.parse(SYS_MAX_DATE);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public boolean IsHoliday(Date bDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(bDate);
        String dateStr = simpleDateFormat.format(bDate);
        if (ca.get(7) == 1 || ca.get(7) == 7) {
            return !specialWorkdays.contains(dateStr);
        }
        return specialHolidays.contains(dateStr);
    }

    public Date getNextWorkDay(Date bDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(bDate);
        ca.add(6, 1);
        while (this.IsHoliday(ca.getTime())) {
            ca.add(6, 1);
        }
        return ca.getTime();
    }

    public void reloadWorkdaysAndHolidays() {
        this.init();
    }

    public int getTimeLeft(Date overDate) {
        Calendar overCalendar = Calendar.getInstance();
        overCalendar.setTime(overDate);
        overCalendar.set(11, 23);
        overCalendar.set(13, 59);
        overCalendar.set(12, 59);
        overCalendar.set(14, 999);
        DateTime overDateTime = new DateTime((Object)overCalendar.getTime());
        Calendar sysCalendar = Calendar.getInstance();
        sysCalendar.set(11, 0);
        sysCalendar.set(13, 0);
        sysCalendar.set(12, 0);
        sysCalendar.set(14, 0);
        DateTime sysDateTime = new DateTime((Object)sysCalendar.getTime());
        Period hourPeriod = new Period((ReadableInstant)sysDateTime, (ReadableInstant)overDateTime, PeriodType.hours());
        Period dayPeriod = new Period((ReadableInstant)sysDateTime, (ReadableInstant)overDateTime, PeriodType.days());
        int hours = hourPeriod.getHours();
        if (sysDateTime.isAfter((ReadableInstant)overDateTime)) {
            int leftDays = -1;
            sysCalendar.set(6, -1);
            sysCalendar.set(11, 23);
            sysCalendar.set(13, 59);
            sysCalendar.set(12, 59);
            sysCalendar.set(14, 999);
            sysDateTime = new DateTime((Object)sysCalendar.getTime());
            for (int i = dayPeriod.getDays(); i < 0; ++i) {
                if (this.IsHoliday(sysDateTime.plusDays(i).toDate())) continue;
                --leftDays;
            }
            return leftDays;
        }
        if (hours >= 0 && hours <= 24) {
            return 0;
        }
        int leftDays = 0;
        for (int i = 1; i <= dayPeriod.getDays(); ++i) {
            if (this.IsHoliday(sysDateTime.plusDays(i).toDate())) continue;
            ++leftDays;
        }
        return leftDays;
    }

    public void setCalendarDAO(SysCalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }
}

