/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysCalendarDAO;
import com.gtis.plat.service.SysCalendarService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SysCalendarServiceDefaultImpl
implements SysCalendarService {
    static Logger logger = LoggerFactory.getLogger(SysCalendarServiceDefaultImpl.class);
    SysCalendarDAO calendarDAO;
    static List<String> specialHolidays = new ArrayList();
    static List<String> specialWorkdays = new ArrayList();
    static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat simpleDateFullFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("HH:mm");
    static String SYS_MAX_DATE = "2999-12-31";
    String workDayAMStartTime = "08:30";
    String workDayAMEndTime = "12:00";
    String workDayPMStartTime = "13:00";
    String workDayPMEndTime = "17:30";
    double workDayHours = 8.0;

    public void setCalendarDAO(SysCalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }

    public void init() {
        if (StringUtils.isNotBlank((String)AppConfig.getProperty((String)"WorkDayAMStartTime"))) {
            this.workDayAMStartTime = AppConfig.getProperty((String)"WorkDayAMStartTime");
        }
        if (StringUtils.isNotBlank((String)AppConfig.getProperty((String)"WorkDayAMEndTime"))) {
            this.workDayAMStartTime = AppConfig.getProperty((String)"WorkDayAMEndTime");
        }
        if (StringUtils.isNotBlank((String)AppConfig.getProperty((String)"WorkDayPMStartTime"))) {
            this.workDayAMStartTime = AppConfig.getProperty((String)"WorkDayPMStartTime");
        }
        if (StringUtils.isNotBlank((String)AppConfig.getProperty((String)"WorkDayPMEndTime"))) {
            this.workDayAMStartTime = AppConfig.getProperty((String)"WorkDayPMEndTime");
        }
        ArrayList<String> specialHolidays = new ArrayList<String>();
        ArrayList<String> specialWorkdays = new ArrayList<String>();
        Calendar ca = Calendar.getInstance();
        int yearInt = Calendar.getInstance().get(1);
        ca.set(1, yearInt - 1);
        ca.set(6, 1);
        Date beginDate = ca.getTime();
        ca.set(1, yearInt + 2);
        ca.set(6, 1);
        ca.add(6, -1);
        Date endDate = ca.getTime();
        List specialDates = this.calendarDAO.getSpecialDateList(beginDate, endDate);
        for (Map sDate : specialDates) {
            if (sDate.get("CAL_TYPE").equals("\u5de5\u4f5c\u65e5")) {
                specialWorkdays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
                continue;
            }
            specialHolidays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
        }
        try {
            this.workDayHours = SysCalendarServiceDefaultImpl.getDateDiffHour((Date)simpleDateFullFormat.parse("2014-01-01 " + this.workDayAMStartTime), (Date)simpleDateFullFormat.parse("2014-01-01 " + this.workDayAMEndTime)) + SysCalendarServiceDefaultImpl.getDateDiffHour((Date)simpleDateFullFormat.parse("2014-01-01 " + this.workDayPMStartTime), (Date)simpleDateFullFormat.parse("2014-01-01 " + this.workDayPMEndTime));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    private static double getDateDiffHour(Date beginDate, Date endDate) {
        long time = endDate.getTime() - beginDate.getTime();
        return (double)time * 1.0 / 3600000.0;
    }

    public boolean IsHoliday(Date bDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(bDate);
        String dateStr = simpleDateFormat.format(bDate);
        if (ca.get(7) == 1 || ca.get(7) == 7) {
            return !specialWorkdays.contains(dateStr);
        }
        return specialHolidays.contains(dateStr);
    }

    public Date getNextWorkDay(Date bDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(bDate);
        ca.add(6, 1);
        while (this.IsHoliday(ca.getTime())) {
            ca.add(6, 1);
        }
        try {
            ca.setTime(simpleDateFullFormat.parse(simpleDateFormat.format(ca.getTime()) + " " + this.workDayAMStartTime));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return ca.getTime();
    }

    public void reloadWorkdaysAndHolidays() {
        this.init();
    }

    public int getTimeLeft(Date overDate) {
        return 0;
    }

    public Date getMaxDate() {
        try {
            return simpleDateFormat.parse(SYS_MAX_DATE);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[-+]?[0-9]+(\\.[0-9]+)?");
        return pattern.matcher(str).matches();
    }

    public Date getOverTime(Date beginDate, String timeLimit) {
        if (StringUtils.isNotBlank((String)timeLimit)) {
            if (SysCalendarServiceDefaultImpl.isNumeric((String)timeLimit)) {
                double days = Double.parseDouble(timeLimit);
                return this.getOverTime(beginDate, days * this.workDayHours);
            }
            double hours = Double.parseDouble(timeLimit.substring(0, timeLimit.length() - 1));
            return this.getOverTime(beginDate, hours);
        }
        return this.getMaxDate();
    }

    public Date getOverTime(Date beginDate, double hours) {
        Date bDate = beginDate;
        if (hours > 0.0 && beginDate != null) {
            if (this.IsHoliday(bDate)) {
                bDate = this.getNextWorkDay(beginDate);
            } else if (bDate.before(this.buildDate(bDate, this.workDayAMStartTime))) {
                bDate = this.buildDate(bDate, this.workDayAMStartTime);
            } else if (bDate.after(this.buildDate(bDate, this.workDayAMEndTime)) && bDate.before(this.buildDate(bDate, this.workDayPMStartTime))) {
                bDate = this.buildDate(bDate, this.workDayPMStartTime);
            } else if (bDate.after(this.buildDate(bDate, this.workDayPMEndTime))) {
                bDate = this.getNextWorkDay(bDate);
            }
            Date overDate = bDate;
            int days = (int)Math.floor(hours / this.workDayHours);
            for (int i = 0; i < days; ++i) {
                overDate = this.getNextWorkDay(overDate);
            }
            overDate = this.buildDate(overDate, simpleDateTimeFormat.format(bDate));
            double otherHours = hours % this.workDayHours;
            overDate = this.addWorkHoursToDate(overDate, otherHours);
            return overDate;
        }
        return this.getMaxDate();
    }

    public double getWorkDayHours(Date beginDate, Date endDate) {
        double result = 0.0;
        Date bDate = beginDate;
        if (this.IsHoliday(bDate)) {
            bDate = this.getNextWorkDay(beginDate);
        } else if (bDate.before(this.buildDate(bDate, this.workDayAMStartTime))) {
            bDate = this.buildDate(bDate, this.workDayAMStartTime);
        } else if (bDate.after(this.buildDate(bDate, this.workDayAMEndTime)) && bDate.before(this.buildDate(bDate, this.workDayPMStartTime))) {
            bDate = this.buildDate(bDate, this.workDayPMStartTime);
        } else if (bDate.after(this.buildDate(bDate, this.workDayPMEndTime))) {
            bDate = this.getNextWorkDay(bDate);
        }
        Calendar ca = Calendar.getInstance();
        int days = 0;
        while (bDate.before(endDate)) {
            ca.setTime(bDate);
            ca.add(6, 1);
            if (!ca.getTime().before(endDate) || this.IsHoliday(ca.getTime())) break;
            ++days;
            bDate = ca.getTime();
        }
        return (double)days * this.workDayHours + this.calWorkDayHoursDiff(bDate, endDate);
    }

    private double calWorkDayHoursDiff(Date beginDate, Date endDate) {
        Date bDate = beginDate;
        double result = 0.0;
        Date amDate = this.buildDate(bDate, this.workDayAMEndTime);
        if (bDate.before(amDate) && endDate.after(amDate)) {
            if (endDate.after(amDate)) {
                return (result += SysCalendarServiceDefaultImpl.getDateDiffHour((Date)bDate, (Date)amDate)) + this.calWorkDayHoursDiff(this.buildDate(bDate, this.workDayPMStartTime), endDate);
            }
            return SysCalendarServiceDefaultImpl.getDateDiffHour((Date)bDate, (Date)endDate);
        }
        Date pmDate = this.buildDate(bDate, this.workDayPMEndTime);
        if (bDate.before(pmDate)) {
            if (endDate.after(pmDate)) {
                return (result += SysCalendarServiceDefaultImpl.getDateDiffHour((Date)bDate, (Date)pmDate)) + this.calWorkDayHoursDiff(this.getNextWorkDay(bDate), endDate);
            }
            return SysCalendarServiceDefaultImpl.getDateDiffHour((Date)bDate, (Date)endDate);
        }
        return 0.0;
    }

    private Date addWorkHoursToDate(Date endDate, double hours) {
        Date amEndTime = this.buildDate(endDate, this.workDayAMEndTime);
        if (endDate.before(amEndTime)) {
            Date oDate = this.addHoursToDate(endDate, hours);
            if (oDate.before(amEndTime)) {
                return oDate;
            }
            double diffHour = SysCalendarServiceDefaultImpl.getDateDiffHour((Date)endDate, (Date)amEndTime);
            return this.addWorkHoursToDate(this.buildDate(endDate, this.workDayPMStartTime), hours - diffHour);
        }
        Date pmEndTime = this.buildDate(endDate, this.workDayPMEndTime);
        if (endDate.before(pmEndTime)) {
            Date oDate = this.addHoursToDate(endDate, hours);
            if (oDate.before(pmEndTime)) {
                return oDate;
            }
            double diffHour = SysCalendarServiceDefaultImpl.getDateDiffHour((Date)endDate, (Date)pmEndTime);
            return this.addWorkHoursToDate(this.getNextWorkDay(endDate), hours - diffHour);
        }
        return endDate;
    }

    private Date buildDate(Date cDate, String timeStr) {
        try {
            return simpleDateFullFormat.parse(simpleDateFormat.format(cDate) + " " + timeStr);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    private Date addHoursToDate(Date cDate, double hours) {
        int hour = (int)Math.floor(hours);
        int min = (int)Math.round((hours - (double)hour) * 60.0);
        Calendar ca = Calendar.getInstance();
        ca.setTime(cDate);
        ca.add(11, hour);
        ca.add(12, min);
        return ca.getTime();
    }

    public static void main(String[] arg) throws Exception {
        SysCalendarServiceDefaultImpl calendarService = new SysCalendarServiceDefaultImpl();
        System.out.println(calendarService.getWorkDayHours(simpleDateFullFormat.parse("2014-10-09 04:30 "), simpleDateFullFormat.parse("2014-10-10 09:30 ")));
    }
}

