/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysAuthorDao;
import com.gtis.plat.dao.SysTaskDao;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class SysAuthorServiceImpl
implements SysAuthorService {
    SysAuthorDao authorDAO;
    SysWorkFlowInstanceDao intanceDAO;
    SysTaskDao taskDao;

    public List<PfPartitionInfoVo> getTaskFormFunAuthorList(String taskId, String roles, String rId) {
        List<Object> lstResult = new Vector<PfPartitionInfoVo>();
        if (taskId == null || taskId.equals("")) {
            return lstResult;
        }
        PfTaskVo taskVo = this.taskDao.getTaskAll(taskId);
        PfActivityVo activityVo = this.taskDao.getActivity(taskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = this.intanceDAO.getWorkflowInstance(activityVo.getWorkflowInstanceId());
        lstResult = this.authorDAO.getTaskFormFunAuthorList(workFlowInstanceVo.getWorkflowDefinitionId(), activityVo.getActivityDefinitionId(), rId);
        return lstResult;
    }

    public List<PfPartitionInfoVo> getTaskFormAuthorList(String taskId, String roles, String rId) {
        List<Object> lstResult = new Vector<PfPartitionInfoVo>();
        if (taskId == null || taskId.equals("")) {
            return lstResult;
        }
        PfTaskVo taskVo = this.taskDao.getTask(taskId);
        PfActivityVo activityVo = this.taskDao.getActivity(taskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = this.intanceDAO.getWorkflowInstance(activityVo.getWorkflowInstanceId());
        if (roles != null && !roles.equals("")) {
            lstResult = this.authorDAO.getTaskFormAuthorList(workFlowInstanceVo.getWorkflowDefinitionId(), activityVo.getActivityDefinitionId(), rId);
        }
        return lstResult;
    }

    public List<PfPartitionInfoVo> getProjectResrouceFunAuthorList(String proid, String roles, String rId) {
        AbstractList lstResult = new Vector<PfPartitionInfoVo>();
        if (proid == null || proid.equals("")) {
            return lstResult;
        }
        PfWorkFlowInstanceVo workFlowInstanceVo = this.intanceDAO.getWorkflowInstanceByProId(proid);
        Object result = this.authorDAO.getIntanceAuthorXML(workFlowInstanceVo.getWorkflowDefinitionId(), rId, roles);
        lstResult = new ArrayList();
        try {
            if (result != null) {
                Document doc = DocumentHelper.parseText((String)("<Rows>" + result.toString() + "</Rows>"));
                List lstNodes = doc.selectNodes("//Partition[@OperType='0']");
                for (Node node : lstNodes) {
                    String pId = node.valueOf("@Id");
                    List lstResult1 = this.authorDAO.getPartitionFunList(pId);
                    for (PfPartitionInfoVo partitionInfoVo : lstResult1) {
                        if (this.IsPartitionAlReadyIn((List)lstResult, partitionInfoVo.getElementId())) continue;
                        lstResult.add(partitionInfoVo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < lstResult.size(); ++i) {
            ((PfPartitionInfoVo)lstResult.get(i)).setOperateType(0);
        }
        return lstResult;
    }

    private boolean IsPartitionAlReadyIn(List<PfPartitionInfoVo> lstResult, String eId) {
        for (PfPartitionInfoVo partitionInfoVo : lstResult) {
            if (!partitionInfoVo.getElementId().equals(eId)) continue;
            return true;
        }
        return false;
    }

    public List<PfPartitionInfoVo> getSystemResrouceFunAuthorList(String roles, String rId) {
        List lstResult = null;
        if (roles != null && roles.trim().length() > 0) {
            lstResult = this.authorDAO.getSystemResrouceEnableList(rId, roles);
        }
        return lstResult;
    }

    public void processXmlDocument(Document doc, String taskId, String resourceId) {
        PfTaskVo taskVo = this.taskDao.getTask(taskId);
        PfActivityVo activityVo = this.taskDao.getActivity(taskVo.getActivityId());
        PfWorkFlowInstanceVo vo = this.intanceDAO.getWorkflowInstance(activityVo.getWorkflowInstanceId());
        String wdId = vo.getWorkflowDefinitionId();
        String aId = activityVo.getActivityDefinitionId();
        if (wdId == null || aId == null) {
            this.processXmlReadOnly(doc);
        } else {
            List lstElement = this.authorDAO.getTaskFormAuthorList(wdId, aId, resourceId);
            this.processXmlDocument(doc, this.buildElementMap(lstElement));
        }
    }

    public void processProjectXmlDocument(Document doc, HttpServletRequest request, String resourceId) {
        this.processXmlReadOnly(doc);
    }

    public void processSystemXmlDocument(Document doc, HttpServletRequest request, String resourceId) {
        String rolesId = SessionUtil.getUserInfo((HttpServletRequest)request).getRoleIds();
        List lstElement = this.authorDAO.getSystemResrouceAuthorList(resourceId, rolesId);
        this.processXmlDocument(doc, this.buildElementMap(lstElement));
    }

    private HashMap<String, PfPartitionInfoVo> buildElementMap(List<PfPartitionInfoVo> lstElement) {
        HashMap<String, PfPartitionInfoVo> map = new HashMap<String, PfPartitionInfoVo>();
        for (PfPartitionInfoVo vo : lstElement) {
            map.put(vo.getElementId(), vo);
        }
        return map;
    }

    public void processXmlReadOnly(Document doc) {
        List lstNodes = doc.selectNodes("//ElementDefine");
        for (int i = 0; i < lstNodes.size(); ++i) {
            Element elementData = (Element)lstNodes.get(i);
            elementData.addAttribute("Disabled", "true");
        }
        List lstGroupNodes = doc.selectNodes("//GroupDefine");
        for (int i = 0; i < lstGroupNodes.size(); ++i) {
            Element elementData = (Element)lstGroupNodes.get(i);
            elementData.addAttribute("Disabled", "true");
            List lstChildNodes = elementData.selectNodes("ElementDefine");
            for (int j = 0; j < lstChildNodes.size(); ++j) {
                Element elementChildData = (Element)lstChildNodes.get(j);
                elementChildData.addAttribute("Disabled", "true");
            }
        }
    }

    private void processXmlDocument(Document doc, HashMap<String, PfPartitionInfoVo> map) {
        List lstNodes = doc.selectNodes("//Define/ElementDefine");
        StringBuffer strOprateId = new StringBuffer();
        for (int i = 0; i < lstNodes.size(); ++i) {
            Element elementData = (Element)lstNodes.get(i);
            String id = elementData.valueOf("@Id");
            if (map.get(id) != null) {
                PfPartitionInfoVo element = map.get(id);
                if (element.getOperateType() > 0) {
                    elementData.addAttribute("Disabled", "true");
                    continue;
                }
                elementData.addAttribute("Disabled", "");
                strOprateId.append(element.getElementId() + ",");
                continue;
            }
            strOprateId.append(id + ",");
        }
        List lstGroupNodes = doc.selectNodes("//GroupDefine");
        for (int i = 0; i < lstGroupNodes.size(); ++i) {
            Element elementData = (Element)lstGroupNodes.get(i);
            String id = elementData.valueOf("@Id");
            if (map.get(id) != null) {
                Element elementChildData;
                int j;
                List lstChildNodes;
                PfPartitionInfoVo element = map.get(id);
                if (element.getOperateType() > 0) {
                    elementData.addAttribute("Disabled", "true");
                    lstChildNodes = elementData.selectNodes("ElementDefine");
                    for (j = 0; j < lstChildNodes.size(); ++j) {
                        elementChildData = (Element)lstChildNodes.get(j);
                        elementChildData.addAttribute("Disabled", "true");
                    }
                    continue;
                }
                elementData.addAttribute("Disabled", "");
                lstChildNodes = elementData.selectNodes("ElementDefine");
                for (j = 0; j < lstChildNodes.size(); ++j) {
                    elementChildData = (Element)lstChildNodes.get(j);
                    elementChildData.addAttribute("Disabled", "");
                }
                continue;
            }
            strOprateId.append(id + ",");
        }
        strOprateId.append("-1");
        this.addHiddenElement(doc, strOprateId.toString());
    }

    private void addHiddenElement(Document iDoc, String xml) {
        Element root = iDoc.getRootElement();
        Element hiddenNode = (Element)root.selectSingleNode("//HiddenData");
        if (hiddenNode == null) {
            hiddenNode = root.addElement("HiddenData");
        }
        try {
            Element tmpNode = hiddenNode.addElement("ElementData");
            tmpNode.addAttribute("Id", "_ElmenetIdArray");
            tmpNode.setText(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAuthorJsHtml(List<PfPartitionInfoVo> lstElement) {
        StringBuffer strBuffer = new StringBuffer();
        for (PfPartitionInfoVo vo : lstElement) {
            if (vo.getOperateType() <= 0) continue;
            strBuffer.append("setControl('" + vo.getElementId() + "',false);");
        }
        return strBuffer.toString();
    }

    public boolean queryTaskElement(String wiid, String taskid, String rId, String eleName) {
        return this.authorDAO.queryTaskElement(wiid, taskid, rId, eleName);
    }

    public SysAuthorDao getAuthorDAO() {
        return this.authorDAO;
    }

    public void setAuthorDAO(SysAuthorDao authorDAO) {
        this.authorDAO = authorDAO;
    }

    public SysWorkFlowInstanceDao getIntanceDAO() {
        return this.intanceDAO;
    }

    public void setIntanceDAO(SysWorkFlowInstanceDao intanceDAO) {
        this.intanceDAO = intanceDAO;
    }

    public SysTaskDao getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(SysTaskDao taskDao) {
        this.taskDao = taskDao;
    }
}

