/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.portal.web;

import com.gtis.plat.portal.PortalManager;
import com.gtis.plat.portal.model.Page;
import com.gtis.plat.portal.model.Site;
import com.gtis.plat.service.CountProvider;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.SessionAware;
import org.apache.struts2.json.JSONUtil;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;

public class PortalAction
implements Action,
SessionAware {
    public static final String PORTAL_SITE = "portal_site";
    private String owner;
    private String page;
    private PortalManager portalManager;
    private Map<String, Object> session;
    private Map<String, Integer> counts;
    private static Mapper mapper = new DozerBeanMapper();

    public Map<String, Integer> getCounts() {
        return this.counts;
    }

    public void setOwner(String owner) {
        if (StringUtils.isNotBlank((String)owner)) {
            this.owner = owner;
        }
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setPortalManager(PortalManager portalManager) {
        this.portalManager = portalManager;
    }

    public Site getSite() {
        Site site;
        if (this.owner == null) {
            site = (Site)this.session.get(PORTAL_SITE);
            if (site == null) {
                site = this.portalManager.getSite(SessionUtil.getCurrentUserId());
                this.session.put(PORTAL_SITE, site);
            }
        } else {
            site = this.portalManager.getSite(this.owner);
        }
        return site;
    }

    public String execute() throws Exception {
        return "success";
    }

    public String count() throws Exception {
        List countProviders = this.portalManager.getCountProviders();
        this.counts = new HashMap();
        for (CountProvider countProvider : countProviders) {
            this.counts.put(countProvider.getName(), countProvider.getCount());
        }
        return "count";
    }

    public String site() throws Exception {
        return "site";
    }

    public String save() throws Exception {
        Page p = (Page)mapper.map(JSONUtil.deserialize((String)this.page), Page.class);
        Site site = this.getSite();
        site.getPages().set(site.getPages().indexOf(p), p);
        this.portalManager.saveSite(site);
        return "none";
    }

    public String reset() throws Exception {
        this.portalManager.removeSite(this.owner == null ? SessionUtil.getCurrentUserId() : this.owner);
        if (this.owner == null) {
            this.session.remove(PORTAL_SITE);
        }
        return "none";
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }
}

