/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.form.print.xmlutil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VoXml {
    private Object vo = null;

    public VoXml(Object vo) {
        this.vo = vo;
    }

    public String getXMLData() {
        String retvalue = this.getXML();
        return retvalue;
    }

    private List getFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (Field aField : this.vo.getClass().getDeclaredFields()) {
            String fieldname = aField.getName();
            fieldname = fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
            list.add(fieldname);
        }
        return list;
    }

    private String getXML() {
        StringBuffer sb = new StringBuffer();
        List list = this.getFields();
        for (String fieldname : list) {
            String methodname = "get" + fieldname;
            Method method = this.getMethod(methodname);
            if (method == null) continue;
            String datastr = "";
            String fieldtype = this.getFiledType(method);
            datastr = "<data name=\"" + fieldname.trim() + "\" type=\"String\">" + this.getValue(method, fieldtype.trim()) + "</data>\n";
            sb.append(datastr);
        }
        return sb.toString();
    }

    private Method getMethod(String methodName) {
        Method method = null;
        try {
            method = this.vo.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            method = null;
            e.printStackTrace();
        }
        return method;
    }

    private String getValue(Method method, String fieldtype) {
        String retvalue = null;
        Object retobj = null;
        try {
            retobj = method.invoke(this.vo, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retobj == null) {
            retvalue = "";
        } else if (fieldtype.equalsIgnoreCase("String")) {
            retvalue = (String)retobj;
        } else if (fieldtype.equals("int")) {
            int temp = (Integer)retobj;
            retvalue = Integer.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("Boolean")) {
            Boolean temp = (Boolean)retobj;
            retvalue = Boolean.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("float")) {
            float temp = ((Float)retobj).floatValue();
            retvalue = Float.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("double")) {
            double temp = (Double)retobj;
            retvalue = Double.toString(temp);
        } else if (fieldtype.equals("BigDecimal")) {
            BigDecimal temp = (BigDecimal)retobj;
            retvalue = temp.toString();
        } else if (fieldtype.equals("long")) {
            long temp = (Long)retobj;
            retvalue = Long.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("short")) {
            short temp = (Short)retobj;
            retvalue = Short.toString(temp);
        } else if (fieldtype.equals("byte")) {
            byte temp = (Byte)retobj;
            retvalue = Byte.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("Integer")) {
            Integer tempInt = (Integer)retobj;
            retvalue = String.valueOf(tempInt);
        } else if (fieldtype.equalsIgnoreCase("Date")) {
            Date temp = (Date)retobj;
            retvalue = temp.getYear() + 1900 + "\u5e74" + (temp.getMonth() + 1) + "\u6708" + temp.getDate() + "\u65e5";
        } else {
            retvalue = "";
        }
        return retvalue;
    }

    private String getFiledType(Method method) {
        String fieldtype = method.getReturnType().toString();
        int pos = fieldtype.lastIndexOf(".");
        if (pos > 0) {
            fieldtype = fieldtype.substring(pos + 1);
        }
        return fieldtype;
    }
}

