/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.form.print.xmlutil;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;

public class ResultSetXml {
    public static final String DATA_TYPE_MASTER = "master";
    public static final String DATA_TYPE_DETAIL = "detail";
    private ResultSet rs = null;
    private String datatype = "master";

    public ResultSetXml(ResultSet rs, String datatype) {
        this.rs = rs;
        this.datatype = datatype;
    }

    public String getXMLData() {
        String retvalue = "";
        retvalue = this.datatype.equalsIgnoreCase("Master") ? this.getMaster() : this.getDetial();
        return retvalue;
    }

    private String getDetial() {
        String xml = "";
        String lineStr = "";
        String datavalue = "";
        try {
            ResultSetMetaData rsmd = this.rs.getMetaData();
            if (rsmd != null) {
                int count = rsmd.getColumnCount();
                int j = 0;
                while (this.rs.next()) {
                    xml = xml + "<row ID=\"" + j + "\">\n";
                    int i = 1;
                    for (i = 1; i <= count; ++i) {
                        lineStr = "";
                        String fieldType = rsmd.getColumnTypeName(i);
                        if (fieldType.equalsIgnoreCase("date")) {
                            Date tempDate = this.rs.getDate(rsmd.getColumnName(i));
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            datavalue = sdf.format(tempDate);
                        } else {
                            datavalue = fieldType.equalsIgnoreCase("varchar2") || fieldType.equalsIgnoreCase("varchar") || fieldType.equalsIgnoreCase("char") ? this.rs.getString(rsmd.getColumnName(i)) : (fieldType.equalsIgnoreCase("number") ? this.rs.getBigDecimal(i) + "" : this.rs.getString(rsmd.getColumnName(i)));
                        }
                        if (datavalue == null || datavalue == "0" || StringUtils.endsWithIgnoreCase((String)datavalue, (String)"null")) {
                            datavalue = "";
                        }
                        lineStr = lineStr + " name=\"" + rsmd.getColumnName(i) + "\"" + " type=\"String\"";
                        lineStr = "<data " + lineStr + ">" + datavalue + "</data>\n";
                        xml = xml + lineStr;
                    }
                    xml = xml + "</row>\n";
                    ++j;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMaster() {
        String xml = "";
        String lineStr = "";
        String datavalue = "";
        try {
            ResultSetMetaData rsmd = this.rs.getMetaData();
            if (rsmd != null) {
                int count = rsmd.getColumnCount();
                boolean j = false;
                if (this.rs.next()) {
                    int i = 1;
                    for (i = 1; i <= count; ++i) {
                        lineStr = "";
                        datavalue = this.rs.getString(rsmd.getColumnName(i));
                        if (datavalue == null || datavalue == "0") {
                            datavalue = "";
                        }
                        lineStr = lineStr + " name=\"" + rsmd.getColumnName(i) + "\"" + " type=\"" + rsmd.getColumnTypeName(i) + "\"";
                        lineStr = "<data " + lineStr + ">" + datavalue + "</data>";
                        xml = xml + lineStr;
                    }
                }
            }
        }
        catch (Exception e) {
            xml = "";
            e.printStackTrace();
        }
        return xml;
    }
}

