/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.dao;

import com.gtis.plat.vo.PfTaskVo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

public class SysTaskHistoryDao
extends SqlMapClientDaoSupport {
    @Cacheable(value={"TaskHistoryCache"}, key="#taskId+'HistoryTask'")
    public PfTaskVo getHistoryTask(String taskId) {
        return (PfTaskVo)super.getSqlMapClientTemplate().queryForObject("getHistoryTask", (Object)taskId);
    }

    @Cacheable(value={"TaskHistoryCache"}, key="#activityId+'HistoryTasksListByActivity'")
    public List<PfTaskVo> getHistoryTasksListByActivity(String activityId) {
        return super.getSqlMapClientTemplate().queryForList("getHistoryTaskListByActivity", (Object)activityId);
    }

    @Caching(evict={@CacheEvict(value={"TaskHistoryCache"}, key="#taskVo.taskId + 'HistoryTask'"), @CacheEvict(value={"TaskHistoryCache"}, key="#taskVo.activityId + 'HistoryTasksListByActivity'")})
    public void insertTaskHistory(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().insert("insertTaskHistory", (Object)taskVo);
    }

    @Caching(evict={@CacheEvict(value={"TaskHistoryCache"}, key="#taskVo.taskId + 'HistoryTask'"), @CacheEvict(value={"TaskHistoryCache"}, key="#taskVo.activityId + 'HistoryTasksListByActivity'")})
    public void updateTaskHistory(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().update("updateTaskHistory", (Object)taskVo);
    }

    @Caching(evict={@CacheEvict(value={"TaskHistoryCache"}, key="#taskVo.taskId + 'HistoryTask'"), @CacheEvict(value={"TaskHistoryCache"}, key="#taskVo.activityId + 'HistoryTasksListByActivity'")})
    public void deleteHistoryTask(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().delete("deleteHistoryTask", (Object)taskVo.getTaskId());
    }

    @Caching(evict={@CacheEvict(value={"TaskHistoryCache"}, key="#taskId + 'HistoryTask'"), @CacheEvict(value={"TaskHistoryCache"}, allEntries=true)})
    public void updateTaskHistoryOverTime(String taskId, Date overTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskId", taskId);
        paramMap.put("overTime", overTime);
        super.getSqlMapClientTemplate().update("updateTaskHistoryOverTime", paramMap);
    }
}

