/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.dao;

import com.gtis.plat.dao.SysSmsDao;
import com.gtis.plat.vo.PfSmsVo;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class SysSmsDao {
    private static final Logger logger = LoggerFactory.getLogger(SysSmsDao.class);
    private SimpleJdbcTemplate jdbcTemplate;
    private String insertSmsSQL;
    private String stateSql;
    private String getSmsListByUserSQL;
    private String getSmsListSQL;
    private String sendUnit;
    private String smsUrl;
    private static int index = 1;

    public String insertSms(PfSmsVo sms) throws IOException {
        String content = sms.getContent();
        sms.setContent(content + " \n " + this.sendUnit);
        sms.setSmsId(SysSmsDao.buildIndex());
        if (StringUtils.isBlank((String)this.smsUrl)) {
            this.jdbcTemplate.update(this.insertSmsSQL, (SqlParameterSource)this.createSmsParameterSource(sms));
            sms.setSn(sms.getSmsId());
            logger.debug("insert sms ({}) success", (Object)sms);
        } else {
            HttpClient httpClient = new HttpClient();
            PostMethod postMethod = new PostMethod(this.smsUrl);
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("phone", sms.getMobileNo()), new NameValuePair("sender", new String(sms.getSender().getBytes("GBK"), "ISO-8859-1")), new NameValuePair("msg", new String(sms.getContent().getBytes("GBK"), "ISO-8859-1"))};
            postMethod.setRequestBody(data);
            int status = httpClient.executeMethod((HttpMethod)postMethod);
            if (status == 200) {
                sms.setSn(postMethod.getResponseBodyAsString());
            } else {
                throw new IOException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
            }
        }
        return sms.getSn();
    }

    public void insertSmsLog(PfSmsVo sms) {
        String insertLogSQL = "insert into PF_MOBILE_LOG(LOG_ID,SENDER,RECEIVE,CONTENT,TIME,NO,SN) values(:id,:sender,:receive,:content,:sendDate,:no,:sn)";
        this.jdbcTemplate.update("insert into PF_MOBILE_LOG(LOG_ID,SENDER,RECEIVE,CONTENT,TIME,NO,SN) values(:id,:sender,:receive,:content,:sendDate,:no,:sn)", (SqlParameterSource)this.createSmsParameterSource(sms));
    }

    public String msgState(String msgNo) throws IOException {
        if (StringUtils.isNotBlank((String)this.smsUrl)) {
            StringBuilder sb = new StringBuilder(this.smsUrl);
            sb.append("?SMSID=").append(msgNo);
            String url = sb.toString();
            String result = "";
            HttpClient httpClient = new HttpClient();
            GetMethod method = new GetMethod(url);
            int status = httpClient.executeMethod((HttpMethod)method);
            if (status == 200) {
                result = method.getResponseBodyAsString();
            }
            return result;
        }
        String[] msg = new String[]{msgNo};
        List result = this.jdbcTemplate.queryForList(this.stateSql, new Object[]{msgNo});
        if (result.size() > 0) {
            return "1";
        }
        return "0";
    }

    public List<PfSmsVo> getSmsList() {
        return this.jdbcTemplate.query(this.getSmsListSQL, (ParameterizedRowMapper)new SmsRowMapper(this, null), new Object[0]);
    }

    private MapSqlParameterSource createSmsParameterSource(PfSmsVo sms) {
        Random random = new Random();
        String randomNo = String.valueOf(random.nextInt(1000));
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource().addValue("id", (Object)sms.getSmsId()).addValue("no", (Object)sms.getMobileNo()).addValue("content", (Object)(sms.getContent() + "--" + randomNo + "--")).addValue("sender", (Object)sms.getSender()).addValue("receive", (Object)sms.getReceive()).addValue("sendDate", (Object)sms.getSendDate()).addValue("sn", (Object)sms.getSn()).addValue("sendEndDate", (Object)new Date(System.currentTimeMillis() + 86400000L));
        return mapSqlParameterSource;
    }

    public static String buildIndex() {
        Calendar calCurrent = Calendar.getInstance();
        int intDay = calCurrent.get(5);
        int intMonth = calCurrent.get(2) + 1;
        int intYear = calCurrent.get(1);
        String now = "" + intYear + intMonth + intDay;
        now = Integer.toHexString(Integer.parseInt(now) + Integer.parseInt(RandomStringUtils.randomNumeric((int)5)));
        if (index > 9000) {
            index = 1;
        }
        now = now + index;
        ++index;
        return now;
    }

    public void setJdbcTemplate(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setInsertSmsSQL(String insertSmsSQL) {
        this.insertSmsSQL = insertSmsSQL;
    }

    public void setGetSmsListSQL(String getSmsListSQL) {
        this.getSmsListSQL = getSmsListSQL;
    }

    public void setGetSmsListByUserSQL(String getSmsListByUserSQL) {
        this.getSmsListByUserSQL = getSmsListByUserSQL;
    }

    public void setStateSql(String stateSql) {
        this.stateSql = stateSql;
    }

    public void setSendUnit(String sendUnit) {
        this.sendUnit = sendUnit;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }
}

