/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.dao;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.impl.SysSmsServiceImpl;
import com.gtis.plat.service.impl.SysUserServiceImpl;
import com.gtis.plat.vo.PfMessageAcceptAwokeVo;
import com.gtis.plat.vo.PfMessageAcceptVo;
import com.gtis.plat.vo.PfMessageSendAwokeVo;
import com.gtis.plat.vo.PfMessageSendVo;
import com.gtis.plat.vo.PfSmsVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.spring.Container;
import com.gtis.util.WebFormatter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

public class SysMessageDAO
extends SqlMapClientDaoSupport {
    public static final int MESSAGEACCEPT_STATUS1 = 1;
    public static final int MESSAGEACCEPT_STATUS2 = 2;

    public PfMessageAcceptVo getAcceptMessage(String acceptMessageId) {
        return (PfMessageAcceptVo)super.getSqlMapClientTemplate().queryForObject("queryacceptmsg", (Object)acceptMessageId);
    }

    public PfMessageAcceptAwokeVo getAcceptMsgAwoke(String acceptMessageId) {
        return (PfMessageAcceptAwokeVo)super.getSqlMapClientTemplate().queryForObject("queryacceptmsgawoke", (Object)acceptMessageId);
    }

    public PfMessageSendVo getSendMessage(String sendMessageId) {
        return (PfMessageSendVo)super.getSqlMapClientTemplate().queryForObject("querysendmsg", (Object)sendMessageId);
    }

    public PfMessageSendAwokeVo getSendMsgAwokeById(String sendMsgAwokeId) {
        return (PfMessageSendAwokeVo)super.getSqlMapClientTemplate().queryForObject("querysendmsgawoke", (Object)sendMsgAwokeId);
    }

    public void updateMessageStatus(String acceptMessageId) {
        super.getSqlMapClientTemplate().update("updatemsgstatus", (Object)acceptMessageId);
    }

    public void updateNotifyStatus(String acceptMessageId) {
        super.getSqlMapClientTemplate().update("updatenotifystatus", (Object)acceptMessageId);
    }

    public List<String> getMessageList(HashMap<String, String> map) {
        return super.getSqlMapClientTemplate().queryForList("querymessagelist", map);
    }

    public String getPopMessage(String acceptUserId) {
        return (String)super.getSqlMapClientTemplate().queryForObject("selectnoreadmsgcount", (Object)acceptUserId);
    }

    public String getPopNotify(String acceptUserId) {
        return (String)super.getSqlMapClientTemplate().queryForObject("selectnoreadnotifycount", (Object)acceptUserId);
    }

    public String getReadedMessageCount(String msgSendId) {
        return (String)super.getSqlMapClientTemplate().queryForObject("selectreadmsgcount", (Object)msgSendId);
    }

    public String getReadedAwokeCount(String awokeId) {
        return (String)super.getSqlMapClientTemplate().queryForObject("selectreadAwokecount", (Object)awokeId);
    }

    public boolean insertMessage(PfMessageSendVo pfMessageSendVo) {
        boolean isok = true;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String datestr = df.format(new Date());
            Timestamp orldate = Timestamp.valueOf(datestr);
            pfMessageSendVo.setMessageSendDate((Date)orldate);
            super.getSqlMapClientTemplate().insert("insertsendmessage", (Object)pfMessageSendVo);
            if (pfMessageSendVo.getMessageAcceptUser().length() > 0) {
                if (pfMessageSendVo.getMessageAcceptUser().equals("1")) {
                    List userIdList = this.getAllUserId();
                    for (int i = 0; i < userIdList.size(); ++i) {
                        PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
                        pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
                        pfMessageAcceptVo.setMessageAcceptStadus(1);
                        pfMessageAcceptVo.setUserId((String)userIdList.get(i));
                        pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
                        super.getSqlMapClientTemplate().insert("insertacceptmessage", (Object)pfMessageAcceptVo);
                    }
                } else if (pfMessageSendVo.getMessageAcceptUser().equals("2")) {
                    List userIdList = this.getUserIdWhereBJJG("BJJG");
                    for (int i = 0; i < userIdList.size(); ++i) {
                        PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
                        pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
                        pfMessageAcceptVo.setMessageAcceptStadus(1);
                        pfMessageAcceptVo.setUserId((String)userIdList.get(i));
                        pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
                        super.getSqlMapClientTemplate().insert("insertacceptmessage", (Object)pfMessageAcceptVo);
                    }
                } else if (pfMessageSendVo.getMessageAcceptUser().equals("3")) {
                    List userIdList = this.getUserIdByRegionCodeLength(Integer.valueOf(9));
                    if (userIdList != null) {
                        for (int i = 0; i < userIdList.size(); ++i) {
                            PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
                            pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
                            pfMessageAcceptVo.setMessageAcceptStadus(1);
                            pfMessageAcceptVo.setUserId((String)userIdList.get(i));
                            pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
                            super.getSqlMapClientTemplate().insert("insertacceptmessage", (Object)pfMessageAcceptVo);
                        }
                    }
                } else {
                    StringTokenizer st = new StringTokenizer(pfMessageSendVo.getMessageAcceptUser(), ",");
                    while (st.hasMoreTokens()) {
                        PfMessageAcceptVo pfMessageAcceptVo = new PfMessageAcceptVo();
                        pfMessageAcceptVo.setMessageAcceptId(UUIDGenerator.generate());
                        pfMessageAcceptVo.setMessageAcceptStadus(1);
                        pfMessageAcceptVo.setUserId(st.nextToken());
                        pfMessageAcceptVo.setMessageSendVo(pfMessageSendVo);
                        super.getSqlMapClientTemplate().insert("insertacceptmessage", (Object)pfMessageAcceptVo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isok = false;
        }
        return isok;
    }

    public boolean insertMsgAwoke(PfMessageSendAwokeVo pfMessageSendAwokeVo) {
        boolean isok = true;
        PfSmsVo pfSmsVo = new PfSmsVo();
        PfUserVo pfUserVo = new PfUserVo();
        SysSmsServiceImpl smsServiceImpl = (SysSmsServiceImpl)Container.getBean((String)"SysSmsServiceImpl");
        SysUserServiceImpl userService = (SysUserServiceImpl)Container.getBean((String)"SysUserServiceImpl");
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String datestr = df.format(new Date());
            Timestamp orldate = Timestamp.valueOf(datestr);
            pfMessageSendAwokeVo.setMessageAwokeDate((Date)orldate);
            super.getSqlMapClientTemplate().insert("insertsendmsgawoke", (Object)pfMessageSendAwokeVo);
            if (pfMessageSendAwokeVo.getMessageAcceptUser().length() > 0) {
                if (pfMessageSendAwokeVo.getMessageAcceptUser().equals("1")) {
                    List userIdList = this.getAllUserId();
                    for (int i = 0; i < userIdList.size(); ++i) {
                        PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
                        pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
                        pfMessageAcceptAwokeVo.setMessageAcceptStadus(1);
                        pfMessageAcceptAwokeVo.setUserId((String)userIdList.get(i));
                        pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
                        super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", (Object)pfMessageAcceptAwokeVo);
                    }
                } else if (pfMessageSendAwokeVo.getMessageAcceptUser().equals("1,2")) {
                    int i;
                    List userIdList = this.getAllUserId();
                    for (i = 0; i < userIdList.size(); ++i) {
                        PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
                        pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
                        pfMessageAcceptAwokeVo.setMessageAcceptStadus(1);
                        pfMessageAcceptAwokeVo.setUserId((String)userIdList.get(i));
                        pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
                        super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", (Object)pfMessageAcceptAwokeVo);
                    }
                    for (i = 0; i < userIdList.size(); ++i) {
                        pfUserVo = userService.getUserVo((String)userIdList.get(i));
                        if (pfUserVo.getMobilePhone() == null && pfUserVo.getMobilePhone().equals("")) continue;
                        pfSmsVo.setMobileNo(pfUserVo.getMobilePhone().trim());
                        pfSmsVo.setContent(WebFormatter.html2text((String)pfMessageSendAwokeVo.getMessageAwokeContent()));
                        pfSmsVo.setSender(pfMessageSendAwokeVo.getUserName());
                        smsServiceImpl.sendMsg(pfSmsVo);
                    }
                } else {
                    String userIdStr = "";
                    if (pfMessageSendAwokeVo.getMessageAcceptUser().endsWith(",2")) {
                        userIdStr = pfMessageSendAwokeVo.getMessageAcceptUser().substring(0, pfMessageSendAwokeVo.getMessageAcceptUser().length() - 2);
                        StringTokenizer st = new StringTokenizer(userIdStr, ",");
                        while (st.hasMoreTokens()) {
                            String userId = st.nextToken();
                            pfUserVo = userService.getUserVo(userId);
                            if (pfUserVo.getMobilePhone() != null || !pfUserVo.getMobilePhone().equals("")) {
                                pfSmsVo.setMobileNo(pfUserVo.getMobilePhone().trim());
                                pfSmsVo.setContent(WebFormatter.html2text((String)pfMessageSendAwokeVo.getMessageAwokeContent()));
                                pfSmsVo.setSender(pfMessageSendAwokeVo.getUserName());
                                smsServiceImpl.sendMsg(pfSmsVo);
                            }
                            PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
                            pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
                            pfMessageAcceptAwokeVo.setMessageAcceptStadus(1);
                            pfMessageAcceptAwokeVo.setUserId(userId);
                            pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
                            super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", (Object)pfMessageAcceptAwokeVo);
                        }
                    } else {
                        userIdStr = pfMessageSendAwokeVo.getMessageAcceptUser();
                        StringTokenizer st = new StringTokenizer(userIdStr, ",");
                        while (st.hasMoreTokens()) {
                            PfMessageAcceptAwokeVo pfMessageAcceptAwokeVo = new PfMessageAcceptAwokeVo();
                            pfMessageAcceptAwokeVo.setMessageAcceptId(UUIDGenerator.generate());
                            pfMessageAcceptAwokeVo.setMessageAcceptStadus(1);
                            pfMessageAcceptAwokeVo.setUserId(st.nextToken());
                            pfMessageAcceptAwokeVo.setMessageSendAwokeVo(pfMessageSendAwokeVo);
                            super.getSqlMapClientTemplate().insert("insertacceptmsgawoke", (Object)pfMessageAcceptAwokeVo);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isok = false;
        }
        return isok;
    }

    public void delSendMsgById(String messageSendId) {
        super.getSqlMapClientTemplate().delete("delAcceptMsgBySendId", (Object)messageSendId);
        super.getSqlMapClientTemplate().delete("delSendMsg", (Object)messageSendId);
    }

    public void delAcceptMsgById(String messageAcceptId) {
        super.getSqlMapClientTemplate().delete("delAcceptMsg", (Object)messageAcceptId);
    }

    public void delSendAwokeById(String AwokeSendId) {
        super.getSqlMapClientTemplate().delete("delAcceptAwokeBySendId", (Object)AwokeSendId);
        super.getSqlMapClientTemplate().delete("delSendMsg", (Object)AwokeSendId);
    }

    public void delAcceptAwokeById(String AwokeAcceptId) {
        super.getSqlMapClientTemplate().delete("delAcceptAwoke", (Object)AwokeAcceptId);
    }

    public List<String> getAllUserId() {
        return super.getSqlMapClientTemplate().queryForList("getAllUserId");
    }

    public List<PfMessageAcceptVo> getAcceptMsgListRss(Map<String, String> map) {
        return super.getSqlMapClientTemplate().queryForList("queryacceptmsglistRss", map);
    }

    public List<PfMessageAcceptAwokeVo> getAcceptNotifyListRss(Map<String, String> map) {
        return super.getSqlMapClientTemplate().queryForList("queryacceptnotifylistRss", map);
    }

    public List<PfMessageSendAwokeVo> getSendMsgAwokeByTitle(String sendMsgTitle) {
        return (List)super.getSqlMapClientTemplate().queryForObject("getSendMsgAwokeByTitle", (Object)sendMsgTitle);
    }

    public List<String> getUserIdWhereBJJG(String remark) {
        return super.getSqlMapClientTemplate().queryForList("getUserIdWhereBJJG", (Object)remark);
    }

    public List<String> getUserIdByRegionCodeLength(Integer length) {
        return (List)super.getSqlMapClientTemplate().queryForObject("getUserIdByRegionCodeLength", (Object)length);
    }
}

