package com.gtis.web.old;


import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;



/**
 * 工作流事件
 * @author jiff
 *
 */
public interface WorkFlowEvent {
	
	/**
	 * 创建工作流
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @return
	 */
	public boolean doCreateAfter(PfWorkFlowInstanceVo instanceObj);
	
	/**
	 * 工作流转发前
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	
	public String doTurnBefore(PfWorkFlowInstanceVo instanceObj,PfActivityVo wfacvo);
	
	/**
	 * 工作流转发后
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	
	public boolean doTurnAfter(PfWorkFlowInstanceVo instanceObj,PfActivityVo wfacvo);
	
	/**
	 * 工作流退回
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	
	public boolean doTurnBackAfter(PfWorkFlowInstanceVo instanceObj,PfActivityVo wfacvo);
	/**
	 * 工作流挂起前
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	public boolean doTurnPostAfter(PfWorkFlowInstanceVo instanceObj);
	
	
	/**
	 * 工作流办结后
	 * @param request
	 * @param instanceObj 工作流实例对象
	 * @param wfac 活动实例对象
	 * @return
	 */
	public boolean doTurnOverAfter(PfWorkFlowInstanceVo instanceObj, PfActivityVo wfac);
	
	
	/**
	 * 工作流删除后
	 * @param request
	 * @param instanceObj   工作流实例对象
	 * @return
	 */
	public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj);
	
	/**
	 * 工作流取回后
	 * @param instanceObj
	 * @param wfac  取回前节点
	 * @return
	 */
	public boolean doGetBackAfter(PfWorkFlowInstanceVo instanceObj,PfActivityVo wfac);
	
	/**
	 * 工作流终止后
	 * @param instanceObj
	 * @return
	 */
	public boolean doStopAfter(PfWorkFlowInstanceVo instanceObj);
}
