package com.gtis.web.old;

import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.sql.DataSource;

import com.gtis.util.DataSourceManager;

import oracle.sql.CLOB;


public class FormInstanceOperate
{
	private DataSource ds = null;

	public void setDs(DataSource ds)
	{
		this.ds = ds;
	}

	public DataSource getDs()
	{
		return this.ds;
	}

	/**
	 * 表单保存
	 * 
	 * @return
	 */
	public boolean saveFormInstance(FormInstance ifobj,String elementIds)
	{
		Connection con = null;
		ResultSet rs = null;
		PreparedStatement ps = null;
		Statement st = null;
		CLOB clob = null;
		try
		{
			if (ifobj.getTblFieldForm().equals("-1"))
			{
				FormInstance4DataBase formUpdate = new FormInstance4DataBase(ifobj);
				return formUpdate.saveFormToDataBase(ifobj,elementIds);
			}
			else
			{
				con = ds.getConnection();
				st = con.createStatement();
				rs = st.executeQuery("select " + ifobj.getTblkeyField() + " from " + ifobj.getTblName() + " where "
						+ ifobj.getTblkeyField() + "='" + ifobj.getTblkeyValue() + "'");
				if (!rs.next())
				{
					String sql = "insert into " + ifobj.getTblName() + "(" + ifobj.getTblkeyField() + ")";
					sql = sql + "values(?)";
					java.sql.PreparedStatement pstmt = con.prepareStatement(sql);
					pstmt.setString(1, ifobj.getTblkeyValue());
					pstmt.executeUpdate();
					DataSourceManager.attemptClose(pstmt);
				}
				DataSourceManager.attemptClose(rs);

				String sql = "update " + ifobj.getTblName() + " set " + ifobj.getTblFieldForm()
						+ " = XMLType(?) where " + ifobj.getTblkeyField() + "='" + ifobj.getTblkeyValue() + "' ";
				ps = con.prepareStatement(sql);
				clob = this.getCLOB(ifobj.getSaveDocument().asXML(), ps);
				ps.setObject(1, clob);
				ps.executeUpdate();
			}
			return true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return false;
		}
		finally
		{
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(ps);

			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
	}

	private CLOB getCLOB(String xmlData, PreparedStatement st) throws SQLException
	{
		CLOB tempClob = null;
		try
		{

			if (st instanceof org.apache.commons.dbcp.DelegatingPreparedStatement
					&& ((org.apache.commons.dbcp.DelegatingPreparedStatement) st).getDelegate() instanceof oracle.jdbc.OraclePreparedStatement)
			{
				// 如果还没有创建临时 CLOB 对象，则创建新的临时对象
				tempClob = CLOB.createTemporary(((org.apache.commons.dbcp.PoolableConnection) st.getConnection())
						.getDelegate(), true, CLOB.DURATION_SESSION);

				// 以读写方式打开临时 CLOB 对象，以允许写操作
				tempClob.open(CLOB.MODE_READWRITE);
				// 获取输出流，以进行写操作
				Writer tempClobWriter = tempClob.getCharacterOutputStream();
				// 将数据写入临时 CLOB 对象
				tempClobWriter.write(xmlData);

				// 刷新并关闭流
				tempClobWriter.flush();
				tempClobWriter.close();

				// 关闭临时 CLOB 对象
				tempClob.close();
			}

		}
		catch (Exception exp)
		{
			tempClob.freeTemporary();
			exp.printStackTrace();
		}
		return tempClob;
	}

	private CLOB getCLOB(String xmlData, Connection conn) throws SQLException
	{
		CLOB tempClob = null;
		try
		{

			// 如果还没有创建临时 CLOB 对象，则创建新的临时对象
			tempClob = CLOB.createTemporary(conn, true, CLOB.DURATION_SESSION);

			// 以读写方式打开临时 CLOB 对象，以允许写操作
			tempClob.open(CLOB.MODE_READWRITE);
			// 获取输出流，以进行写操作
			Writer tempClobWriter = tempClob.getCharacterOutputStream();
			// 将数据写入临时 CLOB 对象
			tempClobWriter.write(xmlData);

			// 刷新并关闭流
			tempClobWriter.flush();
			tempClobWriter.close();

			// 关闭临时 CLOB 对象
			tempClob.close();
		}
		catch (Exception exp)
		{
			tempClob.freeTemporary();
			exp.printStackTrace();
		}
		return tempClob;
	}
}
