package com.gtis.web.old;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class FormInstance {

	private String tblName = "";

	private String tblkeyField = "";

	private String tblkeyValue = "";

	private String tblFieldForm = "";

	private FormDefintion formDefineObj;

	private Document Doc = null; // 数据库中的xml
	private String dsName="";  //数据源名称
	private boolean isSave=false;
	public boolean isSave() {
		return isSave;
	}

	public void setSave(boolean isSave) {
		this.isSave = isSave;
	}

	public String getDsName() {
		return dsName;
	}

	public void setDsName(String dsName) {
		this.dsName = dsName;
	}

	public FormInstance(FormDefintion formDefineObj, String tblName, String tblkeyField, String tblkeyValue,
			String tblFieldForm) {
		this.formDefineObj = formDefineObj;
		this.tblName = tblName;
		this.tblkeyField = tblkeyField;
		this.tblkeyValue = tblkeyValue;
		this.tblFieldForm = tblFieldForm;
	}
	
	
	
	public void setDocument(Document doc) {
		if (doc == null) {
			this.Doc = formDefineObj.getBlackXML();
		} else {
			//isSave=true;
			this.Doc = doc;
		}
	}

	/**
	 * 将定义和实例的xml合并，用来显示页面
	 * 
	 * @return
	 */
	public Document getViewDocuement() {
		Document dDoc = formDefineObj.getXMLDocument();
		Element root = dDoc.getRootElement();
		List lstData = Doc.selectNodes("//ElementData");
		Element dataset = (Element) root.selectSingleNode("/DataSet");
		Element dData = (Element) root.selectSingleNode("/DataSet/Data");
		if (dData != null)
			dData.getParent().remove(dData);

		dData = dataset.addElement("Data");
		for (int i = 0; i < lstData.size(); i++) {
			Element iData = (Element) lstData.get(i);
			dData.add((Element) iData.clone());
		}
		// 加入子表
		lstData = Doc.selectNodes("//GroupData");
		for (int i = 0; i < lstData.size(); i++) {
			Element iData = (Element) lstData.get(i);
			dData.add((Element) iData.clone());
		}
		return dDoc;
	}

	public Document getSaveDocument() {
		return Doc;
	}
	
	public void setFieldValue(String fieldName, String fieldValue) {
		Node tmp = Doc.selectSingleNode("//ElementData[@Id='" + fieldName + "']");
		if (tmp != null)
			tmp.setText(fieldValue);
	}
	
	private List getElementList(String ElementIds){
		List lstElement=new ArrayList<String>();
		if (!ElementIds.equalsIgnoreCase("") && !ElementIds.equalsIgnoreCase("all_disabled")){
			String[] str=ElementIds.split(",");
			for (int i = 0; i < str.length; i++) {
				if (!str[i].trim().equals("")) lstElement.add(str[i].trim());
			}
		}
		return lstElement;
	}
	
	private boolean inElementList(List lstElement,String eleId){
		for (int i = 0; i < lstElement.size(); i++) {
			if (lstElement.get(i).toString().equalsIgnoreCase(eleId))
				return true;
		}
		return false;
	}
	/**
	 * 保存表单逻辑
	 * 
	 * @param iDoc
	 * @param request
	 */
	public void processRequest(HttpServletRequest request,String ElementIds) {
		try {
			List lstElement=getElementList(ElementIds);
			Document dDoc = formDefineObj.getXMLDocument();
			//List lstElementDefines = dDoc.selectNodes("/DataSet/Define/ElementDefine");
			Node dataElement = Doc.selectSingleNode("/DataSet");
			for (int i = 0; i < lstElement.size(); i++) {
				Node elementDefine =dDoc.selectSingleNode("/DataSet/Define/ElementDefine[@Id='"+lstElement.get(i)+"']");
				if (elementDefine==null) continue;
				String elementId = elementDefine.valueOf("@Id");
				String elementType = elementDefine.valueOf("@Type");
				String elementDataType = elementDefine.valueOf("@DataType");
				if (request.getParameter(elementId) != null) {
					String value = request.getParameter(elementId);
					Element elementData = (Element) dataElement
							.selectSingleNode("ElementData[@Id='" + elementId + "']");
					if (elementData == null) {
						elementData = ((Element) dataElement).addElement("ElementData");
					}
					setElementData(dDoc, elementData, elementId, value, elementType);
				}
			}
			//处理子表
			List lstElementDefines = dDoc.selectNodes("/DataSet/Define/GroupDefine");
			for (int i = 0; i < lstElementDefines.size(); i++) {
				Element elementGroup = (Element) lstElementDefines.get(i);
				String groupId = elementGroup.valueOf("@Id");
				if (!inElementList(lstElement,groupId)) continue;
				FormChild childs = new FormChild();
				for (Iterator j = elementGroup.elementIterator(); j.hasNext();) {
					Element elementDefine = (Element) j.next();
					String elementId = elementDefine.valueOf("@Id");
					childs.addFieldValues(request, elementId);
				}
				childs.addFieldValues(request, groupId + "_id");
				if (childs.getSize() > 0) {
					Node groupDataElement = Doc.selectSingleNode("//GroupData[@Id='" + groupId + "']");
					if (groupDataElement != null) {
						((Element) groupDataElement).getParent().remove(groupDataElement);
					}
					groupDataElement = ((Element) dataElement).addElement("GroupData");
					((Element) groupDataElement).addAttribute("Id", groupId);
					for (int k = 1; k < childs.getSize(); k++) {
						Node LineDataElement = ((Element) groupDataElement).addElement("LineData");
						((Element) LineDataElement).addAttribute("Index", String.valueOf(k));
						//if (childs.getFieldValue(groupId + "_id", k).equals("-1"))
							//((Element) LineDataElement).addAttribute("Id", UUIDGenerator.generate());
						//else
							((Element) LineDataElement).addAttribute("Id", childs.getFieldValue(groupId + "_id", k));
						for (Iterator j = elementGroup.elementIterator(); j.hasNext();) {
							Element elementDefine = (Element) j.next();
							String elementId = elementDefine.valueOf("@Id");
							String elementType = elementDefine.valueOf("@Type");
							String elementDataType = elementDefine.valueOf("@DataType");
							Node elementData = ((Element) LineDataElement).addElement("ElementData");
							setElementData(dDoc, (Element) elementData, elementId, childs.getFieldValue(elementId, k),
									elementType);
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void setElementData(Document dDoc, Element ElementData, String elementId, String value, String elementType) {
		String eleValue = "";
		ElementData.addAttribute("Id", elementId);
		if (value.equals(""))
			eleValue = " ";
		else
			eleValue = value;
		if (elementType.toLowerCase().equals("textarea")) {
			ElementData.clearContent();
			ElementData.addCDATA(eleValue);
		} else if (elementType.toLowerCase().equals("select")) {
			Node elementSelect = dDoc.selectSingleNode("//SelectConfig[@Id='" + elementId + "']/SelectElement[@Text='"
					+ value + "']");
			if (elementSelect != null) {
				eleValue = elementSelect.valueOf("@Value");
			}
			ElementData.setText(eleValue);
		} else {
			ElementData.setText(eleValue);
		}
	}

	public FormDefintion getFormDefineObj() {
		return formDefineObj;
	}

	public void setFormDefineObj(FormDefintion formDefineObj) {
		this.formDefineObj = formDefineObj;
	}

	public String getTblFieldForm() {
		return tblFieldForm;
	}

	public void setTblFieldForm(String tblFieldForm) {
		this.tblFieldForm = tblFieldForm;
	}

	public String getTblkeyField() {
		return tblkeyField;
	}

	public void setTblkeyField(String tblkeyField) {
		this.tblkeyField = tblkeyField;
	}

	public String getTblkeyValue() {
		return tblkeyValue;
	}

	public void setTblkeyValue(String tblkeyValue) {
		this.tblkeyValue = tblkeyValue;
	}

	public String getTblName() {
		return tblName;
	}

	public void setTblName(String tblName) {
		this.tblName = tblName;
	}
	

}
