package com.gtis.web.action.dzjc;

import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.dao.SysDzjcDAO;
import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.impl.SysActivityServiceImpl;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.spring.Container;
import com.opensymphony.xwork2.Action;

import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: jibo
 * Date: 12-7-12
 * Time: 上午10:55
 * 电子监察用的几个列表
 */

public class DzjcProjectListAction extends AbstractPageAction{

    List<Map> result;
    SysDzjcDAO sysDzjcDAO;
    /** 工作流定义服务 */
    private SysWorkFlowDefineService workFlowDefineService;
    SysActivityServiceImpl sysActivityServiceImpl;

    String proType;
    String proName;
    boolean isover;
    boolean is2day;
    boolean isOffSite;//异地办理
    boolean isAbnormal;//是否异常
    Date beginDate;
    Date endDate;
    /** 工作流定义列表 */
    private List<PfWorkFlowDefineVo> lstWorkFlowDefine;

    public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
        return lstWorkFlowDefine;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }



    public void setSysDzjcDAO(SysDzjcDAO sysDzjcDAO) {
        this.sysDzjcDAO = sysDzjcDAO;
    }

    public List<Map> getResult() {
        return result;
    }

    public String getProType() {
        return proType;
    }

    public void setProType(String proType) {
        this.proType = proType;
    }

    public String getProName() {
        return proName;
    }

    public void setProName(String proName) {
        this.proName = proName;
    }

    public boolean isIsover() {
        return isover;
    }

    public void setIsover(boolean isover) {
        this.isover = isover;
    }

    public boolean isIs2day() {
        return is2day;
    }

    public void setIs2day(boolean is2day) {
        this.is2day = is2day;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isIsOffSite() {
        return isOffSite;
    }

    public void setIsOffSite(boolean isOffSite) {
        this.isOffSite = isOffSite;
    }

    /**
     * 正在办理项目的监察列表
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        InitCombox();
        Map<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("proType",proType);
        mapParam.put("proName",proName);
        mapParam.put("beginDate",beginDate);
        mapParam.put("endDate",endDate);
        mapParam.put("isStart","1");
        mapParam.put("currentTime", Calendar.getInstance().getTime());
        if (this.isIsover())
            mapParam.put("isover",0);
        else if (this.isIs2day())
            mapParam.put("isday",2);
        if(isIsOffSite())
            mapParam.put("isOffSite",1);
        if(isIsAbnormal())
            mapParam.put("isAbnormal",1);


        int count=  sysDzjcDAO.QueryDZJCProjectListCount(mapParam);
        this.setCount(count);
        this.CalPageInfo();
        this.result= sysDzjcDAO.QueryDZJCProjectList(mapParam,this.startNum,this.endNum);
        return Action.SUCCESS;
    }

    /**
     * 已经办结的项目的监察列表
     * @return
     * @throws Exception
     */
    public String over() throws  Exception{
        InitCombox();
        Map<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("proType",proType);
        mapParam.put("proName",proName);
        mapParam.put("beginDate",beginDate);
        mapParam.put("endDate",endDate);
        mapParam.put("isEnd","1");
        mapParam.put("currentTime", Calendar.getInstance().getTime());
        if (this.isIsover())
            mapParam.put("isover",0);
        else if (this.isIs2day())
            mapParam.put("isday",2);

        if(isIsOffSite())
            mapParam.put("isOffSite",1);
        if(isIsAbnormal())
            mapParam.put("isAbnormal",1);

        int count=  sysDzjcDAO.QueryDZJCProjectListCount(mapParam);
        this.setCount(count);
        this.CalPageInfo();
        this.result= sysDzjcDAO.QueryDZJCProjectList(mapParam,this.startNum,this.endNum);
        return "over";
    }

    private void InitCombox(){
        lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineList();
        PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
//        vo.setWorkflowName("----所有业务----");
//        vo.setWorkflowDefinitionId("");
//        lstWorkFlowDefine.add(0, vo);
    }

    public String projectOverview(){
        Map<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("isStart","1");
        int currentProjectCount=  sysDzjcDAO.QueryDZJCProjectListCount(mapParam);
        mapParam.clear();
        mapParam.put("isEnd","1");
        int completedProjectCount=  sysDzjcDAO.QueryDZJCProjectListCount(mapParam);
        mapParam.clear();
        mapParam.put("isOffSite","1");
        int offSiteProjectCount=  sysDzjcDAO.QueryDZJCProjectListCount(mapParam);
        int siteProjectCount = (completedProjectCount+currentProjectCount)-offSiteProjectCount;
        mapParam.clear();
        mapParam.put("isover","0");
        int overProjectCount=  sysDzjcDAO.QueryDZJCProjectListCount(mapParam);
        int normalProjectCount = (completedProjectCount+currentProjectCount)-overProjectCount;

        SysWorkFlowDefineDao workFlowDefineDao = (SysWorkFlowDefineDao) Container.getBean("SysWorkFlowDefineDao");
        Object categoryCountObj = workFlowDefineDao.getWorkFlowDefineCountByRole(null,null,null);
        int categoryCount=0;
        if(categoryCountObj!=null)
            categoryCount=Integer.parseInt(String.valueOf(categoryCountObj));
        Map overviewMap = new HashMap();
        overviewMap.put("project",currentProjectCount);
        overviewMap.put("completeProject",completedProjectCount);
        overviewMap.put("offSiteProject",offSiteProjectCount);
        overviewMap.put("siteProject",siteProjectCount);
        overviewMap.put("overProject",overProjectCount);
        overviewMap.put("normalProject",normalProjectCount);
        overviewMap.put("categoryProject",categoryCount);
        Struts2Utils.renderJson(overviewMap);

        return Action.NONE;

    }


    public String activityOvertime(){
        InitCombox();
        Map<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("proType",proType);
        mapParam.put("proName",proName);
        mapParam.put("beginDate",beginDate);
        mapParam.put("endDate",endDate);

        int count=  sysDzjcDAO.QueryActivityOvertimeListCount(mapParam);
        this.setCount(count);
        this.CalPageInfo();
        this.result= sysDzjcDAO.QueryPagedActivityOvertimeList(mapParam, this.startNum, this.endNum);
        return "activityOvertime";
    }


    public String activityBack(){
        InitCombox();
        Map<String,Object> mapParam=new HashMap<String, Object>();
        mapParam.put("proType",proType);
        mapParam.put("proName",proName);
        mapParam.put("beginDate",beginDate);
        mapParam.put("endDate",endDate);

        int count=  sysDzjcDAO.QueryActivityBackListCount(mapParam);
        this.setCount(count);
        this.CalPageInfo();
        this.result= sysDzjcDAO.QueryActivityBackList(mapParam, this.startNum, this.endNum);
        return "activityBack";
    }


    public boolean isIsAbnormal() {
        return isAbnormal;
    }

    public void setIsAbnormal(boolean isAbnormal) {
        this.isAbnormal = isAbnormal;
    }
}
