package com.gtis.web.action.config;

import java.io.PrintWriter;
import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONUtil;

import com.gtis.plat.vo.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.datasource.*;
import com.gtis.plat.service.*;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.*;

/**
 * 工作流必填字段控制
 * @文件名 WordflowRequireFieldAction.java
 * @作者 卢向伟
 * @创建日期 2013-5-3
 * @创建时间 上午9:00:46 
 * @版本号 V 1.0
 */
public class WorkflowRequireFieldAction implements ServletRequestAware, ServletResponseAware{
    private static final Log log = LogFactory.getLog(WorkflowRequireFieldAction.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String userid;
    private String taskid;
    private String proid;
    private String reqid;//
    private String businessid;
    private String wdid;
    private SplitParam splitParam;
    private String message;
    private String result;
    private RequireFieldVo fieldVo;
    private RequireFieldService requireFieldService;
    private SysTaskService sysTaskService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private SysWorkFlowDefineService workFlowDefineService;
    private WorkFlowCoreService workFlowService;
    private SysSignService signService;
    private List<HashMap> businessMapList;
    private List<HashMap> workflowDefineMapList;
    private List<RequireTableKeyVo> tableList;
    private List<HashMap> activityMapList;

    /**
     * 工作流事件检查必填字段
     * @return
     * @throws Exception
     */
    public String checkWorkflowRequireField()throws Exception{
        message="";
        result="";
        boolean isok = false;
        String msg = "";//提示信息
        try {
            if (StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(taskid)) {
                String businessId = "";
                String activityid = "";
                userid = SessionUtil.getCurrentUserId();
                //获取工作流相关信息，包括工作流定义ID和当前活动节点定义ID
                WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userid, taskid);
                PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
                if (info != null) {
                    businessId = info.getWorkFlowDefineVo().getBusinessId();
                    activityid = info.getSourceActivity().getActivityDefinitionId();
                }
                if (StringUtils.isNotBlank(activityid) && pfWorkFlowInstanceVo != null) {
                    PfBusinessVo businessVo = workFlowDefineService.getBusiness(businessId);
                    HashMap param = new HashMap();
                    param.put("WD_ID", pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                    param.put("AD_ID", activityid);
                    //根据工作流定义ID和当前活动节点定义ID获取配置表“PF_REQUIRE_FIELD”中对应的配置项
                    List<RequireFieldVo> fieldList = requireFieldService.getObjectList(param);
                    if (fieldList != null && fieldList.size() > 0) {
                        //只有在数据库查询出有配置记录的时候，才对提示信息初始化
//			        	message = "请填写或保存：";
                        String tablename = "";
                        //针对普通字段
                        String sql_field = "";
                        String sql_field_alias = "";
                        HashMap fieldMap = new HashMap();
                        List<HashMap<String, String>> fieldMapList = new ArrayList<HashMap<String,String>>();

                        //针对签名
                        String sign_keys = "";
                        String sign_keys_alias  = "";
                        HashMap signMap = new HashMap();
                        List<HashMap<String, String>> signMapList = new ArrayList<HashMap<String,String>>();
                        //针对签名意见
                        String sign_option_keys = "";
                        String sign_option_alias  = "";
                        HashMap signOptionMap = new HashMap();
                        List<HashMap<String, String>> signOptionMapList = new ArrayList<HashMap<String,String>>();
                        //按照字段“TABLE_NAME”数据库表进行分组，组织所需要判断的字段和对应的别名
                        for (int i = 0; i < fieldList.size(); i++) {
                            RequireFieldVo vo = fieldList.get(i);
                            if (!tablename.equals(vo.getTableName())) {
                                if (StringUtils.isNotBlank(tablename)) {
                                    //针对签名
                                    if (StringUtils.isNotBlank(sign_keys)) {
                                        sign_keys = sign_keys.replace("，", ",");
                                        sign_keys_alias = sign_keys_alias.replace("；", ";");
                                        if (sign_keys.endsWith(",")) {
                                            sign_keys = sign_keys.substring(0,sign_keys.length()-1);
                                        }
                                        if (sign_keys_alias.endsWith(";")) {
                                            sign_keys_alias = sign_keys_alias.substring(0,sign_keys_alias.length()-1);
                                        }
                                        signMap.put("TABLE_NAME", tablename);
                                        signMap.put("SIGN_KEYS", sign_keys);
                                        signMap.put("SIGN_KEYS_ALIAS", sign_keys_alias);
                                        signMapList.add(signMap);
                                    }
                                    //针对签名意见
                                    if (StringUtils.isNotBlank(sign_option_keys)) {
                                        sign_option_keys = sign_option_keys.replace("，", ",");
                                        sign_option_alias = sign_option_alias.replace("；", ";");
                                        if (sign_option_keys.endsWith(",")) {
                                            sign_option_keys = sign_option_keys.substring(0,sign_option_keys.length()-1);
                                        }
                                        if (sign_option_alias.endsWith(";")) {
                                            sign_option_alias = sign_option_alias.substring(0,sign_option_alias.length()-1);
                                        }
                                        signOptionMap.put("TABLE_NAME", tablename);
                                        signOptionMap.put("SIGN_OPTION_KEYS", sign_option_keys);
                                        signOptionMap.put("SIGN_OPTION_ALIAS", sign_option_alias);
                                        signOptionMapList.add(signOptionMap);
                                    }
                                    //针对普通字段
                                    if (StringUtils.isNotBlank(sql_field)) {
                                        sql_field = sql_field.replace("，", ",");
                                        sql_field_alias = sql_field_alias.replace("；", ";");
                                        if (sql_field.endsWith(",")) {
                                            sql_field = sql_field.substring(0,sql_field.length()-1);
                                        }
                                        if (sql_field_alias.endsWith(";")) {
                                            sql_field_alias = sql_field_alias.substring(0,sql_field_alias.length()-1);
                                        }
                                        fieldMap.put("TABLE_NAME", tablename);
                                        fieldMap.put("FIELDS", sql_field);
                                        fieldMap.put("FIELD_ALIAS", sql_field_alias);
                                        fieldMapList.add(fieldMap);
                                    }
                                }
                                fieldMap = new HashMap();
                                sql_field = "";
                                sql_field_alias = "";
                                signMap = new HashMap();
                                sign_keys = "";
                                sign_keys_alias = "";
                                sign_option_keys = "";
                                sign_option_alias  = "";
                            }
                            tablename = vo.getTableName();
                            if (StringUtils.isNotBlank(vo.getFieldName())) {
                                sql_field += vo.getFieldName()+",";
                                sql_field_alias += vo.getFieldAlias() + ";";
                            }
                            if (StringUtils.isNotBlank(vo.getSignKey())) {
                                sign_keys += vo.getSignKey()+",";
                                sign_keys_alias += vo.getSignKeyAlias() + ";";
                            }
                            if (StringUtils.isNotBlank(vo.getSignOptionKey())) {
                                sign_option_keys += vo.getSignOptionKey()+",";
                                sign_option_alias += vo.getSignOptionAlias() + ";";
                            }
                        }
                        //针对签名中英文符号进行处理
                        if (StringUtils.isNotBlank(sign_keys)) {
                            sign_keys = sign_keys.replace("，", ",");
                            sign_keys_alias = sign_keys_alias.replace("；", ";");
                            if (sign_keys.endsWith(",")) {
                                sign_keys = sign_keys.substring(0,sign_keys.length()-1);
                            }
                            if (sign_keys_alias.endsWith(";")) {
                                sign_keys_alias = sign_keys_alias.substring(0,sign_keys_alias.length()-1);
                            }
                            signMap = new HashMap();
                            signMap.put("TABLE_NAME", tablename);
                            signMap.put("SIGN_KEYS", sign_keys);
                            signMap.put("SIGN_KEYS_ALIAS", sign_keys_alias);
                            signMapList.add(signMap);
                        }
                        //针对签名意见中英文符号进行处理
                        if (StringUtils.isNotBlank(sign_option_keys)) {
                            sign_option_keys = sign_option_keys.replace("，", ",");
                            sign_option_alias = sign_option_alias.replace("；", ";");
                            if (sign_option_keys.endsWith(",")) {
                                sign_option_keys = sign_option_keys.substring(0,sign_option_keys.length()-1);
                            }
                            if (sign_option_alias.endsWith(";")) {
                                sign_option_alias = sign_option_alias.substring(0,sign_option_alias.length()-1);
                            }
                            signOptionMap = new HashMap();
                            signOptionMap.put("TABLE_NAME", tablename);
                            signOptionMap.put("SIGN_OPTION_KEYS", sign_option_keys);
                            signOptionMap.put("SIGN_OPTION_ALIAS", sign_option_alias);
                            signOptionMapList.add(signOptionMap);
                        }
                        //开始针对组织好的每张表的签名，根据主键、signkey获取签名对象
                        //判断对应的签名对象是否为空、null
                        log.info(JSONUtil.serialize(signMapList));
                        if (signMapList != null && signMapList.size() > 0) {
                            msg += doSignMsg(businessVo,proid,signMapList);
                        }
                        //开始针对组织好的每张表的签名意见，根据主键、signkey获取签名对象
                        //判断对应的签名对象是否为空、null
                        log.info(JSONUtil.serialize(signMapList));
                        if (signOptionMapList != null && signOptionMapList.size() > 0) {
                            msg += doSignOptionMsg(businessVo,proid,signOptionMapList);
                        }
                        //针对普通字段中英文符号进行处理
                        if (StringUtils.isNotBlank(sql_field)) {
                            sql_field = sql_field.replace("，", ",");
                            sql_field_alias = sql_field_alias.replace("；", ";");
                            if (sql_field.endsWith(",")) {
                                sql_field = sql_field.substring(0,sql_field.length()-1);
                            }
                            if (sql_field_alias.endsWith(";")) {
                                sql_field_alias = sql_field_alias.substring(0,sql_field_alias.length()-1);
                            }
                            fieldMap = new HashMap();
                            fieldMap.put("TABLE_NAME", tablename);
                            fieldMap.put("FIELDS", sql_field);
                            fieldMap.put("FIELD_ALIAS", sql_field_alias);
                            fieldMapList.add(fieldMap);
                        }
                        //开始针对组织好的每张表进行查询，根据表名、主键、返回字段获取map对象
                        //判断对应的map对象中字段是否为空、null
                        log.info(JSONUtil.serialize(fieldMapList));
//						msg += doFieldMsg(proid, fieldMapList);//
                        if (fieldList != null && fieldList.size() > 0) {
                            msg += doFieldMsg(businessVo,proid, fieldMapList);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
            msg = "";
        }
        if (StringUtils.isNotBlank(msg)) {
            message = "请填写或保存："+msg;
            result = "false";
        }else {
            result = "true";
            message = "";
        }
//		if (isok) {
//			result = "true";
//			message = "";
//		}else {
//			result = "false";
//		}
        return returnAjaxResponse(response,null, message, result);
    }
    /**
     * 处理数据库表对应页面的对应签名空间必填控制
     * @param proID
     * @param signMapList
     * @return
     */
    private String doSignMsg(PfBusinessVo businessVo,String proID,List<HashMap<String, String>> signMapList){
        String msg = "";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (signMapList != null && signMapList.size() > 0 && businessVo != null) {
                DataSource ds = BusinessDataSource.getDataSourceByBusiness(businessVo);
                con = ds.getConnection();

                //开始针对组织好的每张表的签名，根据主键、signkey获取签名对象
                //判断对应的签名对象是否为空、null
                for (int i = 0; i < signMapList.size(); i++) {
                    String tablemsg = "";
                    HashMap<String, String> fMap = signMapList.get(i);
                    HashMap objParam = new HashMap();
                    objParam.put("TABLE_NAME", fMap.get("TABLE_NAME"));
                    //根据表名，获取该表“PF_REQUIRE_TABLEKEY”配置的和proid对应的字段名称
                    RequireTableKeyVo tVo = requireFieldService.getObjectByIbatisStr(objParam, "get_PF_REQUIRE_TABLEKEY");
                    if (tVo != null) {
                        try {
                            String sql = "select "+tVo.getTablePkId() + " as TABLE_PK_ID"+",rownum"+" from "+fMap.get("TABLE_NAME")+" t where "+tVo.getFieldName()+" = '"+proID+"'";
                            log.info(sql);
                            ps = con.prepareStatement(sql);
                            rs = ps.executeQuery();
//    						ResultSetMetaData rsmd = rs.getMetaData();
                            if (rs.next()){
                                String signProid = rs.getString("TABLE_PK_ID");
                                if (StringUtils.isNotBlank(signProid)) {
                                    if (StringUtils.isNotBlank(fMap.get("SIGN_KEYS"))) {
                                        List<PfSignVo> signList = signService.getSignList(null, signProid);
                                        if (signList != null && signList.size() > 0) {
                                            String[] signArray = fMap.get("SIGN_KEYS").split(",");
                                            String[] signAliasArray = fMap.get("SIGN_KEYS_ALIAS").split(";");
                                            for (int j = 0; j < signArray.length; j++) {
                                                String key = signArray[j];
                                                boolean hassign = false;
                                                if (signList != null && signList.size() > 0) {
                                                    for (int k = 0; k < signList.size(); k++) {
                                                        PfSignVo sVo = signList.get(k);
                                                        if (sVo != null && sVo.getSignKey().equals(key)) {
                                                            hassign = true;
                                                            break;
                                                        }
                                                    }
                                                    if (!hassign) {
                                                        tablemsg += signAliasArray[j]+";";
                                                    }
                                                }
                                            }
                                        }else {
                                            tablemsg += fMap.get("SIGN_KEYS_ALIAS");
                                        }
                                    }
                                }
                            }else {
                                tablemsg += fMap.get("SIGN_KEYS_ALIAS");
                            }
                        } catch (Exception e) {
                            log.error(e.getMessage());
                        }
                        if (StringUtils.isNotBlank(tablemsg)) {
                            if (tablemsg.endsWith(";")) {
                                tablemsg = tablemsg.substring(0,tablemsg.length()-1);
                            }
                            tablemsg = "\\n【"+tVo.getTableAlias()+"】：{" + tablemsg + "}";
                        }
                    }else {
                        log.error("请检查是否配置该字典表："+fMap.get("TABLE_NAME"));
                    }
                    msg += tablemsg;
                }
            }
        }catch (Exception e) {
            log.error(e.getMessage());
        }finally {
            DataSourceManager.attemptClose(ps);
            DataSourceManager.attemptClose(con);
        }

        if (StringUtils.isNotBlank(msg)) {
            msg = "\\n******签名提示******" + msg;
        }
        return msg;
    }
    /**
     * 处理数据库表对应页面的对应签名意见空间必填控制
     * @param proID
     * @param signMapList
     * @return
     */
    private String doSignOptionMsg(PfBusinessVo businessVo,String proID,List<HashMap<String, String>> signMapList){
        String msg = "";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (signMapList != null && signMapList.size() > 0 && businessVo != null) {
                DataSource ds = BusinessDataSource.getDataSourceByBusiness(businessVo);
                con = ds.getConnection();

                //开始针对组织好的每张表的签名意见，根据主键、signkey获取签名对象
                //判断对应的签名对象是否为空、null
                for (int i = 0; i < signMapList.size(); i++) {
                    String tablemsg = "";
                    HashMap<String, String> fMap = signMapList.get(i);
                    HashMap objParam = new HashMap();
                    objParam.put("TABLE_NAME", fMap.get("TABLE_NAME"));
                    //根据表名，获取该表“PF_REQUIRE_TABLEKEY”配置的和proid对应的字段名称
                    RequireTableKeyVo tVo = requireFieldService.getObjectByIbatisStr(objParam, "get_PF_REQUIRE_TABLEKEY");
                    if (tVo != null) {
                        try {
                            String sql = "select "+tVo.getTablePkId() + " as TABLE_PK_ID"+",rownum"+" from "+fMap.get("TABLE_NAME")+" t where "+tVo.getFieldName()+" = '"+proID+"'";
                            log.info(sql);
                            ps = con.prepareStatement(sql);
                            rs = ps.executeQuery();
//    						ResultSetMetaData rsmd = rs.getMetaData();
                            if (rs.next()){
                                String signProid = rs.getString("TABLE_PK_ID");
                                if (StringUtils.isNotBlank(signProid)) {
                                    if (StringUtils.isNotBlank(fMap.get("SIGN_OPTION_KEYS"))) {
                                        List<PfSignVo> signList = signService.getSignList(null, signProid);
                                        if (signList != null && signList.size() > 0) {
                                            String[] signArray = fMap.get("SIGN_OPTION_KEYS").split(",");
                                            String[] signAliasArray = fMap.get("SIGN_OPTION_ALIAS").split(";");
                                            for (int j = 0; j < signArray.length; j++) {
                                                String key = signArray[j];
                                                boolean hassignOption = false;
                                                if (signList != null && signList.size() > 0) {
                                                    for (int k = 0; k < signList.size(); k++) {
                                                        PfSignVo sVo = signList.get(k);
                                                        if (sVo != null && sVo.getSignKey().equals(key) && StringUtils.isNotBlank(sVo.getSignOpinion())) {
                                                            hassignOption = true;
                                                            break;
                                                        }
                                                    }
                                                    if (!hassignOption) {
                                                        tablemsg += signAliasArray[j]+";";
                                                    }
                                                }
                                            }
                                        }else {
                                            tablemsg += fMap.get("SIGN_OPTION_ALIAS");
                                        }
                                    }
                                }
                            }else {
                                tablemsg += fMap.get("SIGN_OPTION_ALIAS");
                            }
                        } catch (Exception e) {
                            log.error(e.getMessage());
                        }
                        if (StringUtils.isNotBlank(tablemsg)) {
                            if (tablemsg.endsWith(";")) {
                                tablemsg = tablemsg.substring(0,tablemsg.length()-1);
                            }
                            tablemsg = "\\n【"+tVo.getTableAlias()+"】：{" + tablemsg + "}";
                        }
                    }else {
                        log.error("请检查是否配置该字典表："+fMap.get("TABLE_NAME"));
                    }
                    msg += tablemsg;
                }
            }
        }catch (Exception e) {
            log.error(e.getMessage());
        }finally {
            DataSourceManager.attemptClose(ps);
            DataSourceManager.attemptClose(con);
        }

        if (StringUtils.isNotBlank(msg)) {
            msg = "\\n******签名意见提示******" + msg;
        }
        return msg;
    }
    /**
     * 处理数据库表必填字段
     * @param proID
     * @param fieldMapList
     * @return
     */
    private String doFieldMsg(PfBusinessVo businessVo,String proID,List<HashMap<String, String>> fieldMapList){
        String msg = "";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (fieldMapList != null && fieldMapList.size() > 0 && businessVo != null) {
                DataSource ds = BusinessDataSource.getDataSourceByBusiness(businessVo);
                con = ds.getConnection();
                //开始针对组织好的每张表进行查询，根据表名、主键、返回字段获取map对象
                //判断对应的map对象中字段是否为空、null
                for (int i = 0; i < fieldMapList.size(); i++) {
                    String sql = "";//"select $FIELDS$ from $TABLE_NAME$ t where $FIELD_NAME$ = #PROID#";
                    String tablemsg = "";
                    HashMap<String, String> fMap = fieldMapList.get(i);
                    HashMap objParam = new HashMap();
                    objParam.put("TABLE_NAME", fMap.get("TABLE_NAME"));
                    objParam.put("FIELDS", fMap.get("FIELDS")+",rownum");
                    //根据表名，获取该表“PF_REQUIRE_TABLEKEY”配置的和proid对应的字段名称
                    RequireTableKeyVo tVo = requireFieldService.getObjectByIbatisStr(objParam, "get_PF_REQUIRE_TABLEKEY");
                    if (tVo != null) {
//    					objParam.put("PROID", proID);
//    					objParam.put("FIELD_NAME", tVo.getFieldName());
                        try {
                            String[] fieldArray = fMap.get("FIELDS").split(",");
                            String[] fieldAliasArray = fMap.get("FIELD_ALIAS").split(";");
                            sql = "select "+fMap.get("FIELDS")+",rownum"+" from "+fMap.get("TABLE_NAME")+" t where "+tVo.getFieldName()+" = '"+proID+"'";
                            log.info(sql);
                            ps = con.prepareStatement(sql);
                            rs = ps.executeQuery();
//    						ResultSetMetaData rsmd = rs.getMetaData();
                            if (rs.next()){
                                for (int j = 0; j < fieldArray.length; j++) {
                                    String value = rs.getString(fieldArray[j]);
                                    if (StringUtils.isBlank(value)) {
                                        tablemsg += fieldAliasArray[j]+";";
                                    }
                                }
                            }else {
                                tablemsg += fMap.get("FIELD_ALIAS");
                            }
                        } catch (Exception e) {
                            log.error(e.getMessage());
                        }
                        if (StringUtils.isNotBlank(tablemsg)) {
                            if (tablemsg.endsWith(";")) {
                                tablemsg = tablemsg.substring(0,tablemsg.length()-1);
                            }
                            tablemsg = "\\n【"+tVo.getTableAlias()+"】：{" + tablemsg + "}";
                        }
                    }else {
                        log.error("请检查是否配置该字典表："+fMap.get("TABLE_NAME"));
                    }
                    msg += tablemsg;
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }finally {
            DataSourceManager.attemptClose(ps);
            DataSourceManager.attemptClose(con);
        }

        if (StringUtils.isNotBlank(msg)) {
            msg = "\\n******字段提示******" + msg;
        }
        return msg;
    }

    /**
     * 打开必填字段配置列表
     * @return
     */
    public String openConfigList(){
        splitParam = new SplitParamImpl();
        HashMap param = new HashMap();
        splitParam.setQueryParam(param);
        splitParam.setQueryString("get_PF_REQUIRE_FIELD");
        return "list";
    }
    public String openRecord(){
        if (StringUtils.isNotBlank(reqid)) {
            fieldVo = requireFieldService.getObject(reqid);
        }
        if (fieldVo == null) {
            fieldVo = new RequireFieldVo();
            fieldVo.setReqid(UUIDGenerator.generate18());
        }
        initSelectList();
        return "input";
    }
    /**
     * 保存记录
     * @return
     * @throws Exception
     */
    public String saveRecord()throws Exception{
        try {
            if (StringUtils.isNotBlank(fieldVo.getReqid())) {
                if(StringUtils.isNotBlank(fieldVo.getWdId()) && StringUtils.isNotBlank(fieldVo.getAdId()) && StringUtils.isNotBlank(fieldVo.getTableName())){
                    HashMap param = new HashMap();
                    param.put("WD_ID", fieldVo.getWdId());
                    param.put("AD_ID", fieldVo.getAdId());
                    param.put("TABLE_NAME", fieldVo.getTableName());
                    String msg = "工作流:【"+fieldVo.getWdName()+"】的节点【"+fieldVo.getAdName()+"】中已经存在表【"+fieldVo.getTableAlias()+"】配置!";
                    //首先根据页面上工作流、节点、表、字段进行判断，是否已经存在该配置
                    //如果存在，则提示用户
                    //如果不存在，则根据主键id查询，该id是否存在，如果存在则更新，不存在插入
                    RequireFieldVo vo = requireFieldService.getObject(param);
                    if(vo != null){
                        if (!vo.getReqid().equals(fieldVo.getReqid())) {
                            message = msg;
                            result = "false";
                        }else {
                            requireFieldService.updateObject(fieldVo);
                            message = "操作成功";
                            result = "true";
                        }
                    }else {
                        param = new HashMap();
                        param.put("REQID", fieldVo.getReqid());
                        vo = requireFieldService.getObject(param);
                        if(vo != null){
                            requireFieldService.updateObject(fieldVo);
                        }else {
                            requireFieldService.insertObject(fieldVo);
                        }
                        message = "操作成功";
                        result = "true";
                    }
                }
            }
        } catch (Exception e) {
            message = "操作失败";
            result = "false";
        }
        initSelectList();
        return "input";
    }
    /**
     * 删除记录
     * @return
     * @throws Exception
     */
    public String deleteRecord() throws Exception{
        try {
            if (StringUtils.isNotBlank(reqid)) {
                String[] idArray = reqid.split(",");
                if (idArray != null) {
                    for (int i = 0; i < idArray.length; i++) {
                        requireFieldService.deleteObject(idArray[i]);
                    }
                }
            }
            message = "删除数据成功！";
            result = "true";
        } catch (Exception e) {
            e.printStackTrace();
            message = "删除数据失败！";
            result = "false";
        }
        return returnAjaxResponse(response,null, message, result);
    }

    /**
     * 获取对应业务下的工作流定义列表
     * @return
     */
    public String getWorkFlowDefineList()throws Exception{
        String json = "[]";
        result = "false";
        try {
            if (StringUtils.isNotBlank(businessid)) {
                List<PfWorkFlowDefineVo> workflowDefineList = workFlowDefineService.getWorkFlowDefineByBusiness(businessid);
                List<HashMap> mapList = new ArrayList<HashMap>();
                if (workflowDefineList != null) {
                    for(PfWorkFlowDefineVo mode:workflowDefineList){
                        HashMap map = new HashMap();
                        map.put("workflowDefinitionId",mode.getWorkflowDefinitionId());
                        map.put("workflowName",mode.getWorkflowName());
                        mapList.add(map);
                    }
                }
//		        HashMap map = new HashMap();
//	            map.put("workflowDefinitionId","");
//	            map.put("workflowName","请选择工作流......");
//	            mapList.add(0, map);
                json = JSONUtil.serialize(mapList);
                message = "获取成功";
                result = "true";
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return returnAjaxResponse(response, json, message, result);
    }
    /**
     * 获取对应业务下的工作流定义列表
     * @return
     */
    public String getConfigTableList()throws Exception{
        String json = "[]";
        result = "false";
        try {
            if (StringUtils.isNotBlank(businessid)) {
                HashMap map = new HashMap();
                map.put("BUSINESS_ID",businessid);
                tableList = requireFieldService.getObjectListByIbatisStr(map, "get_PF_REQUIRE_TABLEKEY");
                if (tableList == null) {
                    tableList = new ArrayList<RequireTableKeyVo>();
                }
                json = JSONUtil.serialize(tableList);
                message = "获取成功";
                result = "true";
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return returnAjaxResponse(response, json, message, result);
    }
    /**
     * 获取对应工作流下的节点定义列表
     * @return
     */
    public String getActivityDefinitionList()throws Exception{
        String json = "[]";
        result = "false";
        try {
            if (StringUtils.isNotBlank(wdid)) {
                PfWorkFlowDefineVo workFlowDefine = workFlowDefineService.getWorkFlowDefine(wdid);
                WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(workFlowDefine);
                List<ActivityModel> activityList = workFlowXml.getActivityList();
                List<HashMap> mapList = new ArrayList<HashMap>();
                for(ActivityModel mode:activityList){
                    HashMap map = new HashMap();
                    map.put("activityId",mode.getDefineId());
                    map.put("activityName",mode.getActivityDefineName());
                    mapList.add(map);
                }
//		        HashMap map = new HashMap();
//	            map.put("activityId","");
//	            map.put("activityName","请选择节点......");
//	            mapList.add(0, map);
                json = JSONUtil.serialize(mapList);
                message = "获取成功";
                result = "true";
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return returnAjaxResponse(response, json, message, result);
    }

    /**
     * 初始化页面下拉框选项
     */
    private void initSelectList(){
        try {
            List<PfBusinessVo> businessList = workFlowDefineService.getBusinessSimpleList();
            if (businessList != null) {
                businessMapList = new ArrayList<HashMap>();
                for(PfBusinessVo mode:businessList){
                    HashMap map = new HashMap();
                    map.put("businessId",mode.getBusinessId());
                    map.put("businessName",mode.getBusinessName());
                    businessMapList.add(map);
                }
                //获取业务下面的工作流定义列表
                if (StringUtils.isNotBlank(fieldVo.getBsId())) {
                    businessid = fieldVo.getBsId();
                }else {
                    businessid = businessList.get(0).getBusinessId();
                }
                List<PfWorkFlowDefineVo> workflowDefineList = workFlowDefineService.getWorkFlowDefineByBusiness(businessid);
                if (workflowDefineList != null) {
                    workflowDefineMapList = new ArrayList<HashMap>();
                    for(PfWorkFlowDefineVo mode:workflowDefineList){
                        HashMap map = new HashMap();
                        map.put("workflowDefinitionId",mode.getWorkflowDefinitionId());
                        map.put("workflowName",mode.getWorkflowName());
                        workflowDefineMapList.add(map);
                    }
                }
                //获取工作流下的节点列表
                if (StringUtils.isNotBlank(fieldVo.getWdId())) {
                    wdid = fieldVo.getWdId();
                }else {
                    if (workflowDefineList != null && workflowDefineList.size() > 0) {
                        wdid = workflowDefineList.get(0).getWorkflowDefinitionId();
                    }
                }
                if (StringUtils.isNotBlank(wdid)) {
                    PfWorkFlowDefineVo workFlowDefine = workFlowDefineService.getWorkFlowDefine(wdid);
                    WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(workFlowDefine);
                    List<ActivityModel> activityList = workFlowXml.getActivityList();
                    activityMapList = new ArrayList<HashMap>();
                    for(ActivityModel mode:activityList){
                        HashMap map = new HashMap();
                        map.put("activityId",mode.getDefineId());
                        map.put("activityName",mode.getActivityDefineName());
                        activityMapList.add(map);
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        }

        if (businessMapList == null) {
            businessMapList = new ArrayList<HashMap>();
        }
//		HashMap map = new HashMap();
//        map.put("businessId","");
//        map.put("businessName","请选择业务......");
//        businessMapList.add(0,map);

        if (workflowDefineMapList == null) {
            workflowDefineMapList = new ArrayList<HashMap>();
        }
//		map = new HashMap();
//        map.put("workflowDefinitionId","");
//        map.put("workflowName","请选择工作流......");
//        workflowDefineMapList.add(0, map);

        if (activityMapList == null) {
            activityMapList = new ArrayList<HashMap>();
        }
//		map = new HashMap();
//        map.put("activityId","");
//        map.put("activityName","请选择节点......");
//        activityMapList.add(0, map);

        if (StringUtils.isNotBlank(businessid)) {
            HashMap map = new HashMap();
            map.put("BUSINESS_ID",businessid);
            tableList = requireFieldService.getObjectListByIbatisStr(map, "get_PF_REQUIRE_TABLEKEY");
        }

        if (tableList == null) {
            tableList = new ArrayList<RequireTableKeyVo>();
        }
    }

    /**
     * Ajax返回操作
     * @param response
     * @param success
     * @param message
     * @param result
     * @return
     * @throws Exception
     */
    public String returnAjaxResponse(HttpServletResponse response,String success,String message,String result) throws Exception{
        try {
            HashMap<String, String> resultobj = new HashMap<String, String>();
            resultobj.put("success", success);
            resultobj.put("msg", message);
            resultobj.put("result", result);
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.println(JSONUtil.serialize(resultobj));
            out.flush();
            out.close();
        } catch (Exception e) {
        }
        return "none";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }
    public String getProid() {
        return proid;
    }
    public void setProid(String proid) {
        this.proid = proid;
    }
    public String getUserid() {
        return userid;
    }
    public void setUserid(String userid) {
        this.userid = userid;
    }
    public String getTaskid() {
        return taskid;
    }
    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }
    public SplitParam getSplitParam() {
        return splitParam;
    }
    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }
    public String getMessage() {
        return message;
    }
    public void setMessage(String message) {
        this.message = message;
    }
    public String getResult() {
        return result;
    }
    public void setResult(String result) {
        this.result = result;
    }
    public RequireFieldVo getFieldVo() {
        return fieldVo;
    }
    public void setFieldVo(RequireFieldVo fieldVo) {
        this.fieldVo = fieldVo;
    }
    public String getReqid() {
        return reqid;
    }
    public void setReqid(String reqid) {
        this.reqid = reqid;
    }
    public String getBusinessid() {
        return businessid;
    }
    public void setBusinessid(String businessid) {
        this.businessid = businessid;
    }
    public String getWdid() {
        return wdid;
    }
    public void setWdid(String wdid) {
        this.wdid = wdid;
    }
    public List<RequireTableKeyVo> getTableList() {
        return tableList;
    }
    public void setTableList(List<RequireTableKeyVo> tableList) {
        this.tableList = tableList;
    }
    public List<HashMap> getActivityMapList() {
        return activityMapList;
    }
    public void setActivityMapList(List<HashMap> activityMapList) {
        this.activityMapList = activityMapList;
    }
    public List<HashMap> getBusinessMapList() {
        return businessMapList;
    }
    public void setBusinessMapList(List<HashMap> businessMapList) {
        this.businessMapList = businessMapList;
    }
    public List<HashMap> getWorkflowDefineMapList() {
        return workflowDefineMapList;
    }
    public void setWorkflowDefineMapList(List<HashMap> workflowDefineMapList) {
        this.workflowDefineMapList = workflowDefineMapList;
    }
    public RequireFieldService getRequireFieldService() {
        return requireFieldService;
    }
    public void setRequireFieldService(RequireFieldService requireFieldService) {
        this.requireFieldService = requireFieldService;
    }
    public SysTaskService getSysTaskService() {
        return sysTaskService;
    }
    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }
    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return sysWorkFlowInstanceService;
    }
    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }
    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return workFlowDefineService;
    }
    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }
    public WorkFlowCoreService getWorkFlowService() {
        return workFlowService;
    }
    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }
    public SysSignService getSignService() {
        return signService;
    }
    public void setSignService(SysSignService signService) {
        this.signService = signService;
    }
}
