package com.gtis.web.action;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.util.CalendarUtil;
import com.gtis.web.SessionUtil;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.spring.Container;
import com.opensymphony.xwork2.ActionSupport;

public class WorkFlowStatAction extends ActionSupport {

	private List<String[]> lstInfo;//用于存储各个工作流定义对应的各个字段的个数
	private int[] countAll;
	private String createTime;
//	private List<String> WFD_IDlst;
	private String WFD_id;
	private String finishTime;
    private SysUserService userService;
    private String regioncode;
    private List<PfOrganVo> organs;
    private String categories = "";
    private String series = "";
    private SysWorkFlowInstanceDao workFlowInstanceDao;
    private SysWorkFlowDefineDao workFlowDefineDao;
    private String countType = "";

	public String execute() throws Exception {
		List<PfWorkFlowDefineVo> lstWFD = workFlowDefineDao.getWorkFlowDefineList();
		HashMap<String,String> map=new HashMap<String,String>();
		if(createTime!= null && createTime.trim().length()> 0){
			map.put("CREATE_TIME",createTime.trim());
			ServletActionContext.getRequest().setAttribute("CREATE_TIME", createTime.trim());
		}
		if(finishTime!= null && finishTime.trim().length()> 0){
			map.put("FINISH_TIME",finishTime.trim());
		}
		lstInfo = countWF(lstWFD, map);
		return "success";
	}
	
	public String findByWFD_id(){
//        String regioncodelike=userService.getRegionCodeByUserId(SessionUtil.getCurrentUserId());
		HashMap<String,String> map= new HashMap<String,String>();
		lstInfo= new ArrayList<String[]>();
		countAll= new int[8];
		
		map.put("WORKFLOW_DEFINITION_ID", getWFD_id());
		if(createTime!=null){
			map.put("CREATE_TIME", createTime);
		}
		if(finishTime!= null && finishTime.trim().length()> 0){
			map.put("FINISH_TIME",finishTime);
		}
//        map.put("REGION_CODE_LIKE",regioncodelike);
//        if (!org.apache.commons.lang.StringUtils.isBlank(this.regioncode))
//		    map.put("REGION_CODE",this.regioncode);

		SysWorkFlowInstanceDao workFlowInstanceDao = (SysWorkFlowInstanceDao) Container.getBean("SysWorkFlowInstanceDao");
		List<HashMap> WFIActivityHandlelst=workFlowInstanceDao.getWorkflowActivityStatusList(map);
		
		for(HashMap wfIActivityHandle:WFIActivityHandlelst )	{
			//System.out.println(wfIActivityHandle.get("ACTIVITY_NAME"));
			String[] info= new String[8];
			for(int j=1 ;j<8;j++){
				info[j]="0";
			}
			info[0]=wfIActivityHandle.get("ACTIVITY_NAME").toString();
			info[7]=wfIActivityHandle.get("NUM").toString();
			Integer num7=Integer.parseInt(info[7]);//对应任务总计
			map.put("ACTIVITY_NAME",info[0]);//指定为该活动
			map.put("ACTIVITY_STATE", "1");//正常办理
			map.remove("OUTDATE");
			
			List<HashMap> thisActivityHandlelst=workFlowInstanceDao.getWorkflowActivityStatusList(map);
			Integer num3=0;
			if(thisActivityHandlelst.size()!=0){
				info[3]=thisActivityHandlelst.get(0).get("NUM").toString();
				num3=Integer.parseInt(info[3]);
			}
			map.put("OUTDATE", "1");
			
			List<HashMap> thisActivityOUTDatelst=workFlowInstanceDao.getWorkflowActivityStatusList(map);
			Integer num2=0;
			if(thisActivityOUTDatelst.size()!=0){
				info[2]=thisActivityOUTDatelst.get(0).get("NUM").toString();
				num2=Integer.parseInt(info[2]);
			}
			Integer num1= num3-num2;
			info[1]=num1.toString();
			
			map.put("ACTIVITY_STATE", "2");//办结结束
			map.remove("OUTDATE");
			
			List<HashMap> thisActivityFinishlst=workFlowInstanceDao.getWorkflowActivityStatusList(map);
			Integer num6=0;
			if(thisActivityFinishlst.size()!=0){
				info[6]=thisActivityFinishlst.get(0).get("NUM").toString();
				num6=Integer.parseInt(info[6]);
			}
			map.put("OUTDATE", "1");
			
			List<HashMap> thisActivityFinishOUTDatelst=workFlowInstanceDao.getWorkflowActivityStatusList(map);
			Integer num5=0;
			if(thisActivityFinishOUTDatelst.size()!=0){
				info[5]=thisActivityFinishOUTDatelst.get(0).get("NUM").toString();
				num5=Integer.parseInt(info[5]);
			}
			Integer num4= num6-num5;
			info[4]=num4.toString();
			
			countAll[1]+=num1;
			countAll[2]+=num2;
			countAll[3]+=num3;
			countAll[4]+=num4;
			countAll[5]+=num5;
			countAll[6]+=num6;
			countAll[7]+=num7;
			lstInfo.add(info);
		}
		
		return "find";
	}

	public String openWFChart()throws Exception{
		try {
			UserInfo userInfo = SessionUtil.getCurrentUser();
			//首先获取所有业务
			List<PfBusinessVo> businessList = workFlowDefineDao.getBusinessSimpleList();
			//获取业务下工作流定义
			HashMap<String,String> map=new HashMap<String,String>();
	        int month = CalendarUtil.getMonth();
	        if (StringUtils.isBlank(countType)) {
				countType = "week";
			}
	        if (("week").equals(countType)) {//本周
	        	createTime = CalendarUtil.getMondayOFWeek();
	        	finishTime = CalendarUtil.getCurrentWeekday();
			}else if ("month".equals(countType)) {//本月
				createTime = CalendarUtil.getFirstDayOfMonth();
	        	finishTime = CalendarUtil.getDefaultDay();
			}else if ("quarter".equals(countType)) {//本季度
				createTime = CalendarUtil.getThisSeasonFirstTime(month);
	        	finishTime = CalendarUtil.getThisSeasonFinallyTime(month);
			}
			if(createTime!= null && createTime.trim().length()> 0){
				map.put("CREATE_TIME",createTime.trim());
				ServletActionContext.getRequest().setAttribute("CREATE_TIME", createTime.trim());
			}
			if(finishTime!= null && finishTime.trim().length()> 0){
				map.put("FINISH_TIME",finishTime.trim());
			}
			List<String []> tempList = new ArrayList<String[]>();
			if (businessList != null && businessList.size() > 0) {
				for (int i = 0; i < businessList.size(); i++) {
					List<PfWorkFlowDefineVo> wfDefineList = workFlowDefineDao.getWorkFlowDefineListByRole(userInfo.getRoleIds(),null,businessList.get(i).getBusinessId());
					//获取工作流定义对应的办理数量
					this.countWF(wfDefineList, map);
					String[] info = new String[11];
					info[0]=businessList.get(i).getBusinessName();
					info[3]=String.valueOf(countAll[3]);
					info[6]=String.valueOf(countAll[6]);
					info[9]=String.valueOf(countAll[9]);
					tempList.add(info);
				}
			}
			sortListAndDoChart(tempList);
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
        return "wfchart";
	}
	
	public String getWFChartDate()throws Exception{
		openWFChart();
		HashMap<String, String> resultobj = new HashMap<String, String>();
		resultobj.put("categories", categories);
		resultobj.put("series", series);
		resultobj.put("result", "true");
		ServletActionContext.getResponse().setContentType("text/html;charset=UTF-8");
		PrintWriter out = ServletActionContext.getResponse().getWriter();
		out.println(JSONUtil.serialize(resultobj));
		out.flush();
		out.close();
		return "none";
	}
	
	/**
	 * 统计工作流定义办理数据
	 * @param lstWFD
	 * @param map
	 * @return
	 */
	private List<String []> countWF(List<PfWorkFlowDefineVo> lstWFD,HashMap<String,String> map){
		List<String []> tempList = new ArrayList<String[]>();
		countAll=new int[10];//用于合计全部工作流实例的个数
		for (PfWorkFlowDefineVo WFDObj : lstWFD) {
			String[] info = new String[11];//用于存储页面上对应的工作流定义对应的工作流实例个数
			info[10]=WFDObj.getWorkflowDefinitionId();//存下工作流定义的id
			info[0] = WFDObj.getWorkflowName();
			map.put("WORKFLOW_DEFINITION_ID",WFDObj.getWorkflowDefinitionId());
			map.remove("WORKFLOW_STATE");
			map.remove("OUTDATE");
			List<HashMap> workflowStatusList =  workFlowInstanceDao.getWorkflowStatusList(map);
			
			for(int j=1 ;j<10;j++){
				info[j]="0";
			}
			Integer num9=0;
			for(HashMap workflowStatus : workflowStatusList)
			{
				if(workflowStatus!=null){
					String wf_state=((BigDecimal)workflowStatus.get("WORKFLOW_STATE")).toString();
					String wf_statenum=((BigDecimal)workflowStatus.get("NUM")).toString();
					int numAll=Integer.parseInt(wf_statenum);
					
					if(wf_state.equals("1")||wf_state.equals("2")){
						map.put("WORKFLOW_STATE",wf_state);
						map.put("OUTDATE","1");
						List<HashMap> wfIOUTDatelst =  workFlowInstanceDao.getWorkflowStatusList(map);
						String wf_stateOutDatenum="0";
						Integer numNormal=new Integer(0);
						Integer numOutDate=new Integer(0);
						if(wfIOUTDatelst.size()!=0)
						{
							numOutDate= Integer.parseInt(((BigDecimal)wfIOUTDatelst.get(0).get("NUM")).toString());
							if (numOutDate != null){
								wf_stateOutDatenum=numOutDate.toString();
							}
						}
						numNormal=numAll-numOutDate;
						num9=num9+numAll;
						if(wf_state.equals("1")){
							info[1]=numNormal.toString();
							info[2]=wf_stateOutDatenum;
							info[3]=wf_statenum;
							countAll[1]+=numNormal;
							countAll[2]+=numOutDate;
							countAll[3]+=numAll;
						}
						else if(wf_state.equals("2")){
							info[4]=numNormal.toString();
							info[5]=wf_stateOutDatenum;
							info[6]=wf_statenum;
							countAll[4]+=numNormal;
							countAll[5]+=numOutDate;
							countAll[6]+=numAll;
						}
					}
					else if(wf_state.equals("3")){
						info[7]=wf_statenum;
						countAll[7]+=numAll;
					}
					else if(wf_state.equals("4")){
						info[8]=wf_statenum;
						countAll[8]+=numAll;
					}
				}
			}
			countAll[9]+=num9;
			info[9]=num9.toString();
			tempList.add(info);
		}
		return tempList;
	}

	/**
	 * 针对统计数据按照总数量进行倒叙排列，并获取前七个业务数据
	 * 组织图表所需要的基本参数
	 * @param tempList
	 */
	private String[] sortListAndDoChart(List<String []> tempList)throws Exception{
		String[] strAry= new String[2];
		if (tempList != null && tempList.size() > 0) {
			//倒序排列
	        Collections.sort(tempList, new Comparator() {
				@Override
				public int compare(Object o1, Object o2) {
					int asc = 0;
					if (o1 != null && o2 != null) {
						String[] ary1 = (String[])o1;
						String[] ary2 = (String[])o2;
						if (StringUtils.isNotBlank(ary1[9]) && StringUtils.isNotBlank(ary2[9])) {
							asc = new Integer(ary2[9]).compareTo(new Integer(ary1[9]));
						}
					}
					return asc;
				}
			});
//	        System.out.println(JSONUtil.serialize(tempList));
	        //开始组织前台所需要的前七个工作流的数据
	        if (tempList != null && tempList.size() > 0) {
	        	int size = 7;
	        	if (tempList.size() < 7) {
	        		size = tempList.size();
				}
		        String series_all = "{name: '总数量',color: '#4682B4',showInLegend: false,data: [";
		        String series_do = "{name: '正在办理',color: '#87CEFA',visible: false,data: [";
		        String series_over = "{name: '已办结',color: '#9ACD32',visible: false,data: [";
//		        var categories = ['土地登记', '建设用地预审', '地块内部审查', '分批次报件', '独立选址'];
//		    	var series = [{name: '总数量',data: [107, 31, 635, 203, 2]}, {name: '正在办理',data: [133, 156, 947, 408, 6]}, { name: '已办结',data: [973, 914, 4054, 732, 34]}];
		        for (int i = 0; i < size; i++) {
		        	String[] ary = tempList.get(i);
					categories += "'" + ary[0] + "',";
					series_all += ary[9] + ",";
					series_do += ary[3] + ",";
					series_over += ary[6] + ",";
				}
		        categories = StringUtils.replace(categories, "null", "0");
		        categories = StringUtils.replace(categories, " ", "");
		        if (categories.endsWith(",")) {
		        	categories = categories.substring(0, categories.length() - 1);
				}
		        categories = "["+categories+"]";
		        if (series_all.endsWith(",")) {
		        	series_all = series_all.substring(0, series_all.length() - 1);
				}
		        series_all += "]}";
		        if (series_do.endsWith(",")) {
		        	series_do = series_do.substring(0, series_do.length() - 1);
				}
		        series_do += "]}";
		        if (series_over.endsWith(",")) {
		        	series_over = series_over.substring(0, series_over.length() - 1);
				}
		        series_over += "]}";
		        series = "["+series_all+","+series_do+","+series_over+"]";
			}
		}
		strAry[0] = categories;
		strAry[1] = series;
		return strAry;
	}
    public List<PfOrganVo> getOrgans() {
        return organs;
    }

    public void setOrgans(List<PfOrganVo> organs) {
        this.organs = organs;
    }

    public String getRegioncode() {
        return regioncode;
    }

    public void setRegioncode(String regioncode) {
        this.regioncode = regioncode;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public List<String[]> getLstInfo() {
		return lstInfo;
	}

	public void setLstInfo(List<String[]> lstInfo) {
		this.lstInfo = lstInfo;
	}

	public String getCreateTime() {
		return createTime;
	}

	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public int[] getCountAll() {
		return countAll;
	}

	public void setCountAll(int[] countAll) {
		this.countAll = countAll;
	}

	public String getWFD_id() {
		return WFD_id;
	}

	public void setWFD_id(String wfd_id) {
		WFD_id = wfd_id;
	}
	
	public String getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(String finishTime) {
		this.finishTime = finishTime;
	}

	public String getCategories() {
		return categories;
	}

	public void setCategories(String categories) {
		this.categories = categories;
	}

	public String getSeries() {
		return series;
	}

	public void setSeries(String series) {
		this.series = series;
	}

	public String getCountType() {
		return countType;
	}

	public void setCountType(String countType) {
		this.countType = countType;
	}

	public SysWorkFlowInstanceDao getWorkFlowInstanceDao() {
		return workFlowInstanceDao;
	}

	public void setWorkFlowInstanceDao(SysWorkFlowInstanceDao workFlowInstanceDao) {
		this.workFlowInstanceDao = workFlowInstanceDao;
	}

	public SysWorkFlowDefineDao getWorkFlowDefineDao() {
		return workFlowDefineDao;
	}

	public void setWorkFlowDefineDao(SysWorkFlowDefineDao workFlowDefineDao) {
		this.workFlowDefineDao = workFlowDefineDao;
	}
}
