package com.gtis.web.action;

import com.gtis.common.http.Utf8PostMethod;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.util.CalendarUtil;
import com.gtis.util.StaticParamHelper;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TurnWorkFlowAction {
    private static final Log log = LogFactory.getLog(TurnWorkFlowAction.class);
    /** 工作流核心服务 */
	private WorkFlowCoreService workFlowService;
    /** 工作流定义服务 */
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    /** 工作流实例关系服务 */
    private SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService;
    /** 工作流实例服务 */
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    /** 收件单服务 */
    private SysSjdService sysSjdService;
    /** 文件中心 */
    private NodeService nodeService;
    /** 意见服务 */
    private SysOpinionService opinionService;
    /**子流程服务*/
    private SysSubProcessService sysSubProcessService;
    /**活动服务*/
    private SysTaskService sysTaskService;
    /** 转发信息xml */
	private String turnXml;
    /** 任务id */
	private String taskid;
    /** 意见列表 */
    private String opinions;
    private String nextWdid;
    private static final String CONTENT_TYPE_IMAGE = "text/xml";

    private static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    //是否弹出转发确认
    private boolean  confirmTurnInfo=false;
    //是否是子流程结束
    private boolean subProcessFinish = false;

    private List<PfWorkFlowDefineVo> nextWorkflowList;

    public boolean isConfirmTurnInfo() {
        return confirmTurnInfo;
    }

    public String execute() throws Exception {
		
		String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = null;
        if(sysSubProcessService.isSubProcessFinishing(taskid)){
            subProcessFinish = true;
            info = workFlowService.getWorkFlowTurnInfo("-1", sysTaskService.getActivity(sysTaskService.getTask(taskid).getActivityId()).getWorkflowInstanceId());
        }else{
            info = workFlowService.getWorkFlowTurnInfo(userId,taskid);
        }
        
		turnXml = turnInfo(info);
        opinions = JSONUtil.serialize(opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName()));
        //
        WorkFlowXml workFlowXml= WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        ActivityModel activityModel= workFlowXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
        if ("true".equals(activityModel.getExtendedAttribute("ConfirmTurnInfo")))
            confirmTurnInfo=true;
		return Action.SUCCESS;
	}

    public String trunXml() throws Exception {
        String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);

		turnXml = turnInfo(info);
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(turnXml);

        return Action.NONE;
    }

    public String opinions() throws Exception{
        String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);

        opinions = JSONUtil.serialize(opinionService.getOpinionList(userId,info.getWorkFlowDefineVo().getWorkflowName()));
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(opinions);

        return Action.NONE;
    }
    /**
     *
     * <Activitys RelType="or">
     *  <Activity Name="转发活动一" Id="a1" MutiSelect="true" DefaultSelected="true">
     *      <User Name="××部门" Id="1">
     *          <UserInfo Name="u1" Id="u1" DefaultSelected="true"/>
     *          <UserInfo Name="u11" Id="u11"/>
     *      </User>
     *      <User Name="××部门" Id="2">
     *          <UserInfo Name="au2" Id="u2"/>
     *          <UserInfo Name="au21" Id="u21"/>
     *      </User>
     *      <User Name="××角色" Id="3">
     *          <UserInfo Name="au3" Id="u3" DefaultSelected="true"/>
     *          <UserInfo Name="au31" Id="u31"/>
     *          <UserInfo  Name="au32" Id="u32"/>
     *      </User>
     *  </Activity>
     *  <Activity Name="转发活动二" Id="a2" MutiSelect="false">
     *   <User Name="××部门" Id="11">
     *      <UserInfo Name="u1" Id="u1"/>
     *      <UserInfo Name="u11" Id="u11"/>
     *   </User>
     * </Activitys>
     *
     *
     */

	private String turnInfo(WorkFlowInfo info) throws Exception {

        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());

        String filterType = null;
        List<String> filterStr = null;
        if(StringUtils.isNotBlank(activityModel.getFilterInfo())){
            //过滤信息对象
            Document fileDoc = DocumentHelper.parseText(activityModel.getFilterInfo());
            //过滤类型：User,Organ,Role
            String user = fileDoc.getRootElement().valueOf("@type");
            Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getUserId(ServletActionContext.getRequest()) + "']/Correspondence");
            if(corNode != null){
                filterType = corNode.valueOf("@type");
                List<DefaultText> organList = corNode.selectNodes(filterType + "/text()");
                if(organList != null && !organList.isEmpty()){
                    filterStr = new ArrayList<String>();
                    for(DefaultText text : organList){
                        filterStr.add(text.getText());    
                    }
                }
            }
        }

        WorkFlowTransInfo transInfo=info.getTransInfo();
		Document doc = org.dom4j.DocumentHelper.createDocument();
        //doc.setXMLEncoding("GBK");
		Element root = doc.addElement("Activitys");
		if (transInfo.getTransType().equalsIgnoreCase("and"))
			root.addAttribute("RelType", "and");
		else
			root.addAttribute("RelType", "or");
        
        if(activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")){
            root.addAttribute("ReqOpinion", "true");
        }else{
            root.addAttribute("ReqOpinion", "false");
        }
        if(activityModel.getIsSendSMS().equalsIgnoreCase("true")){
            root.addAttribute("SendSMS","true");
        }else{
            root.addAttribute("SendSMS","false");
        }
        if(StringUtils.isNotBlank(activityModel.getCooperRootId())){
            root.addAttribute("cooperRootId",activityModel.getCooperRootId());
        }
        
		List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans.size()<2)
            root.addAttribute("RelType", "or");
		for (ActivityModel aModel : lstTrans) {
			Element ActivityEle = root.addElement("Activity");
			ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
			ActivityEle.addAttribute("Id", aModel.getDefineId());
			if (aModel.isMutiSelect())
				ActivityEle.addAttribute("MutiSelect", "true");

            if(!aModel.isSelectAll())
                ActivityEle.addAttribute("SelectAll","false");
            else
                ActivityEle.addAttribute("SelectAll","true");

			if(aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName()))
				ActivityEle.addAttribute("DefaultSelected", "true");
            else
                ActivityEle.addAttribute("DefaultSelected", "false");
            String userName=null;
            if(StringUtils.isNotBlank(aModel.getExtendedAttribute("DefaultSelectedUser"))){
                userName=aModel.getExtendedAttribute("DefaultSelectedUser");    
            }
			for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if(filterStr != null && userModel.getType().equals(filterType)){
                    if(!filterStr.contains(userModel.getId())){
                        continue;    
                    }
                }
                Element User = ActivityEle.addElement("User");
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                for (PfUserVo vo : userModel.getUserList()) {
                    Element UserInfo = User.addElement("UserInfo");
                    UserInfo.addAttribute("Name", vo.getUserName());
                    UserInfo.addAttribute("Id", vo.getUserId());
                    if (StringUtils.isNotBlank(userName) && vo.getUserName().equalsIgnoreCase(userName)){
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo.addAttribute("DefaultSelected", "true");
                    }
                    if (vo.getUserId().equals(SessionUtil.getCurrentUserId())){
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo.addAttribute("DefaultSelected", "true");
                    }
                }
			}
		}
		// 加入是否可以办结
		if (transInfo.isCanFinish()) {
			Element ActivityEle = root.addElement("Activity");
			ActivityEle.addAttribute("Name", "任务办结");
			ActivityEle.addAttribute("Id", "-1");
		}

        doc = httpFilterXml(doc,activityModel,info);

		return doc.getRootElement().asXML();
	}

    /**
     * 通过TurnInfo处理url
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc,ActivityModel actModel,WorkFlowInfo info){
        if(StringUtils.isNotBlank(actModel.getTurnInfoUrl())){
            String url = actModel.getTurnInfoUrl();
            if(!url.startsWith("http")){
                url = AppConfig.getPlaceholderValue(url);
            }
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = {
                new NameValuePair("turnInfo",doc.asXML()),
                new NameValuePair("userId",info.getUserId()),
                new NameValuePair("proId",(info.getWorkFlowIntanceVo() == null)? "":info.getWorkFlowIntanceVo().getProId())
            };

            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                log.error("TurnInfo filter url request failer{}",e);
            }
            if (status == HttpStatus.SC_OK){
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if(StringUtils.isNotBlank(xml)){
                        doc = DocumentHelper.parseText(xml);
                    }
                } catch (Exception e) {
                    log.error("TurnInfo filter url request success,prase failure{}",e);
                }
            }else{
                log.error("TurnInfo filter url request failer");
            }
        }
        return doc;
    }

	/**
	 * 开始转发
	 * 
	 * @return
	 * @throws Exception
     *
     *<?xml version="1.0" encoding="UTF-8"?>
     * <Activitys RelType="or">
     *  <Activity Id="2806A214134F42A798483B2033DE05FB">
     *  <UserInfo Id="02501030000007603100000000000000" RoleId="75501003000000000800000000000000"/>
     *  </Activity>
     *  <ReMark>
     *  <text/>
     *  </ReMark>
     *  </Activitys>
	 */
	public String TurnTask() throws Exception {
        try{
            String userId = SessionUtil.getCurrentUserId();
            WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
		    workFlowService.turnTask(parseTurnInfo(), taskid);
            if(StringUtils.isNotBlank(nextWdid)){
                startNextWorkflow(info.getWorkFlowIntanceVo());
            }
        }catch (Exception e){
            e.printStackTrace();
            printResult(e.getMessage());
        }
        printResult(null);
		return Action.NONE;
	}

	/**
	 * 读取提交的XML信息
	 * 
	 * @return
	 */
	private Document parseTurnInfo() throws Exception{
		Document doc = null;
        SAXReader reader = new SAXReader();
        doc = reader.read(ServletActionContext.getRequest()
                .getInputStream());
		return doc;
	}

	private void printResult(String  info) {
		try {
			ServletActionContext.getResponse().setContentType("text/html; charset=utf-8");
			PrintWriter out = ServletActionContext.getResponse().getWriter();
			if (info==null)
				out.print("true");
			else
				out.println(info);
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

    /**
     * 复杂的办结页面
     * @return
     * @throws Exception
     */
    public String finishWorkflow() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String enabledNextWorkflow = activityModel.getEnabledNextWorkflow();
        if(StringUtils.isNotBlank(enabledNextWorkflow)){
            nextWorkflowList = new ArrayList<PfWorkFlowDefineVo>();
            List workflowNameList = Arrays.asList(enabledNextWorkflow.split(","));
            List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList =  sysWorkFlowDefineService.getWorkFlowDefineList();
            for(PfWorkFlowDefineVo pfWorkFlowDefineVo:pfWorkFlowDefineVoList){
                if(workflowNameList.indexOf(pfWorkFlowDefineVo.getWorkflowName())>-1){
                    nextWorkflowList.add(pfWorkFlowDefineVo);
                }
            }
        }
        return "finish";
    }

    /**
     * 办结时是否需要有后续流程可启动
     * @return
     * @throws Exception
     */
    public String hasNextWorkflow() throws Exception{
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String enabledNextWorkflow = activityModel.getEnabledNextWorkflow();
        if(StringUtils.isNotBlank(enabledNextWorkflow))
            printResult(null);
        else
            printResult("false");
        return Action.NONE;
    }

    /**
     * 启动后续流程
     * @param pfWorkFlowInstanceVo
     * @throws Exception
     */
    private void startNextWorkflow(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception{
        String currentWorkflowName = pfWorkFlowInstanceVo.getWorkflowIntanceName();
        PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(nextWdid);
        //获取该流程的工作流关联信息，判断是否已经创建过新流程
        boolean isOk = true;
        List<PfWorkFlowInstanceVo> voList = sysWorkFlowInstanceRelService.getWorkFlowRelList(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        if (voList != null || voList.size() > 0) {
            for (int i = 0; i < voList.size(); i++) {
                if (StringUtils.equals(voList.get(i).getWorkflowDefinitionId(), nextWdid)) {
                    isOk = false;
                    break;
                }
            }
        }
        if (isOk) {
            //首先获取当前工作流id下相关信息，主要包括文件中心、工作流名称
            Space space = nodeService.getWorkSpace(WORK_FLOW_STUFF, true);
            com.gtis.fileCenter.model.Node curNode = nodeService.getNode(space.getId(), pfWorkFlowInstanceVo.getWorkflowIntanceId(), true);
            Integer curNodeId=curNode.getId();
            List<com.gtis.fileCenter.model.Node> curNodeList = nodeService.getChildNodes(curNodeId);
            Integer[] curNodes = null;
            if (curNodeList != null && curNodeList.size() > 0) {
                curNodes = new Integer[curNodeList.size()];
                for (int i = 0; i < curNodeList.size(); i++) {
                    curNodes[i] = curNodeList.get(i).getId();
                }
            }

            //创建wdid对应的工作流实例ID
            String newProid = UUIDGenerator.generate();
            com.gtis.fileCenter.model.Node newNode = nodeService.getNode(space.getId(), newProid, true);
            Integer newNodeId=newNode.getId();

            //开始文件中心记录复制
            if (curNodes != null && curNodes.length > 0) {
                nodeService.copy(curNodes, newNodeId, true);
            }

            //开始创建目标工作流
            String userid = SessionUtil.getCurrentUserId();
            String username = SessionUtil.getCurrentUser().getUsername();
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            intanceVo.setWorkflowDefinitionId(nextWdid);
            intanceVo.setWorkflowIntanceId(newProid);
            intanceVo.setProId(newProid);
            //标明是大流程
            String remark = StaticParamHelper.FULL_WFINSTANCE;
            intanceVo.setRemark(remark);
            intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setPriority("1");
            intanceVo.setWorkflowIntanceName(currentWorkflowName);
            intanceVo.setCreateUser(userid);
            intanceVo.setCreateTime(CalendarUtil.getCurHMDate());
            intanceVo.setDistrict(pfWorkFlowInstanceVo.getDistrict());

            //保存关联工作流信息
            sysWorkFlowInstanceRelService.insertWorkFlowRel(pfWorkFlowInstanceVo.getWorkflowIntanceId(),newProid);
            //创建工作流
            WorkFlowInfo infoObj = workFlowService.createWorkFlowInstance(intanceVo, userid);
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userid)) {
                    taskid = taskVo.getTaskId();
                    break;
                }
            }
            if (taskid == null || taskid.equals("")) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskid = taskVo.getTaskId();
                    break;
                }
            }


            //初始化收件单材料，合并当前收件单材料和新流程的收件材料
            sysSjdService.createSjdByPreviousWorkflow(newProid,username,newNodeId,pfWorkFlowInstanceVo.getWorkflowIntanceId());
        }
    }



	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

    public String getOpinions() {
        return opinions;
    }

    public WorkFlowCoreService getWorkFlowService() {
		return workFlowService;
	}

	public void setWorkFlowService(WorkFlowCoreService workFlowService) {
		this.workFlowService = workFlowService;
	}

	public String getTurnXml() {
		return turnXml;
	}

	public void setTurnXml(String turnXml) {
		this.turnXml = turnXml;
	}

    public void setOpinionService(SysOpinionService opinionService) {
        this.opinionService = opinionService;
    }

    public SysWorkFlowDefineService getSysWorkFlowDefineService() {
        return sysWorkFlowDefineService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }

    public List<PfWorkFlowDefineVo> getNextWorkflowList() {
        return nextWorkflowList;
    }

    public void setNextWorkflowList(List<PfWorkFlowDefineVo> nextWorkflowList) {
        this.nextWorkflowList = nextWorkflowList;
    }

    public NodeService getNodeService() {
        return nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public SysSjdService getSysSjdService() {
        return sysSjdService;
    }

    public void setSysSjdService(SysSjdService sysSjdService) {
        this.sysSjdService = sysSjdService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public SysWorkFlowInstanceRelService getSysWorkFlowInstanceRelService() {
        return sysWorkFlowInstanceRelService;
    }

    public void setSysWorkFlowInstanceRelService(SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService) {
        this.sysWorkFlowInstanceRelService = sysWorkFlowInstanceRelService;
    }

    public String getNextWdid() {
        return nextWdid;
    }

    public void setNextWdid(String nextWdid) {
        this.nextWdid = nextWdid;
    }

    public SysSubProcessService getSysSubProcessService() {
        return sysSubProcessService;
    }

    public void setSysSubProcessService(SysSubProcessService sysSubProcessService) {
        this.sysSubProcessService = sysSubProcessService;
    }

    public boolean isSubProcessFinish() {
        return subProcessFinish;
    }

    public void setSubProcessFinish(boolean subProcessFinish) {
        this.subProcessFinish = subProcessFinish;
    }

    public SysTaskService getSysTaskService() {
        return sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }
}
