package com.gtis.web.action;

import java.util.List;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.wf.model.RiskModel;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.ResourceModel;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

public class TaskHandleAction {
	private String taskid;
	private SysTaskService taskService;
    private SysActivityService activityService;
	private SysWorkFlowInstanceService workFlowIntanceService;
	private SysWorkFlowDefineService workFlowDefineService;
    private NodeService nodeService;   //用来获取附件

	private PfTaskVo taskVo;
	private PfActivityVo activityVo;
	private PfWorkFlowInstanceVo workFlowInstanceVo;
	private PfWorkFlowDefineVo workFlowDefineVo;
	private int menuCount;
	private boolean hasDel = false; // 是否具有删除权限
    private boolean hasFinish=false; // 是否可以办结
    private String defaultName="";
    private boolean hasSave=false;  //是否显示保存按钮
    private boolean quickTurn=false;//快速转发
    private boolean canDelOthers=false;  //是否取件
    private String fileTokenId;   //文件中心用tokenid
    private int fileCenterNodeId;
    private List<PfTaskVo> beforeTasks;  //前一个任务办理人
    private boolean taskRemark;   //是否存在办理意见
    private String readOnly;//控制文件中心是否只读
    private boolean canTrustTask=false;  //是否允许委托办理
    //勘测定界扩展属性配置
    private String kcdjTypeConfig;
    private String busiType;

    /** 风险点列表 */
    private List<RiskModel> riskList;
    /** 风险分页 */
    private SplitParam splitParam;
    private boolean cmsEnabled = false;

    public boolean isCanTrustTask() {
        return canTrustTask;
    }

    public String getSenderUsers() throws Exception{
        StringBuffer userNameBuffer=new StringBuffer();
        taskVo = taskService.getTask(taskid);
        if (taskVo==null)
            taskVo = taskService.getHistoryTask(taskid);
        beforeTasks=taskService.getHistoryTaskByBefore(taskVo);
        if (beforeTasks!=null && beforeTasks.size()>0) {
            int size=0;
            for (PfTaskVo task:beforeTasks) {
                size++;
                if (size==2 && beforeTasks.size()>2) {
                    userNameBuffer.append(task.getUserVo().getUserName() + "等");
                }else{
                    userNameBuffer.append(task.getUserVo().getUserName() + " ");
                }
            }
        }else{
            userNameBuffer.append("");
        }
        ServletActionContext.getResponse().getWriter().println(userNameBuffer.toString());
        return Action.NONE;
    }

    public String execute() throws Exception {
		if (StringUtils.isNotBlank(taskid)) {
            taskService.updateTaskStadus(taskid);
			taskVo = taskService.getTask(taskid);
			activityVo = taskService.getActivity(taskVo.getActivityId());
			workFlowInstanceVo = workFlowIntanceService
					.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            ///////客户端用来获取附件////////////////////////////////////////
            Space space = nodeService.getWorkSpace(StuffManageAction.WORK_FLOW_STUFF,true);
            try{
                Node node = nodeService.getNode(space.getId(), activityVo.getWorkflowInstanceId(), true);
                if (node!=null){
                    fileTokenId=nodeService.getToken(node);
                    fileCenterNodeId=node.getId();
                }
            }catch (Exception ex){

            }
            ////////////////////////////////////////////////////////////
            this.beforeTasks=taskService.getHistoryTaskByBefore(taskVo);
//            for(PfTaskVo beforeTask: this.beforeTasks){
//                if (StringUtils.isNotBlank(beforeTask.getRemark())){
//                    taskRemark=true;
//                    break;
//                }
//            }
            ////////////////////////////////////////////////////
			workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
			// 菜单
			WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
			ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            quickTurn = aModel.isQuickTurn();
            riskList = aModel.getRiskModelList();
            defaultName=aModel.getExtendedAttribute("DefaultName");
            if ("true".equals(aModel.getExtendedAttribute("CanEnTrustTask")))
                canTrustTask=true;
            //扩展属性中关于勘测定界管理模块的配置属性获取
            kcdjTypeConfig = aModel.getExtendedAttribute("KcdjTypeConfig")+"";
            if (StringUtils.isBlank(kcdjTypeConfig)) {
				kcdjTypeConfig = xmlModel.getExtendedAttribute("KcdjTypeConfig");
			}
            busiType = xmlModel.getExtendedAttribute("BusiType")+"";
            if (StringUtils.isBlank(busiType)) {
            	busiType = xmlModel.getExtendedAttribute("busiType")+"";
			}
            
            //默认赋予文件中心可编辑权限，只有在工作流扩展属性中增加了“FileCenterReadOnly”属性，且赋值为“true”时，不可编辑
            readOnly = aModel.getExtendedAttribute("FileCenterReadOnly")+"";
            readOnly = readOnly.toLowerCase();
            if (!readOnly.equals("true")) {
                readOnly = "false";
            }
			org.dom4j.Node node = aModel.getResourcesNode();
            if (node!=null){
                List resList=node.selectNodes(".//Resource");
                menuCount = resList.size();
            }
//            if (beforeTask!=null && beforeTask.getRemark()!=null){
//                beforeTask.setRemark(beforeTask.getRemark().replaceAll("\n", "<br/>"));
//            }
//			if (activityVo.isBackState()) { // 判断是否退回
//				List<PfActivityVo> lstActivitys = taskService
//						.getWorkFlowInstanceAllActivityList(workFlowInstanceVo
//								.getWorkflowIntanceId());
//				for (PfActivityVo activityBefore : lstActivitys) {
//					if (activityBefore.getActivityState() == WorkFlowEnum.ACTIVITY_END
//							&& activityBefore.getActivityBefore()!=null
//							&& activityBefore.getActivityBefore().equals(
//									activityVo.getActivityId())) {
//						beforeTasks = taskService
//								.getHistoryTasks(activityBefore.getActivityId());
//						break;
//					}
//				}
//
//			} else {
//				if (activityVo.getActivityBefore() != null) {
//					PfActivityVo bfActivity = taskService
//							.getActivity(activityVo.getActivityBefore());
//					beforeTasks = taskService.getHistoryTasks(bfActivity
//							.getActivityId());
//				}
//			}
//			if (beforeTasks!=null){
//				Iterator<PfTaskVo> it=beforeTasks.iterator();
//				List<String> lstTaskIds=new ArrayList<String>();
//				while(it.hasNext()){
//					taskVo=it.next();
//					if (lstTaskIds.contains(taskVo.getUserVo().getUserId())){
//						it.remove();
//	//					it=beforeTasks.iterator();
//						continue;
//					}
//					lstTaskIds.add(taskVo.getUserVo().getUserId());
//					if (taskVo.getRemark() != null && !taskVo.getRemark().equals("")) {
//						taskVo.setRemark(taskVo.getRemark().replaceAll("\n", "<br/>"));
//					}
//				}
//			}
			hasDel = permitDel(taskVo);
            PfTaskVo parentWorkflowTaskVo=getTaskService().getTask(workFlowInstanceVo.getWorkflowIntanceId());
            if ("结束活动".equals(aModel.getActivityDescription())&&parentWorkflowTaskVo==null){
                this.hasFinish=true;
            }else{
                if (aModel.getDefineId().equals(xmlModel.getEndActivityDefine()) && aModel.getTransitionsList().size()==0 &&parentWorkflowTaskVo==null)
                    this.hasFinish=true;
            }

            canDelOthers= aModel.isCanDelOthers();
            cmsEnabled = AppConfig.getBooleanProperty("cms.enable",false);
		}
		return Action.SUCCESS;
	}


    /**
     * 风险点列表
     * */
    public String risk() throws Exception{
        if (StringUtils.isNotBlank(taskid)) {
            taskVo = taskService.getTask(taskid);
            if(taskVo == null){
                taskVo = taskService.getHistoryTask(taskid);
            }
            activityVo = taskService.getActivity(taskVo.getActivityId());
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            riskList = aModel.getRiskModelList();
        }
        return "risk";
    }

    /**
     * 风险汇总列表
     * @return
     * @throws Exception
     */
    public String risklist() throws Exception{
        splitParam = new SplitParamImpl();
        splitParam.setQueryString("getRisklist");

        return "risklist";
    }

	public String menu() throws Exception {
		if (taskid != null && !taskid.equals("")) {
			taskVo = taskService.getTask(taskid);
			activityVo = taskService.getActivity(taskVo.getActivityId());
			workFlowInstanceVo = workFlowIntanceService
					.getWorkflowInstance(activityVo.getWorkflowInstanceId());
			// WorkFlowXml
			// xmlModel=workFlowIntanceService.getWorkflowInstanceXmlModel(workFlowInstanceVo);
			WorkFlowXml xmlModel = WorkFlowXmlUtil
					.getInstanceModel(workFlowInstanceVo);
			// WorkFlowXml xmlModel=workFlowInstanceVo.getXmlModel();
			ActivityModel aModel = xmlModel.getActivity(activityVo
					.getActivityDefinitionId());
			// ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
			// ServletActionContext.getResponse().setCharacterEncoding("utf-8");
			// ServletActionContext.getResponse().getWriter().println("<?xml version=\"1.0\" encoding=\"GBK\"?>");
			// ServletActionContext.getResponse().getWriter().println(aModel.getResources());

			ServletActionContext.getResponse().setCharacterEncoding("utf-8");
			ServletActionContext.getResponse().setContentType("text/xml");
			ServletActionContext.getResponse().getWriter().println(
					"<?xml version=\"1.0\" encoding=\"utf-8\"?>");
			ServletActionContext.getResponse().getWriter().println(
					aModel.getResources());
			// OutputFormat format = OutputFormat.createPrettyPrint();
			// format.setEncoding("GBK");
			// format.setTrimText(false);
			// format.setOmitEncoding(false);
			//			
			// XMLWriter writer = null;
			// writer = new
			// XMLWriter(ServletActionContext.getResponse().getOutputStream(),
			// format);
			// // 写入xlst
			// writer.processingInstruction("xml","version=\"1.0\" encoding=\"GBK\"");
			// writer.write(aModel.getResourcesNode());
			// ServletActionContext.getResponse().getOutputStream().flush();
			// ServletActionContext.getResponse().getOutputStream().close();
		}
		return Action.NONE;
	}

	private boolean permitDel(PfTaskVo taskVo) {
		if (!SessionUtil.getUserInfo(ServletActionContext.getRequest())
				.isAdmin()) {
			PfActivityVo activityVo = taskService.getActivity(taskVo
					.getActivityId());
			PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService
					.getWorkflowInstance(activityVo.getWorkflowInstanceId());
			WorkFlowXml workXml = WorkFlowXmlUtil
					.getInstanceModel(workFlowInstanceVo);
			// WorkFlowXml workXml
			// =workFlowIntanceService.getWorkflowInstanceXmlModel(workFlowInstanceVo);
			if (!workXml.getBeginActivityDefine().equals(
					activityVo.getActivityDefinitionId())) {
				return false;
			}
		}
		return true;
	}

	public boolean isHasDel() {
		return hasDel;
	}

	public void setHasDel(boolean hasDel) {
		this.hasDel = hasDel;
	}

    public String getDefaultName() {
        return defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }
    public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public PfTaskVo getTaskVo() {
		return taskVo;
	}

	public void setTaskVo(PfTaskVo taskVo) {
		this.taskVo = taskVo;
	}

	public PfActivityVo getActivityVo() {
		return activityVo;
	}

	public void setActivityVo(PfActivityVo activityVo) {
		this.activityVo = activityVo;
	}

	public PfWorkFlowInstanceVo getWorkFlowInstanceVo() {
		return workFlowInstanceVo;
	}

	public void setWorkFlowInstanceVo(PfWorkFlowInstanceVo workFlowInstanceVo) {
		this.workFlowInstanceVo = workFlowInstanceVo;
	}

	public PfWorkFlowDefineVo getWorkFlowDefineVo() {
		return workFlowDefineVo;
	}

	public void setWorkFlowDefineVo(PfWorkFlowDefineVo workFlowDefineVo) {
		this.workFlowDefineVo = workFlowDefineVo;
	}

    public List<RiskModel> getRiskList() {
        return riskList;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

	public String getReadOnly() {
		return readOnly;
	}

	public void setReadOnly(String readOnly) {
		this.readOnly = readOnly;
	}
	public boolean isCanDelOthers() {
        return canDelOthers;
    }

    public boolean isHasSave() {
        return hasSave;
    }

    public void setHasSave(boolean hasSave) {
        this.hasSave = hasSave;
    }

    public boolean isQuickTurn() {
        return quickTurn;
    }

    public void setQuickTurn(boolean quickTurn) {
        this.quickTurn = quickTurn;
    }

    public int getMenuCount() {
        return menuCount;
    }

    public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public SysWorkFlowInstanceService getWorkFlowIntanceService() {
		return workFlowIntanceService;
	}

	public void setWorkFlowIntanceService(
			SysWorkFlowInstanceService workFlowIntanceService) {
		this.workFlowIntanceService = workFlowIntanceService;
	}
	public boolean isTaskRemark() {
        return taskRemark;
    }

    public void setTaskRemark(boolean taskRemark) {
        this.taskRemark = taskRemark;
    }

    public List<PfTaskVo> getBeforeTasks() {
        return beforeTasks;
    }

    public void setBeforeTasks(List<PfTaskVo> beforeTasks) {
        this.beforeTasks = beforeTasks;
    }

    public int getFileCenterNodeId() {
        return fileCenterNodeId;
    }

    public void setFileCenterNodeId(int fileCenterNodeId) {
        this.fileCenterNodeId = fileCenterNodeId;
    }

    public String getFileTokenId() {
        return fileTokenId;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public boolean isHasFinish() {
        return hasFinish;
    }

    public SysActivityService getActivityService() {
        return activityService;
    }

    public void setActivityService(SysActivityService activityService) {
        this.activityService = activityService;
    }


	public String getKcdjTypeConfig() {
		return kcdjTypeConfig;
	}


	public void setKcdjTypeConfig(String kcdjTypeConfig) {
		this.kcdjTypeConfig = kcdjTypeConfig;
	}


	public String getBusiType() {
		return busiType;
	}


	public void setBusiType(String busiType) {
		this.busiType = busiType;
	}

    public boolean isCmsEnabled() {
        return cmsEnabled;
    }

    public void setCmsEnabled(boolean cmsEnabled) {
        this.cmsEnabled = cmsEnabled;
    }
}
