package com.gtis.web.action;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.BaseDao;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TaskAction {
    private String taskid;
    private WorkFlowCoreService workFlowService;
    private SysTaskService taskService;
    private SysWorkFlowInstanceService intanceService;
    private SysStuffService stuffService;
    private SysDynamicSignService dynamicSignService;
    private BaseDao sjdDaoImpl;
    private NodeService nodeService;
	private String remark;
    private String wiid;

    static final org.apache.commons.logging.Log log = LogFactory.getLog(TaskAction.class);

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public WorkFlowCoreService getWorkFlowService() {
        return workFlowService;
    }

    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }

    public String delOtherTasks() throws Exception {
        PfTaskVo taskVo=taskService.getTask(taskid);
        if (taskVo!=null){
            taskService.deleteOtherTasks(taskid);
            ServletActionContext.getResponse().getWriter().println("true");
        }else{
            ServletActionContext.getResponse().getWriter().println("该任务已被别人取件！");
        }
        return Action.NONE;
    }
    /**
     * 批量转发
     *
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        String userId =SessionUtil.getCurrentUserId();
        try {
            WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId,taskid);
            // 处理活动
            List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
            // /如果splittype为xor
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
//			WorkFlowXml workXml = WorkFlowXmlUtil.getWorkflowInstanceXmlModel(info.getWorkFlowIntanceVo());
//          WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            ActivityModel activityModel = workXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
            if ( StringUtils.isBlank(activityModel.getSplitType()) || activityModel.getSplitType().equalsIgnoreCase("XOR")) {
                int i = 0;
                for (Iterator<ActivityModel> it = lstActivityModel.iterator();it.hasNext();) {
                    if (i > 0) {
                        it.remove();
                    }
                    it.next();
                    i++;
                }
            }
            // 备注
            //info.getTransInfo().setRemark("批量转发");
            //开始转发
            workFlowService.postWorkFlow(userId, taskid, info);
        } catch(WorkFlowException wfex){
            log.debug(wfex.getMessage());
            ServletActionContext.getResponse().getWriter().println(wfex.getMessage());
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return Action.NONE;
    }

    /**
     * 删除
     * 管理员 或 在首节点,同时也是创建人 可删除工作流;
     * 在首节点，不是创建人,是参与者 可删除所属任务;
     * 在首节点，不是创建人和参与者 或 不在首节点  无法删除
     *
     * @return
     * @throws Exception
     */
    public String del() throws Exception {
        PfTaskVo taskVo = taskService.getTask(taskid);
        switch(permitDel(taskVo)){
            case 0:{
                delProject(taskVo);
                ServletActionContext.getResponse().getWriter().println(1);
                break;
            }
            case 1:{
                delProject(taskVo);
                ServletActionContext.getResponse().getWriter().println(1);
                break;
            }
            default:{
                ServletActionContext.getResponse().getWriter().println(2);
            }
        }
        return Action.NONE;
    }

    /**
     * 删除工作流
     * @param taskVo
     * @return
     * @throws Exception
     */
    private String delProject(PfTaskVo taskVo) throws Exception {
        PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
        this.wiid = activityVo.getWorkflowInstanceId();
        delProject();
        return Action.NONE;
    }

    public String restartProject() throws Exception {
        boolean restart = workFlowService.restartWorkFlow(SessionUtil.getUserId(ServletActionContext.getRequest()),wiid,null);
        ServletActionContext.getResponse().getWriter().println(restart);
        return Action.NONE;
    }

    /**
     * 删除项目，项目列表用的
     * @return
     * @throws Exception
     */
    public String delProject() throws Exception {
        PfWorkFlowInstanceVo workFlowInstanceVo = intanceService.getWorkflowInstance(this.wiid);
        try {
            //删除附件
            PfWorkFlowInstanceVo intanceVo = intanceService.getWorkflowInstance(this.wiid);
            Space space = nodeService.getWorkSpace(StuffManageAction.WORK_FLOW_STUFF);
            Node tempNode = nodeService.getNode(space.getId(), intanceVo.getProId());
            nodeService.remove(tempNode.getId());
        } catch (Exception e) {
        }
        //删除用户签名
        try {
            dynamicSignService.deleteUserSignByProId(workFlowInstanceVo.getProId());
        } catch (Exception e) {
        }
        //删除收件单
        try {
        	HashMap param = new HashMap();
        	param.put("PROID", workFlowInstanceVo.getProId());
        	sjdDaoImpl.deleteObject(param);
        } catch (Exception e) {
        }
        //删除工作流实例
        try{
            workFlowService.deleteWorkFlowInstance(SessionUtil.getUserId(ServletActionContext.getRequest()), this.wiid);
        }catch(WorkFlowException ex){
            ServletActionContext.getResponse().getWriter().println(ex.getMessage());
        }
        return Action.NONE;
    }

    /**
     * 判断删除情况
     * @param taskVo
     * @return 0 超级用户 或 在首节点,同时也是创建人;1 在首节点，不是创建人;是参与者(参与者只有一人时);2 在首节点，不是创建人;是参与者(参与者有多人时) 3在首节点，不是创建人和参与者 和 该项目不在首节点，无法删除 5 无返回
     */
    private int permitDel(PfTaskVo taskVo) throws Exception{
        if (SessionUtil.getUserInfo(ServletActionContext.getRequest()).isAdmin()) {
            return 0;
        }else {
            String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
            PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
            PfWorkFlowInstanceVo workFlowInstanceVo = intanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            //WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId,taskid);
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            if (workXml.getBeginActivityDefine().equals(activityVo.getActivityDefinitionId())) {
                if(workFlowInstanceVo.getCreateUser().equals(SessionUtil.getUserId(ServletActionContext.getRequest()))){
                    return 0;
                }else {
                    if(userId.equals(taskVo.getUserVo().getUserId())){
                        int count = taskService.getAllTaskCountByActivityId(activityVo.getActivityId());
                        if(count == 1){
                            return 1;
                        }else {
                            return 2;
                        }
                    }else {
                        return 3;
                    }
                }
            }
        }
        return 5;
    }

	/**
	 * 挂起
	 *
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("deprecation")
	public String post() throws Exception {
		PfTaskVo taskVo = taskService.getTask(taskid);
		PfActivityVo activityVo = taskService.getActivity(taskVo
				.getActivityId());
        String decode =null;
        if (!StringUtils.isBlank(this.remark))
		    decode = java.net.URLDecoder.decode(this.remark,"utf-8");
		workFlowService
				.lockWorkFlowInstance(activityVo.getWorkflowInstanceId(),taskid,decode);
		ServletActionContext.getResponse().getWriter().println("true");
		return Action.NONE;
	}


    /**
     * 解挂
     *
     * @return
     * @throws Exception
     */
    public String unpost() throws Exception {
        PfTaskVo taskVo = taskService.getTask(taskid);
        PfActivityVo activityVo = taskService.getActivity(taskVo
                .getActivityId());
        workFlowService.unLockWorkFlowInstance(activityVo
                .getWorkflowInstanceId());
        ServletActionContext.getResponse().getWriter().println("true");
        return Action.NONE;
    }

    /**
     * 取回
     * @return
     * @throws Exception
     */
    public String retrieve() throws Exception {
        if (!StringUtils.isBlank(taskid)) {
            try {
                this.workFlowService.retrieveWorkFlow(SessionUtil.getUserId(ServletActionContext.getRequest()), taskid);
            } catch (Exception e) {
                //ex.printStackTrace();
//                ServletActionContext.getResponse().setContentType("text/xml");
                ServletActionContext.getResponse().getWriter().println(e.getMessage());
            }
        }
        return Action.NONE;
    }

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysWorkFlowInstanceService getIntanceService() {
        return intanceService;
    }

    public void setIntanceService(SysWorkFlowInstanceService intanceService) {
        this.intanceService = intanceService;
    }

    public SysStuffService getStuffService() {
        return stuffService;
    }

    public void setStuffService(SysStuffService stuffService) {
        this.stuffService = stuffService;
    }


    public SysDynamicSignService getDynamicSignService() {
        return dynamicSignService;
    }

    public void setDynamicSignService(SysDynamicSignService dynamicSignService) {
        this.dynamicSignService = dynamicSignService;
    }

    public NodeService getNodeService() {
        return nodeService;
    }

	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

	public BaseDao getSjdDaoImpl() {
		return sjdDaoImpl;
	}

	public void setSjdDaoImpl(BaseDao sjdDaoImpl) {
		this.sjdDaoImpl = sjdDaoImpl;
	}
}
