package com.gtis.web.action;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.opensymphony.xwork2.Action;

public class ShowFlowRemarkAction {

	SysWorkFlowInstanceService workFlowInstanceService;
    SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService;
	SysTaskService taskService;
	SysWorkFlowDefineService workFlowDefineService;
	String wiid;
	String taskid;
	List<PfActivityVo> activityList;
    List<Map<String,Object>> workFlowInstanceList;
//	List<PfTaskVo> taskOverList;
//	List<PfTaskVo> taskList;
	static Log log = LogFactory.getLog(ShowFlowRemarkAction.class);

	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public List<PfActivityVo> getActivityList() {
		return activityList;
	}

	public void setActivityList(List<PfActivityVo> activityList) {
		this.activityList = activityList;
	}

//	public List<PfTaskVo> getTaskOverList() {
//		return taskOverList;
//	}
//
//	public void setTaskOverList(List<PfTaskVo> taskOverList) {
//		this.taskOverList = taskOverList;
//	}
//
//	public List<PfTaskVo> getTaskList() {
//		return taskList;
//	}
//
//	public void setTaskList(List<PfTaskVo> taskList) {
//		this.taskList = taskList;
//	}

	public String execute() throws Exception {
		if (taskid != null && !taskid.equals("")) {
			PfTaskVo taskVo = taskService.getTaskAll(taskid);
			PfActivityVo activityVo = taskService.getActivity(taskVo
					.getActivityId());
			wiid = activityVo.getWorkflowInstanceId();
		}
		activityList = taskService.getWorkFlowInstanceAllActivityList(wiid);
//		taskList = taskService.getTaskListByInstance(wiid);
//		taskOverList = taskService.getHistoryTaskListByInstance(wiid);
//		// 把办结任务中重复的人员去掉
//		List<String> taskIds = new ArrayList<String>();
//		for (PfActivityVo activityVo : activityList) {
//			String activityId = activityVo.getActivityId();
//			List<String> userIds = new ArrayList<String>();
//			for (PfTaskVo taskVo : taskOverList) {
//				if (taskVo.getActivityId().equals(activityId)) {
//					if (userIds.contains(taskVo.getUserVo().getUserId())) {
//						taskIds.add(taskVo.getTaskId());
//					} else {
//						userIds.add(taskVo.getUserVo().getUserId());
//					}
//				}
//			}
//			for (PfTaskVo taskVo : taskList) {
//				if (taskVo.getActivityId().equals(activityId)) {
//					if (userIds.contains(taskVo.getUserVo().getUserId())) {
//						taskIds.add(taskVo.getTaskId());
//						for (PfTaskVo taskVo1 : taskOverList) {
//							if (taskVo1.getActivityId().equals(activityId)
//									&& taskVo.getTaskId().equals(
//											taskVo.getUserVo().getUserId())) {
//								taskIds.add(taskVo1.getTaskId());
//							}
//						}
//					}
//				}
//			}
//		}
//		for (String taskId : taskIds) {
//			for (PfTaskVo taskVo : taskOverList) {
//				if (taskVo.getTaskId().equals(taskId)) {
//					taskOverList.remove(taskVo);
//                    break;
//				}
//			}
//		}
		PfWorkFlowInstanceVo pfWorkFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
		ServletActionContext.getRequest().setAttribute("workflowIntanceName", pfWorkFlowInstanceVo.getWorkflowIntanceName());
		return Action.SUCCESS;
	}



    public String fullWorkflowChart() throws Exception {
        workFlowInstanceList = new ArrayList<Map<String,Object>>();
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
        getFullWorkflowList(pfWorkFlowInstanceVo);
        Collections.sort(workFlowInstanceList, new Comparator<Map<String, Object>>() {
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return((Date)o1.get("createTime")).compareTo((Date)o2.get("createTime"));
            }
        });
        return "full";
    }

    private void getFullWorkflowList(PfWorkFlowInstanceVo pfWorkFlowInstanceVo){
        if(isExistWorkflow(pfWorkFlowInstanceVo))
            return;
        Map tmpWorkflowMap = new HashMap();
        tmpWorkflowMap.put("wiid",pfWorkFlowInstanceVo.getWorkflowIntanceId());
        tmpWorkflowMap.put("workflowIntanceName",pfWorkFlowInstanceVo.getWorkflowIntanceName());
        tmpWorkflowMap.put("workflowState",pfWorkFlowInstanceVo.getWorkflowState());
        tmpWorkflowMap.put("createTime",pfWorkFlowInstanceVo.getCreateTime());
        tmpWorkflowMap.put("finishTime",pfWorkFlowInstanceVo.getFinishTime());
        tmpWorkflowMap.put("handlesDay",pfWorkFlowInstanceVo.getHandlesDay());
        tmpWorkflowMap.put("workflowDefinitionName",workFlowDefineService.getWorkFlowDefine(pfWorkFlowInstanceVo.getWorkflowDefinitionId()).getWorkflowName());
        workFlowInstanceList.add(tmpWorkflowMap);
        List<PfWorkFlowInstanceVo> nextWorkflowInstanceList = sysWorkFlowInstanceRelService.getWorkFlowRelList(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        for(PfWorkFlowInstanceVo nextWorkflow:nextWorkflowInstanceList){
            getFullWorkflowList(nextWorkflow);
        }
    }

    private boolean isExistWorkflow(PfWorkFlowInstanceVo pfWorkFlowInstanceVo){
        for(Map workflow:workFlowInstanceList){
            if(workflow.get("wiid").equals(pfWorkFlowInstanceVo.getWorkflowIntanceId()))
                return true;
        }
        return false;
    }

	public SysWorkFlowInstanceService getWorkFlowInstanceService() {
		return workFlowInstanceService;
	}

	public void setWorkFlowInstanceService(
			SysWorkFlowInstanceService workFlowInstanceService) {
		this.workFlowInstanceService = workFlowInstanceService;
	}

	public String getWiid() {
		return wiid;
	}

	public void setWiid(String wiid) {
		this.wiid = wiid;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

    public List<Map<String, Object>> getWorkFlowInstanceList() {
        return workFlowInstanceList;
    }

    public void setWorkFlowInstanceList(List<Map<String, Object>> workFlowInstanceList) {
        this.workFlowInstanceList = workFlowInstanceList;
    }

    public SysWorkFlowInstanceRelService getSysWorkFlowInstanceRelService() {
        return sysWorkFlowInstanceRelService;
    }

    public void setSysWorkFlowInstanceRelService(SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService) {
        this.sysWorkFlowInstanceRelService = sysWorkFlowInstanceRelService;
    }
}
