package com.gtis.web.action;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

public class ProjectHandleAction {
    String proid;
    String wiid;
    String wdno;
    SysTaskService taskService;
    SysWorkFlowInstanceService workFlowIntanceService;
    SysWorkFlowDefineService workFlowDefineService;
    SysMenuService menuService;
    NodeService nodeService;   //用来获取附件

    PfWorkFlowInstanceVo workFlowInstanceVo;
    PfWorkFlowDefineVo workFlowDefineVo;
    String menu;
    boolean disable = true;
    private static final String CONTENT_TYPE = "text/html; charset=utf-8";
    private String fileTokenId;   //文件中心用tokenid
    private int fileCenterNodeId;
    //勘测定界扩展属性配置
    private String kcdjTypeConfig;
    private String busiType;

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public String getActivityNames() throws Exception{
        StringBuffer userNameBuffer=new StringBuffer();
        if (StringUtils.isNotBlank(wiid)) {
            List<PfActivityVo> activityVoList= taskService.getWorkFlowInstanceActivityList(wiid);
            int size=0;
            for (PfActivityVo activityVo:activityVoList) {
                size++;
                if (size==2 && activityVoList.size()>2) {
                    userNameBuffer.append(activityVo.getActivityName() + "等");
                }else{
                    userNameBuffer.append(activityVo.getActivityName() + " ");
                }
            }
        }
        ServletActionContext.getResponse().getWriter().println(userNameBuffer.toString());
        return Action.NONE;
    }

    public String execute() throws Exception {
        if (wiid != null && !wiid.equals("")) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
        } else {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
        }
        if (workFlowInstanceVo!=null){
            workFlowDefineVo= workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            wiid = workFlowInstanceVo.getWorkflowIntanceId();
        }else if(StringUtils.isNotBlank(wdno)){
            workFlowDefineVo= workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        if (workFlowDefineVo==null){
            ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
            ServletActionContext.getResponse().getWriter().println("工作流异常，请检查工作流定义！");
            return Action.NONE;
        }
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
        this.disable = xmlDao.isDisable();
        ///////客户端用来获取附件////////////////////////////////////////
        Space space = nodeService.getWorkSpace(StuffManageAction.WORK_FLOW_STUFF, true);
        try {
            Node node=null;
            if (StringUtils.isBlank(wiid))
                node = nodeService.getNode(space.getId(), proid, true);
            else
                node = nodeService.getNode(space.getId(), wiid, false);
            if (node != null) {
                fileTokenId = nodeService.getToken(node);
                fileCenterNodeId = node.getId();
            }
        } catch (Exception ex) {

        }
        ////////////////////////////////////////////////////////////
        //扩展属性中关于勘测定界管理模块的配置属性获取
        kcdjTypeConfig = xmlDao.getExtendedAttribute("KcdjTypeConfig") + "";
        busiType = xmlDao.getExtendedAttribute("BusiType") + "";
        if (StringUtils.isBlank(busiType)) {
            busiType = xmlDao.getExtendedAttribute("busiType") + "";
        }
        return Action.SUCCESS;
    }

    public String menu() throws Exception {
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
        //ServletActionContext.getResponse().setCharacterEncoding("GBK");
        String roles = SessionUtil.getUserInfo(
                ServletActionContext.getRequest()).getRoleIds();
        if (wiid != null && !wiid.equals("")) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
        } else {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
        }
        if (workFlowInstanceVo!=null){
            workFlowDefineVo= workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
        }else if(StringUtils.isNotBlank(wdno)){
            workFlowDefineVo= workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        List<PfResourceVo> lstResult = menuService.getProjectMenu(roles,
                workFlowDefineVo.getWorkflowDefinitionId());

        /**
         * 此处主要是存放已经插入的菜单，如果存在id和name相同的资源，则不再重复插入
         */
        HashMap<String, String> insertedMenuMap = new HashMap<String, String>();

        if (lstResult != null) {
            HttpServletResponse response = ServletActionContext.getResponse();
            StringBuilder menuResponse = new StringBuilder();
            menuResponse.append("[");
            for (int i = 0; i < lstResult.size(); i++) {
                PfResourceVo menuVo = lstResult.get(i);

                String tempKey = menuVo.getResourceId() + "_" + menuVo.getResourceName();
                if (insertedMenuMap.get(tempKey) != null) {
                    //System.out.println(")^^^^^^^^^^^^^^^^menuVo="+menuVo.getResourceName());
                    continue;
                }
                insertedMenuMap.put(tempKey, tempKey);

                if (!menuResponse.toString().endsWith(",") && !menuResponse.toString().endsWith("["))
                    menuResponse.append(",");
                menuResponse.append(
                        "{id: '" + menuVo.getResourceId() + "',text: '"
                                + menuVo.getResourceName() + "',leaf: true}");
            }
            menuResponse.append("]");
            response.getWriter().println(menuResponse);
        }
        return Action.NONE;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public String getFileTokenId() {
        return fileTokenId;
    }

    public int getFileCenterNodeId() {
        return fileCenterNodeId;
    }

    public boolean isDisable() {
        return disable;
    }

    public String getMenu() {
        return menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }

    public SysWorkFlowInstanceService getWorkFlowIntanceService() {
        return workFlowIntanceService;
    }

    public void setWorkFlowIntanceService(
            SysWorkFlowInstanceService workFlowIntanceService) {
        this.workFlowIntanceService = workFlowIntanceService;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return workFlowDefineService;
    }

    public void setWorkFlowDefineService(
            SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public PfWorkFlowInstanceVo getWorkFlowInstanceVo() {
        return workFlowInstanceVo;
    }

    public void setWorkFlowInstanceVo(PfWorkFlowInstanceVo workFlowInstanceVo) {
        this.workFlowInstanceVo = workFlowInstanceVo;
    }

    public PfWorkFlowDefineVo getWorkFlowDefineVo() {
        return workFlowDefineVo;
    }

    public void setWorkFlowDefineVo(PfWorkFlowDefineVo workFlowDefineVo) {
        this.workFlowDefineVo = workFlowDefineVo;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public SysMenuService getMenuService() {
        return menuService;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public String getKcdjTypeConfig() {
        return kcdjTypeConfig;
    }

    public void setKcdjTypeConfig(String kcdjTypeConfig) {
        this.kcdjTypeConfig = kcdjTypeConfig;
    }

    public String getBusiType() {
        return busiType;
    }

    public void setBusiType(String busiType) {
        this.busiType = busiType;
    }

    public String getWdno() {
        return wdno;
    }

    public void setWdno(String wdno) {
        this.wdno = wdno;
    }
}
