package com.gtis.web.action;

import java.util.HashMap;
import com.gtis.rss.RssAction;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;

public class NewsListAction extends RssAction {
	private SplitParam splitParam;
	private String type;
    private int daysIn;
    
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String execute() throws Exception {
		SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("getNewListByType");
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("NEW_TYPE", type);
		splitParam1.setQueryParam(mapParam);
		splitParam=splitParam1;
		return Action.SUCCESS;
	}

	public String rss() throws Exception {
		splitParam = new SplitParamImpl();
		splitParam.setQueryString("getNewListAllByType");
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("type", type);
		splitParam.setQueryParam(mapParam);
		super.setRssParam(splitParam);
		return super.rss();
	}

    public SplitParam getSplitParam() {
		return splitParam;
	}
	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}
    public int getDaysIn() {
        return daysIn;
    }
    public void setDaysIn(int daysIn) {
        this.daysIn = daysIn;
    }
}
