package com.gtis.web.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.annotations.JSON;
import com.gtis.plat.service.SysSupervisorService;
import com.gtis.web.SplitDataAction;

public class MySplitDataAction extends SplitDataAction {
	SysSupervisorService supervisorService;
	
	@Override
	public List<Object> getRows() {
		return super.getRows();
	}

	@Override
	public int getTotalCount() {
		return super.getTotalCount();
	}

	@JSON(deserialize = false, serialize = false)
	public SysSupervisorService getSupervisorService() {
		return supervisorService;
	}

	public void setSupervisorService(SysSupervisorService supervisorService) {
		this.supervisorService = supervisorService;
	}

	@Override
	public String execute() throws Exception {
		super.execute();
		List<Object> rows = getRows();
		if (rows != null) {
			for (Object obj : rows) {
				HashMap map = (HashMap) obj;
				map.put("EXC1", null);
				String workflowInstanceId = map.get("WORKFLOW_INSTANCE_ID").toString();
				List<HashMap> mapList = supervisorService.getExceptionInfo(workflowInstanceId);
				HashSet<String> activityNames = new HashSet<String>();
				for (HashMap hashMap : mapList) {
					if (Integer.parseInt(hashMap.get("ACTIVITY_STATE").toString()) == 1) {
						if (hashMap.get("ACTIVITY_NAME") != null) {
							activityNames.add(hashMap.get("ACTIVITY_NAME").toString());
						}
					}
					if (hashMap.get("TIME_LIMIT")!=null&&isInteger(hashMap.get("TIME_LIMIT").toString())&&Integer.parseInt(hashMap.get("TIME_LIMIT").toString()) != -1) {
						int timeLimit = Integer.parseInt(hashMap.get(
								"TIME_LIMIT").toString());
						int handlDay = Integer.parseInt(hashMap.get(
								"HANDLES_DAY").toString());
						if (map.get("ACTIVITY_RESIDUAL") != null) {
							int activity_residual_now = Integer.parseInt(map.get("ACTIVITY_RESIDUAL").toString());
							if (activity_residual_now > (timeLimit - handlDay)) {
								map.put("ACTIVITY_RESIDUAL", timeLimit
										- handlDay);
							}
						} else {
							map.put("ACTIVITY_RESIDUAL", timeLimit - handlDay);
						}
					}

					if (hashMap.get("EXCEPTION_TYPE") != null) {
						if (Integer.parseInt(hashMap.get("EXCEPTION_TYPE").toString()) == 1) {
							map.put("EXC1", 1);
						}
					}
				}
				StringBuffer sb = new StringBuffer();
				Iterator<String> iter = activityNames.iterator();
				for (int i = 0; iter.hasNext(); i++) {
					if (i != 0) {
						sb.append(",");
					}
					sb.append(iter.next());
				}
				map.put("ACTIVITY_NAME", sb.toString());
			}
		}

		return SUCCESS;
	}

	private boolean isInteger(String str) {
		if (str == null) {
			return false;
		}
		Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
		return pattern.matcher(str).matches();
	}

}
