package com.gtis.web.action;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.text.SimpleDateFormat;
import java.util.*;

import com.gtis.plat.dao.LogDAO;

/**
 * Created by IntelliJ IDEA.
 * User: jibo
 * Date: 11-8-1
 * Time: 下午12:39
 * To change this template use File | Settings | File Templates.
 */
public class LogListAction {
    /**
     * 分页
     */
    private SplitParam splitParam;
    private String year;
    private String month;
    private String day;
    private Map<String, String> monthMap;
    private Map<String, String> yearMap;
    private String logaction;

    public static final SimpleDateFormat format = new SimpleDateFormat(
            "yyyy-MM-dd");
    private LogDAO logDao;

    public String getLogaction() {
        return logaction;
    }

    public void setLogaction(String logaction) {
        this.logaction = logaction;
    }

    public Map<String, String> getMonthMap() {
        return monthMap;
    }

    public Map<String, String> getYearMap() {
        return yearMap;
    }

    public LogDAO getLogDao() {
        return logDao;
    }

    public void setLogDao(LogDAO logDao) {
        this.logDao = logDao;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDay() {
        return day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public String execute() throws Exception {
        SplitParamImpl splitParam1 = new SplitParamImpl();
        splitParam1.setQueryString("querylog");
        //splitParam1.setQueryParam(getParam());
        splitParam = splitParam1;
        return Action.SUCCESS;
    }

    public String statmonth() throws Exception {
        if (StringUtils.isBlank(year)) year = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        if (StringUtils.isBlank(month)) month = String.valueOf(Calendar.getInstance().get(Calendar.MONTH) + 1);
        initYearAndMonthMap();
        return "statmonth";
    }

    public String getMonthData() throws Exception {
        if (StringUtils.isBlank(year)) year = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        if (StringUtils.isBlank(month)) month = String.valueOf(Calendar.getInstance().get(Calendar.MONTH) + 1);
        List resultList = logDao.statMonthLog(getBeginDate(year, month), getEndDate(year, month),logaction);
        HashMap mapresult = new HashMap();
        mapresult.put("MAX", getMaxValue(resultList));
        mapresult.put("RESULT", resultList);
        ServletActionContext.getResponse().getWriter().println(ObjectJSONUtil.ObjectToJson(mapresult));
        return Action.NONE;
    }

    private static String getMaxValue(List<Map> resultList) {
        int result = 0;
        for (Map mapResult : resultList) {
            if (Integer.parseInt(mapResult.get("COUNT").toString()) > result)
                result = Integer.parseInt(mapResult.get("COUNT").toString());
        }
        if (result < 10)
            result = 10;
        else
            result = (int) (Math.ceil(result / 10) + 1) * 10;
        return String.valueOf(result);
    }

    public static String getBeginDate(String year, String month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, Integer.parseInt(year));
        calendar.set(Calendar.MONTH, Integer.parseInt(month) - 1);
        int day = calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        return java.text.MessageFormat.format("{0}-{1}-{2}", year, month, day);
    }

    public static String getEndDate(String year, String month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, Integer.parseInt(year));
        calendar.set(Calendar.MONTH, Integer.parseInt(month) - 1);
        int day = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        return java.text.MessageFormat.format("{0}-{1}-{2}", year, month, day);
    }

    public void initYearAndMonthMap(){
        //月
        monthMap=new LinkedHashMap<String, String>();
        for(int i=1;i<13;i++){
            monthMap.put(String.valueOf(i), String.valueOf(i));
        }
        //年
        yearMap=new LinkedHashMap<String, String>();
        for(int i=1;i<10;i++){
            yearMap.put(String.valueOf(2009+i),String.valueOf(2009+i));
        }

    }
    public static void main(String[] Param) {
        System.out.print(getEndDate("2011", "06"));
        System.out.print(getBeginDate("2011", "06"));
    }
}
