package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.struts2.ServletActionContext;

import java.util.*;

public class CreateTaskAction extends ActionSupport{
    /** 用户服务 */
	private SysUserService userService;
    /** 工作流定义服务 */
	private SysWorkFlowDefineService workFlowDefineService;
    /** 核心工作流服务 */
	private WorkFlowCoreService workFlowCoreService;
    /**行政区服务*/
    private SysDistrictService sysDistrictService;
    /** 用户名 */
	private String userName;
    /** 部门名 */
	private String organName;
    /** 工作流实例名 */
	private String instanceName;
    /** 工作流定义名 */
	private String workFlowName;
    /** 优先级 */
	private String proselect;
    /** 工作流时限 */
	private String timeLimit;
    /** 创建时间 */
	private Date createTime;
    /** 备注 */
	private String remark;
    /**项目所属区域*/
    private String district;

	private String message;
    /** 工作流定义Id */
	private String wdid;
    /** 优先级 */
	private LinkedHashMap<String, String> proMap;
    /** 业务名 */
	private String businessName;
    /** 任务Id */
	private String taskId;
    /** 工作流名模板 */
    private String workFlowNameTemple;
    /**所属地区*/
    private List<PfDistrictVo> districtList;
    /** 部门列表*/
    private List<PfOrganVo> organList;
    /**部门代码*/
    private String regionCode;
    
	public CreateTaskAction() {
		proMap = new LinkedHashMap<String, String>();
		proMap.put("1", "普通");
		proMap.put("2", "紧急");
		proMap.put("3", "特急");
	}

	public String execute() throws Exception {
		PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService
				.getWorkFlowDefine(wdid);
		PfBusinessVo businessVo = workFlowDefineService
				.getBusiness(workFlowDefineVo.getBusinessId());

		businessName = businessVo.getBusinessName();
		workFlowName = workFlowDefineVo.getWorkflowName();
		proselect = workFlowDefineVo.getPriority();
		remark = workFlowDefineVo.getRemark();
		timeLimit = workFlowDefineVo.getTimeLimit();
		createTime = Calendar.getInstance().getTime();


		UserInfo userInfo = SessionUtil.getUserInfo(ServletActionContext
				.getRequest());
		userName = userInfo.getUsername();
        organList = userInfo.getLstOragn();
		if (userInfo.getLstOragn() != null && userInfo.getLstOragn().size() > 0) {
            organName = userInfo.getLstOragn().get(0).getOrganName();
            regionCode = userInfo.getLstOragn().get(0).getRegionCode();
        }
        getWorkflowDistrict();
		return Action.SUCCESS;
	}


    private void getWorkflowDistrict(){

        String defaultDistrictCode = AppConfig.getProperty("district.code");
        if(StringUtils.isNotBlank(defaultDistrictCode))
            districtList = sysDistrictService.querySubDistrictByCode(AppConfig.getProperty("district.code"));
        else
            districtList = sysDistrictService.queryAllDistrict();
    }

    /**
     * 创建工作流
     * @return
     */
	public String create() throws Exception{
		PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
		try {
            getWorkflowDistrict();
//			ServletActionContext.getRequest().setCharacterEncoding("GBK");
			String userId = SessionUtil.getCurrentUserId();
            organList = SessionUtil.getCurrentUser().getLstOragn();
			String proId = UUIDGenerator.generate();
			intanceVo.setWorkflowDefinitionId(wdid);
			intanceVo.setWorkflowIntanceId(proId);
			intanceVo.setProId(proId);
			intanceVo.setRemark(remark);
			intanceVo.setTimeLimit(timeLimit);
			intanceVo.setPriority(proselect);
			intanceVo.setWorkflowIntanceName(instanceName);
            if(StringUtils.isNotBlank(regionCode))
                intanceVo.setRegionCode(regionCode);
            if(StringUtils.isBlank(district))
                district = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            intanceVo.setDistrict(district);
			WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(
					intanceVo, userId);
			for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
				if (taskVo.getUserVo().getUserId().equals(userId)) {
					taskId = taskVo.getTaskId();
					break;
				}
			}
			if (org.apache.commons.lang3.StringUtils.isNotBlank(taskId)) {
				for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
					taskId = taskVo.getTaskId();
					break;
				}
			}
            ServletActionContext.getResponse().getOutputStream().print("ok,"+taskId);
			message = "ok";
		} catch (Exception e) {
			message = e.getMessage();
            ServletActionContext.getResponse().getOutputStream().print(e.getMessage());
			e.printStackTrace();
		}
		return Action.NONE;
	}

    /**
     * 默认创建工作流
     * @return
     * @throws Exception
     */
    public String defaultCreate() throws Exception {
        PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(wdid);
        PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
		try {
            if(workFlowNameTemple != null){
                workFlowNameTemple = workFlowNameTemple.trim();
            }
			String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
			String proId = UUIDGenerator.generate();
			intanceVo.setWorkflowDefinitionId(wdid);
			intanceVo.setWorkflowIntanceId(proId);
			intanceVo.setProId(proId);
			intanceVo.setRemark("");
			intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setPriority("1");
            intanceVo.setDistrict(userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
			if(message != null){
                if(message.endsWith("**")){
                    intanceVo.setPriority("3");
                }else if(message.endsWith("*")){
                    intanceVo.setPriority("2");
                }
            }
            HashMap modeMap = new HashMap();
            modeMap.put("WORKFLOW_NAME",workFlowDefineVo.getWorkflowName());
            modeMap.put("FOUNDER",SessionUtil.getUserName(ServletActionContext.getRequest()));
            modeMap.put("CREATE_DATE",CommonUtil.getCurrYearMonthDayHourMinute());
            StrSubstitutor sub = new StrSubstitutor(modeMap, "%{", "}");
            
			intanceVo.setWorkflowIntanceName(sub.replace(workFlowNameTemple));
            
			WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(intanceVo, userId);
            
			for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
				if (taskVo.getUserVo().getUserId().equals(userId)) {
					taskId = taskVo.getTaskId();
					break;
				}
			}
			if (StringUtils.isBlank(taskId)) {                   
				for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
					taskId = taskVo.getTaskId();
					break;
				}
			}
			//message = "ok";
		} catch (Exception e) {
			message = e.getMessage();
			e.printStackTrace();
		}

        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(taskId);
        
        return Action.NONE;
    }

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getOrganName() {
		return organName;
	}

	public void setOrganName(String organName) {
		this.organName = organName;
	}

	public String getInstanceName() {
		return instanceName;
	}

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	public String getWorkFlowName() {
		return workFlowName;
	}

	public void setWorkFlowName(String workFlowName) {
		this.workFlowName = workFlowName;
	}

	public String getProselect() {
		return proselect;
	}

	public void setProselect(String proselect) {
		this.proselect = proselect;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getWdid() {
		return wdid;
	}

	public void setWdid(String wdid) {
		this.wdid = wdid;
	}

	public LinkedHashMap<String, String> getProMap() {
		return proMap;
	}

	public void setProMap(LinkedHashMap<String, String> proMap) {
		this.proMap = proMap;
	}

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

    public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

    public String getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public WorkFlowCoreService getWorkFlowCoreService() {
		return workFlowCoreService;
	}

	public void setWorkFlowCoreService(WorkFlowCoreService workFlowCoreService) {
		this.workFlowCoreService = workFlowCoreService;
	}

    public void setWorkFlowNameTemple(String workFlowNameTemple) {
        this.workFlowNameTemple = workFlowNameTemple;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public SysDistrictService getSysDistrictService() {
        return sysDistrictService;
    }

    public void setSysDistrictService(SysDistrictService sysDistrictService) {
        this.sysDistrictService = sysDistrictService;
    }

    public List<PfDistrictVo> getDistrictList() {
        return districtList;
    }

    public void setDistrictList(List<PfDistrictVo> districtList) {
        this.districtList = districtList;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public List<PfOrganVo> getOrganList() {
        return organList;
    }

    public void setOrganList(List<PfOrganVo> organList) {
        this.organList = organList;
    }
}
